﻿/*
 * vstildr.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of Boare.Cadencii.
 *
 * Boare.Cadencii is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
namespace Boare.Cadencii {

    public interface vstildr {
        event WaveIncomingEventHandler WaveIncoming;
        event RenderingFinishedEventHandler RenderingFinished;

        void Terminate();
        bool Init( char[] dll_path, int block_size, int sample_rate );
        int SendEvent( byte[] src, int[] deltaFrames, int target_track );
        int StartRendering( long total_samples,
                            double amplify_left,
                            double amplify_right );
        void AbortRendering();
        double GetProgress();
    }

}
