﻿/*
 * TextMemoryStream.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

namespace Boare.Lib.Vsq {

    public class TextMemoryStream : IDisposable {
        private static readonly string NL = (char)0x0d + "" + (char)0x0a;

        private List<string> m_lines;
        private int m_index;

        public TextMemoryStream() {
            m_lines = new List<string>();
            m_lines.Add( "" );
            m_index = 0;
        }

        public TextMemoryStream( string path, Encoding encoding ) {
            m_lines = new List<string>();
            m_index = 0;
            if ( File.Exists( path ) ) {
                using ( StreamReader sr = new StreamReader( path, encoding ) ) {
                    while ( sr.Peek() >= 0 ) {
                        string line = sr.ReadLine();
                        m_lines.Add( line );
                        m_index++;
                    }
                }
            }
        }

        public void write( string value ) {
            appendString( value );
        }

        public void writeLine( string value ) {
            appendString( value + NL );
        }

        private void appendString( string value ) {
            string[] lines = value.Split( new string[] { NL }, StringSplitOptions.None );
            List<string> lines2 = new List<string>();
            for ( int i = 0; i < lines.Length; i++ ) {
                string[] spl = lines[i].Split( (char)0x0d, (char)0x0a );
                for ( int j = 0; j < spl.Length; j++ ) {
                    lines2.Add( spl[j] );
                }
            }
            int count = lines2.Count;
            if ( count > 0 ) {
                m_lines[m_index] += lines2[0];
                for ( int i = 1; i < count; i++ ) {
                    m_lines.Add( lines2[i] );
                    m_index++;
                }
            }
        }

        public void rewind() {
            m_index = 0;
        }

        public string readLine() {
            m_index++;
            return m_lines[m_index - 1];
        }

        public int peek() {
            if ( m_index < m_lines.Count ) {
                if ( m_lines[m_index] == "" ) {
                    return -1;
                } else {
                    return (int)m_lines[m_index][0];
                }
            } else {
                return -1;
            }
        }

        public void close() {
            m_lines.Clear();
        }

        public void Dispose() {
            close();
        }
    }

}
