#include "vConnect.h"
#include "straightNoteManager.h"

#ifdef USE_MULTI_SINGER
#define SINGER_INDEX_BUFFER_LENGTH 256
#endif

straightNoteManager::~straightNoteManager(){
    for( list<straightNote *>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){
        SAFE_DELETE( *i );
    }
}

#ifdef USE_MULTI_SINGER
string straightNoteManager::GetNoteMapKey( string lyric, int singer_index ){
    string ret = lyric;
    // 「歌詞 + [タブ記号] + 歌手番号」を使ってSTFの管理をするので
    char buf[SINGER_INDEX_BUFFER_LENGTH];
    sprintf( buf, "%d", singer_index );
    ret = ret + "\t" + buf;
    return ret;
}
#endif

#ifdef USE_MULTI_SINGER
straightNote *straightNoteManager::GetSTF( string lyric, int singer_index ){
#else
straightNote *straightNoteManager::GetSTF( string lyric ){
#endif
    MAP_TYPE<string, straightNote *>::iterator itr;
    straightNote *temp_stf;
#ifdef USE_MULTI_SINGER
    string search = GetNoteMapKey( lyric, singer_index );
#else
    string search = lyric;
#endif

#ifdef USE_MULTI_SINGER
    string file_path = (*this->mFilePaths)[singer_index];
#else
    string file_path = mFilePath;
#endif

    itr = mNoteMap.find( search );

    if( itr == mNoteMap.end() ){
        temp_stf = new straightNote();

        string file_name = file_path + lyric + ".stf";

        temp_stf->LoadSTFFile( mStraight, file_name );
        mNoteMap.insert( make_pair( search, temp_stf ) );
        mNoteList.push_back( temp_stf );
    }else{
        temp_stf = itr->second;
    }
    
    return temp_stf;
}

#ifdef USE_MULTI_SINGER
bool straightNoteManager::GetStraightFrame( straightFrame *dst_frame, string lyric, long absolute_frame, int singer_index ){
#else
bool straightNoteManager::GetStraightFrame( straightFrame *dst_frame, string lyric, long absolute_frame ){
#endif
    if( dst_frame == NULL || mStraight == NULL ){
        return false;
    }

#ifdef USE_MULTI_SINGER
    straightNote *temp_stf = GetSTF( lyric, singer_index );
#else
    straightNote *temp_stf = GetSTF( lyric );
#endif
    return temp_stf->GetFrame( dst_frame, absolute_frame );
}

#ifdef USE_MULTI_SINGER
long straightNoteManager::GetSrcFrameLength( string lyric, int singer_index ){
#else
long straightNoteManager::GetSrcFrameLength( string lyric ){
#endif
#ifdef USE_MULTI_SINGER
    straightNote *temp_stf = GetSTF( lyric, singer_index );
#else
    straightNote *temp_stf = GetSTF( lyric );
#endif
    return temp_stf->GetFrameLength();
}

#ifdef USE_MULTI_SINGER
void straightNoteManager::ReleaseSTF( string lyric, int singer_index ){
#else
void straightNoteManager::ReleaseSTF( string lyric ){
#endif
    MAP_TYPE<string, straightNote *>::iterator h_i;

#ifdef USE_MULTI_SINGER
    string search = GetNoteMapKey( lyric, singer_index );
#else
    string search = lyric;
#endif
    h_i = mNoteMap.find( search );

    if( h_i != mNoteMap.end() ){
        for( list<straightNote *>::iterator i = mNoteList.begin(); i != mNoteList.end(); i++ ){
            if( (*i) == h_i->second ){
                mNoteList.erase( i );
                break;
            }
        }
        SAFE_DELETE( h_i->second );
        mNoteMap.erase( h_i );
    }

    return;
}
