package hayashi.yuu.pasori.felica;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;

/**
 * 'felicalib.dll'へアクセスするためのインターフェイス定義
 *
 * このプログラムのソースは、
 * [亜細亜大学であがたが行う授業に関するサイトです。]から流用したものです。
 * 	http://itasan.mydns.jp/wiki.cgi/ASIA?page=Java%A4%CE%B1%FE%CD%D1%A1%A7Felica%A5%AB%A1%BC%A5%C9%A5%EA%A1%BC%A5%C0#p0
 *
 * プログラムの実行には、
 * 		[Java Native Access (jna.jar)]
 * 			< https://jna.dev.java.net/ >
 * と、
 * 		[felicalib (felicalib.dll)]
 * 			< http://felicalib.tmurakam.org/ >
 *  が、別途必要になります。
 *
 * @author hayashi
 */
public interface FelicaLib extends Library {
    FelicaLib INSTANCE = (FelicaLib) Native.loadLibrary("lib/felicalib", FelicaLib.class);

    Pointer pasori_open(String dummy);
    int pasori_init(Pointer pasoriHandle);
    void pasori_close(Pointer pasoriHandle);
    Pointer felica_polling(Pointer pasoriHandle, short systemCode, byte rfu, byte time_slot);
    void felica_free(Pointer felicaHandle);
    void felica_getidm(Pointer felicaHandle, byte[] data);
    void felica_getpmm(Pointer felicaHandle, byte[] data);
    int felica_read_without_encryption02(Pointer felicaHandle, int serviceCode, int mode, byte addr, byte[] data);
}
