package hayashi.yuu.register;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**
 * 「タッチパネル画面」
 *
 */
public class TouchScreen extends JFrame implements Runnable
{
    MainPanel mainPanel;					// キャビネット内のキータグ状況を表す

    /**
     * コンストラクタ
     *
     * 画面サイズ： 800 x 600
     *
     */
    public TouchScreen(String siteName) throws Exception {
    	super();
    	this.setUndecorated(true);

    	this.startModePanel = new StartModePanel(this);

        setLayout(new BorderLayout());
        this.setVisible(false);
        this.setSize(800, 600);

        /*
         * タイトルパネル
         * 		'proxSafe Commander3'のロゴイメージと、ターミナル名称
         *
         * 画面サイズ： 800 x 600
         */
        TitlePanel titlePanel = new TitlePanel();
        add(BorderLayout.NORTH, titlePanel);

        /*
         * メインパネル
         * 	[ニュートラル表示]パネル
         *
         * 画面サイズ： 800 x ?
         */
        printStartMessage();
    	add(BorderLayout.CENTER, mainPanel);

        /*
         * フッターパネル
         *
         */
        FooterPanel footerPanel = new FooterPanel(siteName);
        add(BorderLayout.SOUTH, footerPanel);
        setVisible(true);

        SymWindow aSymWindow = new SymWindow();
        addWindowListener(aSymWindow);
    }



	/////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//  Frame に関するメソッド
	//

	public void init()  {
        setVisible(true);
    	//Thread threadA = new Thread(this);
    	//threadA.start();
    }

    public void setVisible(boolean b) {
        if(b) {
            // デスクトップ中央にJFrameを配置する
            Dimension paneSize   = this.getSize();
            Dimension screenSize = this.getToolkit().getScreenSize();
            this.setLocation((screenSize.width  - paneSize.width)  / 2, (screenSize.height - paneSize.height) / 2);
        }
        super.setVisible(b);
    }

    public void addNotify() {
        Dimension d = getSize();
        super.addNotify();
        setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
        Component components[] = getComponents();
        for(int i = 0; i < components.length; i++)  {
            Point p = components[i].getLocation();
            p.translate(getInsets().left, getInsets().top);
            components[i].setLocation(p);
        }
    }

    /**
     * WindowClose 処理
     * @param event
     */
    public void FrameClosing(WindowEvent event) {
    	// スレッドを停止する
        setVisible(false);
        dispose();
    }

    class SymWindow extends WindowAdapter
    {
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if(object == TouchScreen.this) {
                FrameClosing(event);
            }
        }
    }

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//  モード に関するメソッド
	//
    protected StartModePanel startModePanel;
    /*
    protected UnregisteredModePanel unregisteredModePanel;
    protected BusyModePanel busyModePanel;
    */

    /*
     * スクリーン遷移モード
     */
    public int screenMode = START_MODE;		// 現在のスクリーンモードを保持する
    static final int START_MODE = 0;			// ニュートラル
    static final int USER_MODE = 1;			// ユーザー認証済み（キー選択）
    static final int UNREGISTERED_MODE = 2;	// 未登録カードモード
    static final int BUSY_MODE = 3;			// データ更新処理中モード
    static final int KEYTAG_MODE = 4;			// キータグ返却モード（AUTO_RETURN）


    /*
     * 「ニュートラル」モード
     * new ImageIcon("lib/card.gif"), "IDカードをかざしてください。"
     *
     */
    public void printStartMessage()  {
		this.screenMode = TouchScreen.START_MODE;

		// 表示パネルを切り替える
    	if (this.mainPanel != null) {
        	this.remove(this.mainPanel);
    	}

	    this.mainPanel = this.startModePanel;
	    this.add(BorderLayout.CENTER, mainPanel);
	    this.setVisible(true);
	    this.repaint();
    }


	@Override
	public void run() {
		while (this.screenMode == TouchScreen.START_MODE) {
			// 表示パネルを切り替える
	    	if (this.mainPanel != null) {
	        	this.remove(this.mainPanel);
	        	this.mainPanel = null;

			    this.setVisible(true);
			    //this.repaint();

				try {
					Thread.sleep(300);
				} catch (InterruptedException e) {}
	    	}
	    	else {
	    		this.mainPanel = this.startModePanel;
	    		this.add(BorderLayout.CENTER, mainPanel);

			    this.setVisible(true);
			    //this.repaint();

				try {
					Thread.sleep(2000);
				} catch (InterruptedException e) {}
	    	}
		}
	}

}