/*
 * Copyright  2008-2009 INRIA/SensTools
 * 
 * <dev-team@sentools.info>
 * 
 * This software is a set of libraries designed to develop applications
 * for the WSN430 embedded hardware platform.
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 * 
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software&apos;s author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 * 
 * In this respect, the user&apos;s attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software&apos;s suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 */
#include <avr/io.h>
//#include <avr/iom88p.h>
#include "spi1.h"
#include "macro.h"

/* Local Macros */
/*
 * wait until a byte has been received on spi port
 */
//#define WAIT_EORX() while ( (IFG2 & URXIFG1) == 0){}
#define WAIT_EORX() while (! (SPSR & _BV(SPIF))){} // SPIFZbĝ҂


/*
 * wait until a byte has been sent on spi port
 */
//#define WAIT_EOTX() while ( (IFG2 & UTXIFG1) == 0){}

#define CC1100_CS_PIN (1<<2)
//#define CC2420_CS_PIN (1<<2)
//#define DS1722_CS_PIN (1<<3)
//#define M25P80_CS_PIN (1<<4)

#define CC1100_ENABLE()  PORTB &= ~CC1100_CS_PIN
#define CC1100_DISABLE() PORTB |=  CC1100_CS_PIN


void spi1_init(void) 
{
    /* Configure IO pins */
	PBDDR |= (1<<5) | (1<<3); /* output for CLK and MOSI */
	PBDDR &=  ~(1<<4);   /* input for MISO */

	PORTB &= ~(1<<3);	//MOSI LOW

	SPCR = _BV(SPE) | _BV(MSTR);
    CC1100_DISABLE();
}






uint8_t spi1_write_single(uint8_t byte) 
{
    uint8_t dummy;

	SPDR = byte;
	while (! (SPSR & _BV(SPIF))) {
	;  // SPIFZbĝ҂
	}

	WAIT_EORX();
    dummy = SPDR;
    return dummy;
}

uint8_t spi1_read_single(void) 
{
    return spi1_write_single(0x0);
}

uint8_t spi1_write(uint8_t* data, int16_t len) 
{
    uint8_t dummy=0;
    int16_t i;
    
    for (i=0; i<len; i++) 
	{
		SPDR = data[i];
        WAIT_EORX();
		dummy = SPDR;
    }
    return dummy;
}
void spi1_read(uint8_t* data, int16_t len) 
{
    int16_t i;
    
    for (i=0; i<len; i++) 
	{
		SPDR = 0x0;
        WAIT_EORX();
		data[i] = SPDR;
    }
}

void spi1_select(int16_t chip) 
{
    switch (chip) {
    case SPI1_CC1100:
        CC1100_ENABLE();
        break;
    default:
        break;
    }
}

void spi1_deselect(int16_t chip) {
    switch (chip) {
    case SPI1_CC1100:
        CC1100_DISABLE();
        break;
    default:
        break;
    }
}

int16_t spi1_read_somi(void) 
{
    return PINB & (1<<2);
}
