/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// SelPart.cpp : Cve[V t@C
//
//******
//iCũXg{bNX\[g̑ł邱ƂOɂĂB

#include "stdafx.h"
#include "BSch.h"
#include <assert.h>
#include <string>
#include <list>
using namespace std;

#include "complib.h"
#include "Preview.h"
#include "SelPart.h"

#include "xbschglobal.h"
#include <io.h>


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelPart _CAO


CSelPart::CSelPart(CWnd* pParent /*=NULL*/)
	: CDialog(CSelPart::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelPart)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
	m_nLastSelectPart=0;
	m_nLastSelectLibrary=0;
	m_pwndPreview=NULL;
	m_bUsePreview=TRUE;
	m_bInhibitUpdatePartName = FALSE;
	m_bInhibitUpdateListbox = FALSE;
	m_pCompIndex = NULL;
}


void CSelPart::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelPart)
                //  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelPart, CDialog)
	//{{AFX_MSG_MAP(CSelPart)
	ON_LBN_SELCHANGE(IDC_LIST_LIBRARY, OnSelchangeListLibrary)
	ON_LBN_SELCHANGE(IDC_LIST_PARTNAME, OnSelchangeListPartname)
	ON_LBN_DBLCLK(IDC_LIST_PARTNAME, OnDblclkListPartname)
	ON_EN_CHANGE(IDC_EDIT_PARTNAME, OnChangeEditPartname)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//w肵Cu̕iXg{bNXɐݒ肷
void CSelPart::SetPartName(int nLib)
{
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_PARTNAME);
	pLB->ShowWindow(SW_HIDE);
	//ȇS
	int n=pLB->GetCount();			//o^ς݂̐𓾂
	while(n) n=pLB->DeleteString(0);//c肪擪̕
	m_nPartCount=0;
	SCompIndex* pPartIndex;
	const SCompLib* pCompLib = g_LibraryInfo(nLib);
	if(pCompLib){
		m_nPartCount=pCompLib->count();	//Cuɓo^Ă镔i
		for(n=0;n<m_nPartCount;n++){
			pPartIndex=pCompLib->compIndex(n);
			pLB->AddString(pPartIndex->name());
		}
		//ݒ肵iAOIȉԍ𖞂Ȃꍇ
		//ȎINAB
		if(m_nPartCount-1< m_nLastSelectPart){
			m_nLastSelectPart=0;
		}
		pLB->SetCurSel(m_nLastSelectPart);	//OÎɃJ[\u
		OnSelchangeListPartname(); 
//		CString rStrPartName;
//		pLB->GetText(m_nLastSelectPart,rStrPartName);
//		SetEditPartName(rStrPartName);
		if(m_pwndPreview && !m_bInhibitUpdatePartName)  //vr[̍XV
		{
			int nSel=m_nLastSelectPart;
			SCompIndex* pPartIndex=pCompLib->compIndex(nSel);
			m_pwndPreview->SetPartIndex(pPartIndex);
		}
	}else{//w肵CuƂ̏
	//		m_nLastSelectPart=0;
	}
	pLB->ShowWindow(SW_SHOW);
}

void CSelPart::AutoUpdate()
{
	int n;
	int count=g_LibraryCount();
	for(n=0;n<count;n++){
		const SCompLib* pCompLib = g_LibraryInfo(n);
		_finddata_t findData;
		if(_findfirst(pCompLib->m_lpszLibraryName,&findData)==-1) continue;
		int wr_time = findData.time_write;
		if(wr_time <= pCompLib->m_aux1){
			continue;
		}else{
			CString strPathname = pCompLib->m_lpszLibraryName;
			SCompLib* pCompLib=new SCompLib;
			if(!pCompLib->readLibraryFile(strPathname)){
				delete pCompLib;
			}else{
				if(!g_ReplaceLibrary(n,pCompLib)){
					delete pCompLib;
				}else{
					TRACE("Update library - %s\n",strPathname);
				}
			}
		}
	}
}


//Cu̖OXg{bNXɐݒ肷
//\Cut@C̃pX疼OɕύX  1997/01/21
void CSelPart::SetLibraryName()
{
	char szLibPath[_MAX_PATH];
	char szLibName[_MAX_FNAME];
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_LIBRARY);
	int n=pLB->GetCount();			//o^ς݂̐𓾂
	while(n) n=pLB->DeleteString(0);//c肪擪̕
	for(n=0;n<MAX_LIB;n++){
		const SCompLib* pCompLib = g_LibraryInfo(n);
		if(pCompLib==NULL) break;
		strcpy(szLibPath,pCompLib->m_lpszLibraryName);
		_splitpath(szLibPath,NULL,NULL,szLibName,NULL);
		pLB->AddString(szLibName);
	}
	m_nLibraryCount=n;
	//ݒ肵CuAOICuԍ𖞂Ȃꍇ
	if(m_nLibraryCount-1<m_nLastSelectLibrary){
		m_nLastSelectLibrary=0;
		m_nLastSelectPart=0;
	}
	pLB->SetCurSel(m_nLastSelectLibrary);
}

//GfBbgRg[Ƀp[cݒ
void CSelPart::SetEditPartName(LPCSTR psz)
{
	m_bInhibitUpdateListbox = TRUE;
	if(!m_bInhibitUpdatePartName){
		CEdit* pED=(CEdit*)GetDlgItem(IDC_EDIT_PARTNAME);
		pED->SetWindowText(psz);
	}

	m_rStrPartName = psz;
	m_rStrPartName.MakeUpper();
	m_bInhibitUpdateListbox = FALSE;

}

/////////////////////////////////////////////////////////////////////////////
// CSelPart bZ[W nh

BOOL CSelPart::OnInitDialog() 
{
	CDialog::OnInitDialog();

	AutoUpdate();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	//vr[gƂɂ́A_CAO̕LāACPreview̃EChE
	//CreateExB
	if(m_bUsePreview){
		m_pwndPreview=new CPreview;
		GetWindowRect(&m_rcDialog);
		GetClientRect(&m_rcClient);
		int nHeight=m_rcClient.bottom;
		MoveWindow( m_rcDialog.left,m_rcDialog.top,
					m_rcDialog.right-m_rcDialog.left+nHeight,
					m_rcDialog.bottom-m_rcDialog.top);
		CString strClassName=AfxRegisterWndClass(
			CS_VREDRAW|CS_HREDRAW,
			AfxGetApp()->LoadStandardCursor(IDC_ARROW), 
			NULL);

//			(HBRUSH)GetStockObject(WHITE_BRUSH));
		m_pwndPreview->CreateEx(
			WS_EX_CLIENTEDGE,
			strClassName,
			"Preview",			//vȂ
			WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL,
			m_rcClient.right,
			6,
			nHeight-6,
			nHeight-12,
			this->m_hWnd,
			(HMENU)IDC_PREVIEW);
	}
	//iGfBbg{bNX̕
	CEdit* pED=(CEdit*)GetDlgItem(IDC_EDIT_PARTNAME);
	pED->SetLimitText(32);
	SetLibraryName();
	SetPartName(m_nLastSelectLibrary);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

//CȗIԂςƂ̃nh
void CSelPart::OnSelchangeListLibrary() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_LIBRARY);
	m_nLastSelectLibrary=pLB->GetCurSel();
	m_nLastSelectPart=0;	//CȗIςΑOIp[cONA
	SetPartName(m_nLastSelectLibrary);
}

//ȋIԂςƂ̃nh
void CSelPart::OnSelchangeListPartname() 
{
	int nSel;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_PARTNAME);
	nSel=pLB->GetCurSel();
	//g_pPartLib[m_nLastSelectLibrary]->m_nLastSelectIndex=nSel;
	m_nLastSelectPart=nSel;
	CString rStrPartName;
	pLB->GetText(nSel,rStrPartName);
	SetEditPartName(rStrPartName);
	if(m_pwndPreview) //vr[̍XV
	{
		//SCompIndex* pPartIndex=g_LibraryInfo(n)
		const SCompLib* pCompLib = g_LibraryInfo(m_nLastSelectLibrary);
		m_pCompIndex=pCompLib->compIndex(nSel);
		//CPartIndex* pPartIndex=g_pPartLib[m_nLastSelectLibrary]->GetPartIndex(nSel);
		m_pwndPreview->SetPartIndex(m_pCompIndex);
	}
	if(m_pCompIndex->m_pCompInfo){
		SetDlgItemText(IDC_EDIT_MFR2,m_pCompIndex->Mfr());
		SetDlgItemText(IDC_EDIT_MFR_PNUM2,m_pCompIndex->MfrPn());
		SetDlgItemText(IDC_EDIT_PKG2,m_pCompIndex->Pkg());
		SetDlgItemText(IDC_EDIT_NOTE,m_pCompIndex->m_pCompInfo->m_note.c_str());
	}
}

void CSelPart::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	CDialog::OnCancel();
}

void CSelPart::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
//	CEdit* pED=(CEdit*)GetDlgItem(IDC_EDIT_PARTNAME);
//	pED->GetWindowText(m_rStrPartName);
//	m_rStrPartName.MakeUpper();	//啶ɕϊ 1997/01/25
	CDialog::OnOK();
}

//iIXg{bNX̃_uNbNőII 1997/01/25
void CSelPart::OnDblclkListPartname() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnOK();
}

void CSelPart::OnChangeEditPartname() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	//static int debug_val = 0;
	//debug_val++;
	//TRACE("CSelPart::OnChangeEditPartname()  %d\n",debug_val);
	//return;

	if(m_bInhibitUpdateListbox)return;

	CEdit* pED=(CEdit*)GetDlgItem(IDC_EDIT_PARTNAME);
	pED->GetWindowText(m_rStrPartName);
	m_rStrPartName.MakeUpper();

	int nLib;
	int nIndex;
	
	m_pCompIndex = g_SearchComponentIndex(m_rStrPartName,&nLib,&nIndex,NULL);
	if(m_pCompIndex){
		m_bInhibitUpdatePartName = TRUE;

		m_nLastSelectLibrary = nLib;
		//OnSelchangeListPartname();
		m_nLastSelectPart  = nIndex;

		CListBox* pLBLib=(CListBox*)GetDlgItem(IDC_LIST_LIBRARY);
		pLBLib->SetCurSel(m_nLastSelectLibrary);
		SetPartName(m_nLastSelectLibrary);
		CListBox* pLBPart=(CListBox*)GetDlgItem(IDC_LIST_PARTNAME);
		pLBPart->SetCurSel(m_nLastSelectPart);

		if(m_pwndPreview){ //vr[̍XV
			m_pwndPreview->SetPartIndex(m_pCompIndex);
		}
		if(m_pCompIndex->m_pCompInfo){
			SetDlgItemText(IDC_EDIT_MFR2,m_pCompIndex->Mfr());
			SetDlgItemText(IDC_EDIT_MFR_PNUM2,m_pCompIndex->MfrPn());
			SetDlgItemText(IDC_EDIT_PKG2,m_pCompIndex->Pkg());
			SetDlgItemText(IDC_EDIT_NOTE,m_pCompIndex->m_pCompInfo->m_note.c_str());
		}
		m_bInhibitUpdatePartName = FALSE;
	}


}
