#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>

#include <avr/sleep.h>
#include "macro.h"
//#include "trh033m.h"
#include "cc1100.h"
#include "cc1100_globals.h"
//#include <avr/iomx8p.h>
#include "spi1.h"

#include <stdint.h>
#include <avr/wdt.h>
//#include <avr/i2c.h>
#include <util/twi.h>



#define TEST				REGISTER_BIT(PORTC,0)

#define OUTPUT				REGISTER_BIT(PORTC,1) 
#define SCLR				REGISTER_BIT(PORTC,3) 
#define SCLK				REGISTER_BIT(PORTC,2) 
#define CLK					REGISTER_BIT(PORTC,4) 
#define S_DATA				REGISTER_BIT(PORTC,5) 

#define BUZZER				REGISTER_BIT(PORTD,4) 
#define TX_EN				REGISTER_BIT(PORTD,3) 


#define B_CTL				REGISTER_BIT(PORTB,0)
#define CS_CC1101			REGISTER_BIT(PORTB,2)

#define CS_CC1101_LOW			CS_CC1101 =0
#define CS_CC1101_HIGH			CS_CC1101 =1


#define B_CTL_LOW			B_CTL =0
#define B_CTL_HIGH			B_CTL =1

#define OUTPUT_HIGH			OUTPUT = 1
#define OUTPUT_LOW			OUTPUT = 0


#define SCLR_HIGH			SCLR = 1
#define SCLR_LOW			SCLR = 0

#define S_CLK_HIGH			SCLK = 1
#define S_CLK_LOW			SCLK = 0

#define CLK_HIGH			CLK = 1
#define CLK_LOW				CLK = 0

#define S_DATA_HIGH			S_DATA = 1
#define S_DATA_LOW			S_DATA = 0


/*

#define CNT_SEC		0x00;
#define CNT_MINUTES	0x01;
#define CNT_HOUR	0x02;
#define CNT_DAY		0x03;
#define 
#define 
#define 
#define 
#define 
#define 

*/





//trh_card_t card;



uint8_t status;
uint8_t	test_cnt02;
cc1101_tx_data tx_data;
//u8 rx_data[100];

u8 chk_state=0;

u8 test1;
u8 test2;
u8 test3;
volatile u8 input_data=0;

//u8 status=0;


u8 a;
u8 b;
u8 th[3]={0,0,0};
u8 tl[3]={0,0,0};
u8 t_temp[3]={0,0,0};
u8 test_temp;
u8 test_temp2;
u8 test_temp3;


enum {
	KEY_CHK=0,
	CA_OUT_SETUP,
	DATA_OUT_SETUP,
	CA_WAVEOUT,
	DATA_WAVEOUT,
	FIFO_SETUP,
	DATA_WAVEOUT_WAIT_SYN_ACK_ACK_SETUP,
	DATA_WAVEOUT_WAIT_SYN_ACK,
	DATA_WAVEOUT_SYN_ACK_VERIFY,
	DATA_WAVEOUT_OK_CNT,
	DATA_WAVEOUT_QUIT,
	CA_KEY_CHANGE_CHK,
	DATA_KEY_CHANGE_CHK,
	RX_RSSI_SETUP,
	RX_RSSI_START,
	RX_RSSI_WAIT,
	RSSI_SEND_UART_RX_DATA,
	RX_SETUP,
	RX_START,
	RX_WAIT,
	RX_DATA_TX_SYN_ACK_SETUP,
	RX_DATA_TX_SYN_ACK,
	SEND_UART_RX_DATA,
	RX_VERIFY_START,
	RX_VERIFY_WAIT,
	RX_VERIFY
};








#if 1		//OSC 8MHz

void udelay(u8 usec)
{
	register u8 i;

	for(i = 0 ;   i < usec ; i++){
		asm volatile("NOP");
		asm volatile("NOP");
		asm volatile("NOP");
		asm volatile("NOP");
	}
}


#endif




#if 0		//OSC 128kHz

void u100delay(u8 usec)
{
	register u8 i;

	for(i = 0 ;   i < usec ; i++){
		asm volatile("NOP");
		asm volatile("NOP");
		asm volatile("NOP");
	}
}


#endif







/*
 	mili second  Delay
*/



#if 0		//OSC 128kHz

void mdelay(u16 msec)
{
	register u16 i;
	for(i = 0 ; i < msec  ; i++){
		u100delay(10);
	}
}

#endif



#if 1		//OSC 8MHz


void mdelay(u16 msec)
{
	register u16 i;
	for(i = 0 ; i < msec  ; i++){
		udelay(250);
		udelay(250);
		udelay(250);
		udelay(250);
	}
}


#endif

void sdelay(u16 msec)
{
	register u16 i;

	for(i=0;i<msec;i++)
	{
		mdelay(1000);
	}
}







/*
 	mili second  Delay
*/




#if 1

void putc(u8 data)
{
	while(!(UCSR0A & (1<<UDRE0)));
	UDR0 = data;
}

void putb(u8 data)
{
	if(data < 0x0a)
		putc('0' + data);
	else 
		putc('a' + (data-10));
}




void puthex(u8 data)
{
	putb(data/16);
	putb(data%16);
}


void timer_init()
{
	TCCR1A = 0x00;
	TCCR1B = 0x0a;
	TCCR1C = 0x00;
	OCR1A  = 0xffff;
	TCNT1  = 0x0000;

	TCCR0B=(1<<CS02)|(1<<CS00);		//clkI/O/1024 (From prescaler)		(15625hz) 		1/(1000000/64)  = 	64us..
	TCNT0=0;

}

#endif


void inituart()
{
	#if 0			//OSC 128kHz
	UCSR0A = 0x02;	//U2X = 1
	UCSR0B = 0x00; // Rx/Tx enable
	UCSR0C = 0x06; // 8bit, 1 stop bit, no parity
	UBRR0H = 0x00; 
	UBRR0L = 0x0c; // Baudrate 1200
	UCSR0B = 0x98; // rx / tx enable , rx int enable 0x98
	#endif

	#if 1			//OSC 8MHz
	UCSR0A = 0x02;	//U2X = 1
	UCSR0B = 0x00; // Rx/Tx enable
	UCSR0C = 0x06; // 8bit, 1 stop bit, no parity
	UBRR0H = 0x00; 
	UBRR0L = 0x67; // Baudrate 9600
	UCSR0B = 0x98; // rx / tx enable , rx int enable 0x98

	#endif
}


unsigned char ctrl[3]={0x00,0x00,0x00};





#define OVERFLOW 256  

#define TICKS_PER_SEC 1000  

#define Prescaler 64  


volatile unsigned int tic_time;  
volatile unsigned int c_read_time;
    

char ms33=0;
ISR(TIMER0_OVF_vect)
{
	test_cnt02++;


}  

ISR(TIMER2_OVF_vect)
{
//	u8 i;

	test_cnt02++;
	TCNT2=0;

	#if 0
	for(i=0;i<5;i++)
	{
		B_CTL_LOW;
		mdelay(100);
		B_CTL_HIGH;
		mdelay(100);
	}
	#endif


}  


void hw_setup(void)
{

    DDRC=0x00;      
	DDRD=0x00;
	DDRB=0x0D;

	/*pull_up*/
	PORTC = (1<<PC0) | (1<<PC1);
	PORTD = 0xf3;





	#if 1

	/*Timer2 test*/
	TCCR2B=(1<<CS22)|(1<<CS21)|(1<<CS20);		//clkI/O/1024 (From prescaler)		(15625hz) 		1/(1000000/64)  = 	64us..
	TCNT2=0;
	TIMSK2 |= (1<<TOIE2);

	#endif



	EICRA &= ~(1<<ISC00);	//INT0̊荞ݔ𗧉茟mŃgKŌŒ
	EICRA &= ~(1<<ISC01);

	EICRA &= ~(1<<ISC10);	//INT1̊荞ݔ𗧉茟mŃgKŌŒ
	EICRA &= ~(1<<ISC11);



	EIMSK |= (1<<INT0);
	EIMSK |= (1<<INT1);

}





uint8_t cc1100_read_reg_uartout(uint8_t addr)
{
	uint8_t reg;

	reg = cc1100_read_reg(addr);

	#if 1

	puthex(addr);
	putc(0x5c);
	puthex(reg);
	putc(0x0d);
	putc(0x0a);

	#endif

	return reg;
}



//u8 pt_data[] = {0xC5,0xC0,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7};		\\10dB
//u8 pt_data[] = {0xC5,0x60,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7};		//0dB
//u8 pt_data[] = {0xC5,0xC5,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7};
u8 pt_data[] = {0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00};		//10dB
//u8 pt_data[] = {0x60,0x60,0x00,0x00,0x00,0x00,0x00,0x00};		//0dB
//u8 pt_data[] = {0x60,0x60,0x00,0x00,0x00,0x00,0x00,0x00};		//0dB
//u8 pt_data[] = {0x34,0x34,0x00,0x00,0x00,0x00,0x00,0x00};		//-10dB



#if 1

void cc1101_init_tx(void)
{


	#if 1
	cc1100_cfg_append_status(CC1100_APPEND_STATUS_ENABLE);
	cc1100_cfg_crc_autoflush(CC1100_CRC_AUTOFLUSH_DISABLE);
	cc1100_cfg_white_data(CC1100_DATA_WHITENING_ENABLE);
	cc1100_cfg_crc_en(CC1100_CRC_CALCULATION_ENABLE);
	cc1100_cfg_freq_if(0x0C);
	cc1100_cfg_fs_autocal(CC1100_AUTOCAL_NEVER);
	cc1100_cfg_mod_format(CC1100_MODULATION_GFSK);
    //cc1100_cfg_mod_format(CC1100_MODULATION_MSK);
	cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);
	cc1100_cfg_manchester_en(CC1100_MANCHESTER_DISABLE);
	#endif


	cc1100_cfg_white_data(CC1100_DATA_WHITENING_DISABLE);
	cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);

	pt_data[0] = 0xC0;			//10dB
	pt_data[1] = 0x00;			//
	pt_data[2] = 0x00;		//
	pt_data[3] = 0x00;		//
	pt_data[4] = 0x00;		//

	cc1101_carrier_wave_setup(input_data);
	cc1101_8PATABLE_write_reg(pt_data);
	cc1100_write_reg(CC1100_REG_MDMCFG3,0x83);	//DATA rate 9.6kbps
	cc1100_write_reg(CC1100_REG_MDMCFG4,0x88);	//

	cc1100_write_reg(CC1100_REG_DEVIATN,0x27);		//Deviation 11.901855kHz
}




void cc1101_init_rx(void)
{


	#if 1
	cc1100_cfg_append_status(CC1100_APPEND_STATUS_ENABLE);
	cc1100_cfg_crc_autoflush(CC1100_CRC_AUTOFLUSH_DISABLE);
	cc1100_cfg_white_data(CC1100_DATA_WHITENING_ENABLE);
	cc1100_cfg_crc_en(CC1100_CRC_CALCULATION_ENABLE);
	cc1100_cfg_freq_if(0x0C);
	cc1100_cfg_fs_autocal(CC1100_AUTOCAL_NEVER);
	cc1100_cfg_mod_format(CC1100_MODULATION_GFSK);
    //cc1100_cfg_mod_format(CC1100_MODULATION_MSK);
	cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);
	cc1100_cfg_manchester_en(CC1100_MANCHESTER_DISABLE);
	#endif


	cc1100_cfg_crc_autoflush(CC1100_CRC_AUTOFLUSH_ENABLE);
	cc1100_cfg_white_data(CC1100_DATA_WHITENING_DISABLE);
	cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);
	cc1100_write_reg(CC1100_REG_MDMCFG3,0x83);	//DATA rate 9.6kbps
	cc1100_write_reg(CC1100_REG_MDMCFG4,0x88);	//
	cc1100_write_reg(CC1100_REG_DEVIATN,0x27);		//Deviation 11.901855kHz


	//cc1100_cfg_txoff_mode(CC1100_TXOFF_MODE_RX);
	pt_data[0] = 0xC0;			//10dB
	pt_data[1] = 0x00;			//
	//cc1101_data_waveoutput_setup(input_data,pt_data);
	cc1101_carrier_wave_setup(input_data);
	cc1101_8PATABLE_write_reg(pt_data);

}




#endif






void reg_check(void)
{

	cc1100_read_reg_uartout(CC1100_REG_IOCFG2);
	cc1100_read_reg_uartout(CC1100_REG_IOCFG1);
	cc1100_read_reg_uartout(CC1100_REG_IOCFG0);
	cc1100_read_reg_uartout(CC1100_REG_FIFOTHR);
	cc1100_read_reg_uartout(CC1100_REG_SYNC1);
	cc1100_read_reg_uartout(CC1100_REG_SYNC0);
	cc1100_read_reg_uartout(CC1100_REG_PKTLEN);
	cc1100_read_reg_uartout(CC1100_REG_PKTCTRL1);
	cc1100_read_reg_uartout(CC1100_REG_PKTCTRL0);
	cc1100_read_reg_uartout(CC1100_REG_ADDR);
	cc1100_read_reg_uartout(CC1100_REG_CHANNR);
	cc1100_read_reg_uartout(CC1100_REG_FSCTRL1);
	cc1100_read_reg_uartout(CC1100_REG_FSCTRL0);
	cc1100_read_reg_uartout(CC1100_REG_FREQ2);
	cc1100_read_reg_uartout(CC1100_REG_FREQ1);
	cc1100_read_reg_uartout(CC1100_REG_FREQ0);
	cc1100_read_reg_uartout(CC1100_REG_MDMCFG4);
	cc1100_read_reg_uartout(CC1100_REG_MDMCFG3);
	cc1100_read_reg_uartout(CC1100_REG_MDMCFG2);
	cc1100_read_reg_uartout(CC1100_REG_MDMCFG1);
	cc1100_read_reg_uartout(CC1100_REG_MDMCFG0);
	cc1100_read_reg_uartout(CC1100_REG_DEVIATN);
	cc1100_read_reg_uartout(CC1100_REG_MCSM2);
	cc1100_read_reg_uartout(CC1100_REG_MCSM1);
	cc1100_read_reg_uartout(CC1100_REG_MCSM0);
	cc1100_read_reg_uartout(CC1100_REG_FOCCFG);
	cc1100_read_reg_uartout(CC1100_REG_BSCFG);
	cc1100_read_reg_uartout(CC1100_REG_AGCCTRL2);
	cc1100_read_reg_uartout(CC1100_REG_AGCCTRL1);
	cc1100_read_reg_uartout(CC1100_REG_AGCCTRL0);
	cc1100_read_reg_uartout(CC1100_REG_WOREVT1);
	cc1100_read_reg_uartout(CC1100_REG_WOREVT0);
	cc1100_read_reg_uartout(CC1100_REG_WORCTRL);
	cc1100_read_reg_uartout(CC1100_REG_FREND1);
	cc1100_read_reg_uartout(CC1100_REG_FREND0);
	cc1100_read_reg_uartout(CC1100_REG_FSCAL3);
	cc1100_read_reg_uartout(CC1100_REG_FSCAL2);
	cc1100_read_reg_uartout(CC1100_REG_FSCAL1);
	cc1100_read_reg_uartout(CC1100_REG_FSCAL0);
	cc1100_read_reg_uartout(CC1100_REG_RCCTRL1);
	cc1100_read_reg_uartout(CC1100_REG_RCCTRL0);
	cc1100_read_reg_uartout(CC1100_REG_FSTEST);
	cc1100_read_reg_uartout(CC1100_REG_PTEST);
	cc1100_read_reg_uartout(CC1100_REG_AGCTEST);
	cc1100_read_reg_uartout(CC1100_REG_TEST2);
	cc1100_read_reg_uartout(CC1100_REG_TEST1);
	cc1100_read_reg_uartout(CC1100_REG_TEST0);

}











void cc1101_init03(void)
{


	#if 1
	cc1100_cfg_append_status(CC1100_APPEND_STATUS_ENABLE);
	cc1100_cfg_crc_autoflush(CC1100_CRC_AUTOFLUSH_DISABLE);
	cc1100_cfg_white_data(CC1100_DATA_WHITENING_ENABLE);
	cc1100_cfg_crc_en(CC1100_CRC_CALCULATION_ENABLE);
	cc1100_cfg_freq_if(0x0C);
	cc1100_cfg_fs_autocal(CC1100_AUTOCAL_NEVER);
	cc1100_cfg_mod_format(CC1100_MODULATION_GFSK);
    //cc1100_cfg_mod_format(CC1100_MODULATION_MSK);
	//cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);
	cc1100_cfg_sync_mode(CC1100_SYNCMODE_NO_PREAMB);
	cc1100_cfg_manchester_en(CC1100_MANCHESTER_DISABLE);


	cc1100_write_reg(CC1100_REG_MDMCFG3,0x83);	//DATA rate 9.6kbps
	//cc1100_write_reg(CC1100_REG_MDMCFG4,0x88);	//DATA rate 9.6kbps

	cc1100_write_reg(CC1100_REG_MDMCFG4,0x88);	//
	#endif

}











void cc1101_8PATABLE_read_reg(void)
{
	u8 i;
	u8 reg[10];

	spi1_select(SPI1_CC1100);
	spi1_write_single(0x3e | CC1100_ACCESS_READ_BURST);
	for(i=0;i<8;i++)
	{
		reg[i] = spi1_read_single();
	}
	spi1_deselect(SPI1_CC1100);


	for(i=0;i<8;i++)
	{
		putc(0x54);
		puthex(i);
		putc(0x5c);
		puthex(reg[i]);
		putc(0x0d);
		putc(0x0a);
	}



}



void cc1101_8PATABLE_write_reg(u8 * reg)
{
	u8 i;


	spi1_select(SPI1_CC1100);
	spi1_write_single(0x3e | CC1100_ACCESS_WRITE_BURST);
	for(i=0;i<8;i++)
	{
		spi1_write_single(reg[i]);
	}
	spi1_deselect(SPI1_CC1100);

}




void spi_signalpin_opendrain_active(void)
{
	SPCR &= ~(1<<SPE);	//SPI non active
	//DDRB &= ~(1<<PB0);	//B_CTL
	DDRB &= ~(1<<PB2);	//CSn
	DDRB &= ~(1<<PB3);	//MOSI
	DDRB &= ~(1<<PB5);	//SCK

	PORTB &= ~(1<<PB2);	//CSn

	//PORTC &= ~(1<<PC0);
	//PORTC &= ~(1<<PC1);
	PORTC = 0x00;
	PORTD = 0x00;
}


void spi_signalpin_opendrain_nonactive(void)
{

	spi1_init();		
	//DDRB |= (1<<PB0);	//B_CTL
	PORTB &= ~(1<<PB2);	//CSn
	DDRB |= (1<<PB2);	//CSn output

	PORTC |= (1<<PC0);
	PORTC |= (1<<PC1);
	PORTC |= (1<<PC2);
	PORTC |= (1<<PC3);
	PORTC |= (1<<PC4);
	PORTC |= (1<<PC5);
	//PORTC = 0x00;
	PORTD = 0xf3;

}






void alert_data_get(cc1101_tx_data * tx_data)
{

	tx_data->serial[0] = 0x4D;	//M
	tx_data->serial[1] = 0x37;	//E
	tx_data->serial[2] = 0x34;	//T
	tx_data->serial[3] = 0x00;	//0
	tx_data->serial[4] = 0x00;	//0
	tx_data->serial[5] = 0x00;	//0


	tx_data->data01 = 0x4D;	//EMG_SIG data
	tx_data->data02 = 0x37;	//test_sig_timer_data
	tx_data->data03 = 0x37;	//BATT_data
	tx_data->data04 = 0x37;	//RSSI_data


}



u8 get_input_data(void)
{
	u8 reg = 0;

	reg = (reg & 0xFF) | (((PIND) << 2) & 0x80);	//F_SEL2
	reg = (reg & 0xFF) | (((PIND) << 2) & 0x40);	//F_SEL1

	reg = (reg & 0xFF) | (((PIND) >> 2) & 0x20);	//D_SEL2
	reg = (reg & 0xFF) | (((PIND) >> 2) & 0x10);	//D_SEL1

	reg = (reg & 0xFF) | (((PINC) << 2) & 0x08);	//M_SEL2
	reg = (reg & 0xFF) | (((PINC) << 2) & 0x04);	//M_SEL1


	return reg;
}


#if 1

void tx_fifo_set(cc1101_tx_data *tx_data)
{
	u8 i;
	uint8_t tx_buffer[100];
	uint16_t tx_length = 0;


	for(i=0;i<10;i++)
	{
		//tx_buffer[i] = tx_data->serial[i];
		tx_buffer[i] = i;
	}

	tx_buffer[i++] = tx_data->data01;
	tx_buffer[i++] = tx_data->data02;
	tx_buffer[i++] = tx_data->data03;
	tx_buffer[i++] = tx_data->data04;
	tx_buffer[i++] = 0x00;
	tx_buffer[i++] = 0x00;

	//tx_length = i+3;
	//tx_length = i+2;
	tx_length = i;


	cc1100_fifo_put((&tx_length), 1);
	//cc1100_fifo_put((tx_length), 1);
	cc1100_fifo_put(tx_buffer, (tx_length));
	//cc1100_fifo_put(tx_buffer, (tx_length-3));
	//cc1100_fifo_put(tx_buffer, (tx_length-2));

}


#endif


//u8 baud = 0;






void cc1101_carrier_wave_setup(u8 input_data)
{
	u8 f_reg[3] = {0,0,0};
	u8 temp;


	if((input_data & 0xC0)==0xC0)			//426.3625MHz(Ch5) nearly 426.362152
	{
		f_reg[2] = 0x10;
		f_reg[1] = 0x66;
		f_reg[0] = 0x07;
	
	}else if((input_data & 0xC0)==0x80){	//426.4625MHz(Ch9) nearly 426.462128
		f_reg[2] = 0x10;
		f_reg[1] = 0x67;
		f_reg[0] = 0x03;

	}else if((input_data & 0xC0)==0x40){	//426.5625MHz(Ch13)
		f_reg[2] = 0x10;
		f_reg[1] = 0x68;
		f_reg[0] = 0x00;

	}else if((input_data & 0xC0)==0x00){	//426.6625MHz(Ch17)	nearly 426.662476
		f_reg[2] = 0x10;
		f_reg[1] = 0x68;
		f_reg[0] = 0xFC;

	}


	temp = f_reg[0];
	eeprom_busy_wait();

	if((eeprom_read_byte(0x01)==0x80))
	{
		eeprom_busy_wait(); 
		f_reg[0] = f_reg[0]-eeprom_read_byte(0x00);
		if(f_reg[0] > temp)
			f_reg[1] -= 1;
	}
	else{
		eeprom_busy_wait(); 
		f_reg[0] = f_reg[0]+eeprom_read_byte(0x00);
		if(f_reg[0] < temp)
			f_reg[1] += 1;
	}

	cc1100_write_reg(CC1100_REG_FREQ2, f_reg[2]);
	cc1100_write_reg(CC1100_REG_FREQ1, f_reg[1]);
	cc1100_write_reg(CC1100_REG_FREQ0, f_reg[0]);


}




#if 0

void cc1101_data_waveoutput_setup(u8 input_data,u8 * pt_data)
{
	u8 f_reg[3] = {0,0,0};
	u8 temp;


	if((input_data & 0xC0)==0xC0)			//426.3625MHz(Ch5) nearly 426.362152
	{
		f_reg[2] = 0x10;
		f_reg[1] = 0x66;
		f_reg[0] = 0x07;
	
	}else if((input_data & 0xC0)==0x80){	//426.4625MHz(Ch9) nearly 426.462128
		f_reg[2] = 0x10;
		f_reg[1] = 0x67;
		f_reg[0] = 0x03;

	}else if((input_data & 0xC0)==0x40){	//426.5625MHz(Ch13)
		f_reg[2] = 0x10;
		f_reg[1] = 0x68;
		f_reg[0] = 0x00;

	}else if((input_data & 0xC0)==0x00){	//426.6625MHz(Ch17)	nearly 426.662476
		f_reg[2] = 0x10;
		f_reg[1] = 0x68;
		f_reg[0] = 0xFC;

	}


	temp = f_reg[0];
	eeprom_busy_wait(); 

	if((eeprom_read_byte(0x01)==0x80))
	{
		eeprom_busy_wait(); 
		f_reg[0] = f_reg[0]-eeprom_read_byte(0x00);
		if(f_reg[0] > temp)
			f_reg[1] -= 1;
	}
	else{
		eeprom_busy_wait(); 
		f_reg[0] = f_reg[0]+eeprom_read_byte(0x00);
		if(f_reg[0] < temp)
			f_reg[1] += 1;
	}




	cc1100_write_reg(CC1100_REG_FREQ2, f_reg[2]);
	cc1100_write_reg(CC1100_REG_FREQ1, f_reg[1]);
	cc1100_write_reg(CC1100_REG_FREQ0, f_reg[0]);


	#if 0
    cc1100_cfg_append_status(CC1100_APPEND_STATUS_ENABLE);
    cc1100_cfg_crc_autoflush(CC1100_CRC_AUTOFLUSH_DISABLE);
    cc1100_cfg_white_data(CC1100_DATA_WHITENING_ENABLE);
    cc1100_cfg_crc_en(CC1100_CRC_CALCULATION_ENABLE);
    cc1100_cfg_freq_if(0x0C);
    cc1100_cfg_fs_autocal(CC1100_AUTOCAL_NEVER);
	#endif


	/*carria freq check*/
	//cc1100_cfg_sync_mode(CC1100_SYNCMODE_NO_PREAMB);
    //cc1100_cfg_sync_mode(CC1100_SYNCMODE_30_32);
    //cc1100_cfg_manchester_en(CC1100_MANCHESTER_DISABLE);

	//cc1100_write_reg(CC1100_REG_MDMCFG3,0x83);	

	cc1101_8PATABLE_write_reg(pt_data);
	//cc1100_cfg_mod_format(CC1100_MODULATION_GFSK);

	//fosc chech
	//cc1100_write_reg(CC1100_REG_IOCFG2, CC1100_GDOx_CLK_XOSC_1);
}


#endif





void init_voltcomparator(void)
{
	//ACSR |= 1<<ACD;
	//mdelay(1000);
	ACSR = 0x4b;
	DIDR1 = 0x02;
}






u8 add_batt_low(void)
{
	u8 temp_data;

	#if 0
	u8 add_data;
	u8 temp_data;

	temp_data = (ACSR & 0x10);
	temp_data = (temp_data << 3);
	ACSR |= 1<<ACI;
	
	add_data = data + temp_data;
	return add_data;
	#endif

	B_CTL_HIGH;

	init_ad();
	ADCSRA |= _BV(ADSC);					//ϊJn vٰߓ
	while((ADCSRA&0x10)==0x00);

	ADCSRA |= (1<<ADIF);					//ADIF clear

	temp_data = ADCH;

	//a = ( ADC >> 4 );						//ADϊ 4bit= 6bit:0-64
	ad_diseable();
	B_CTL_LOW;

	puthex(a);
	puthex(0x5C);
	puthex(b);
	putc(0x0d);
	putc(0x0a);
	putc(0x0d);
	putc(0x0a);

	return temp_data;
}




void init_ad(void)
{
	ADCSRA = 0b10000100; // AD:1 ADJn:0 ADN:0 AD:0 AD:0 ck/16
    ADMUX = 0xE7;       //AREFOdAPC0

}


void ad_diseable(void)
{
	ADCSRA = 0b00000100; // AD:0 ADJn:0 ADN:0 AD:0 AD:0 ck/16
    //ADMUX = 0x00;       //AREFOdAPC0

}




// G[
void i2c_error(void)
{
    //putch('['); puthex2(TWSR); putch(']'); // TWSR̓e
    //putch(0x0d); putch(0x0a); // s
    //PORTB = 0x01; // LED_
    while(1) ;
}

// ʐMx̏
void i2c_init(void)
{
    TWSR = 0b00000000;  // 1
    TWBR = 32;          // 100k = 8MHz / (16 + 2 * TWBR * 1)
	//TWBR = 5;          // 50k = 8MHz / (16 + 2 * TWBR * 1)
	//TWBR = 255;          // 50k = 8MHz / (16 + 2 * TWBR * 1)
}



// master 1byteM
void i2c_write(u8 d)
{
    TWDR = d; // Mf[^
    TWCR = _BV(TWINT) | _BV(TWEN);
    while( !(TWCR & _BV(TWINT)) ) ; // f[^̑oҋ@
    if((TWSR & TW_STATUS_MASK) != TW_MT_DATA_ACK) i2c_error();
}

// master 1byteM(ackԂ)
u8 i2c_read_ack(void)
{
    TWCR = _BV(TWINT) | _BV(TWEN) | _BV(TWEA);
    while( !(TWCR & _BV(TWINT)) ) ; // M҂
    if((TWSR & TW_STATUS_MASK) != TW_MR_DATA_ACK) i2c_error();
    return TWDR; // f[^Ԃ
}

// master 1byteM(noackԂ)
u8 i2c_read_nak(void)
{
    TWCR = _BV(TWINT) | _BV(TWEN);
    while( !(TWCR & _BV(TWINT)) ) ; // M҂
    if((TWSR & TW_STATUS_MASK) != TW_MR_DATA_NACK) i2c_error();
    return TWDR; // f[^Ԃ
}

// masterMJnAIDslave address  1
void i2c_start(u8 id)
{
    u8 s;

    // Jn𑗂
    TWCR = _BV(TWINT) | _BV(TWSTA) | _BV(TWEN);
    while( !(TWCR & _BV(TWINT)) ) ; // Jn̑oҋ@
    s = TWSR & TW_STATUS_MASK;
    if(s != TW_START && s != TW_REP_START) i2c_error();

    // AhX𑗂
    TWDR = id;
    TWCR = _BV(TWINT) | _BV(TWEN);
    while( !(TWCR & _BV(TWINT)) ) ; // AhX̑oҋ@
    s = TWSR & TW_STATUS_MASK;
    if(s != TW_MT_SLA_ACK && s != TW_MR_SLA_ACK) i2c_error();
}

// masterMI
void i2c_stop(void)
{
    TWCR = _BV(TWINT) | _BV(TWSTO) | _BV(TWEN);
    while( !(TWCR & _BV(TWSTO)) ) ;
    // statusTW_NO_INFOɂȂ
}


#define RTC_R2223L (0x32 << 1)    // RICOH RTC R2223L/Tslave address


void rtc_1byte_data_write(u8 addr,u8 data)
{
	/*write*/
	i2c_start(RTC_R2223L | TW_WRITE);
	i2c_write((addr<<4)&0xf0); // register 4
	i2c_write(data); // 14bit resolution
	i2c_stop();
}


u8 rtc_1byte_data_read(u8 addr)
{
	u8 data;

	i2c_start(RTC_R2223L | TW_WRITE);
	i2c_write((addr << 4)&0xF0); // register 0
	i2c_start(RTC_R2223L | TW_READ);
	data = i2c_read_nak(); // ʓǂݍ(ŌNAKԂ)
	i2c_stop();
	return data;
}


void rtc_3byte_data_read(u8 start_addr,u8 * data)
{
	i2c_start(RTC_R2223L | TW_WRITE);
	i2c_write((start_addr << 4)&0xF0); // register 0
	i2c_start(RTC_R2223L | TW_READ);
	data[0] = i2c_read_ack(); // ʓǂݍ
	data[1] = i2c_read_ack(); // ʓǂݍ
	data[2] = i2c_read_nak(); // ʓǂݍ(ŌNAKԂ)
	i2c_stop();
}




ISR(USART_RX_vect)
{
	test_cnt02++;
	test_cnt02=UDR0;
	puthex(test_cnt02);
	mdelay(100);
	//puthex(0x55);
	//putc(0x47);
	//putc(0x4a);
}


//u8 rx_data[20];




u8 edge_val_gdo0;
u8 edge_val_gdo2;

u8 gdo0_status;
u8 gdo2_status;


#if 0
enum {
	LOW_EDGE=0,
	HIGH_EDGE
};

#endif

enum {
	GDO_OK=0,
	GDO_WAIT
};





#if 1
//#define GDO0_INT_SET_RISING()  P1IES &= ~GDO0_PIN
void GDO0_INT_SET_RISING(void)
{
	edge_val_gdo0 = HIGH_EDGE;
}
//#define GDO0_INT_SET_FALLING() P1IES |=  GDO0_PIN
void GDO0_INT_SET_FALLING(void)
{
	edge_val_gdo0 = LOW_EDGE;
}


//#define GDO2_INT_SET_RISING()  P1IES &= ~GDO2_PIN
void GDO2_INT_SET_RISING(void)
{
	edge_val_gdo2 = HIGH_EDGE;
}
//#define GDO2_INT_SET_FALLING() P1IES |=  GDO2_PIN
void GDO2_INT_SET_FALLING(void)
{
	edge_val_gdo2 = LOW_EDGE;
}

//#define GDO0_READ() (P1IN & GDO0_PIN)
u8 GDO0_READ(void)
{
	return (PINC & 0x04);
}
//#define GDO2_READ() (P1IN & GDO2_PIN)
u8 GDO2_READ(void)
{
	return (PINC & 0x08);
}
#endif

 




ISR(PCINT1_vect)
{
	//u8 test;
	//send_byte(1);

	#if 1
	if((edge_val_gdo0==0x00)&&((PINC&0x04)==0x00))
		gdo0_status = GDO_OK;
	else if((edge_val_gdo0==0x01)&&((PINC&0x04)==0x00))
		gdo0_status = GDO_OK;
	else if((edge_val_gdo2==0x00)&&((PINC&0x08)==0x00))
		gdo2_status = GDO_OK;
	else if((edge_val_gdo2==0x01)&&((PINC&0x08)==0x00))
		gdo2_status = GDO_OK;		
	#endif




	//status = SEND_UART_RX_DATA;
}


void cc1101_gdo0_sig_wait(void)
{
	//gdo0_status = GDO_WAIT;

	//while(gdo0_status == GDO_WAIT);
	while(gdo0_status == 0x01);

}


ISR(INT0_vect)
{
	test_cnt02++;
	puthex(0x33);
	mdelay(100);

}


	#if 1
	uint16_t rx_length = 0;
	uint8_t rx_data[100];
	uint16_t verify_length=0;
	uint8_t verify_data[200];
	uint16_t verify_cnt=0;
	u8 crc_ok_cnt=0;
	#endif





ISR(INT1_vect)
{
	u8 i;
	//uint16_t i;
	//u8 a;
	//u8 b;
	//register u8 input_data=0;
	u8 new_input_data=0;
	u8 tx_count=0;
	//u8 crc_ok_cnt=0;
	//u8 verify_cnt=0;

	//u16 rx_length;

	#if 0
	uint16_t rx_length =0;
	uint8_t rx_data[200];
	#endif
	//volatile unsigned char chk_state=0;

	u8 cnt_sent_packet=0;
	u8 cnt_wait_syn_ack=0;
	u8 cnt_sent_ok_packet=0;
	u8 cnt_replay_packet=0;

	uint8_t tx_buffer[100];
	uint8_t tx_length;


	test_cnt02++;
	puthex(0x44);
	mdelay(100);







	//DDRB |= (1<<PB0);	//B_CTL
	spi_signalpin_opendrain_nonactive();


    cc1100_init();
	cc1101_init_tx();


	#if 1
	i2c_init();


	
	rtc_1byte_data_write(0x00,0x04);
	rtc_1byte_data_write(0x01,0x03);
	rtc_1byte_data_write(0x02,0x02);


	test_temp = rtc_1byte_data_read(0x00);
	test_temp2 = rtc_1byte_data_read(0x01);
	test_temp3 = rtc_1byte_data_read(0x02);
	#endif
	//while(1);





	#if 0

	b = add_batt_low();

	#endif


	#if 1
	status = KEY_CHK;
	PCICR = (1<<PCIE1);	//PCIE1 Enable

	while(1)
	{
		switch(status)
		{
			default:
				break;
			case KEY_CHK:

				input_data = ~get_input_data();


				if((input_data&0x0c)==0x04)
					status = CA_OUT_SETUP;
				else if((input_data&0x0c)==0x00)
					status = DATA_OUT_SETUP;
				else if((input_data&0x0c)==0x08)
					status = RX_RSSI_SETUP;
				else if((input_data&0x0c)==0x0c)
					status = RX_SETUP;
				break;
			case CA_OUT_SETUP:
				cc1101_carrier_wave_setup(input_data);
				//cc1101_carrier_waveoutput_setup(input_data,pt_data);
				#if 1
				pt_data[0] = 0xC0;			//10dB
				pt_data[1] = 0xC0;			//
				#endif

				cc1101_8PATABLE_write_reg(pt_data);
				cc1100_cfg_txoff_mode(CC1100_TXOFF_MODE_STAY_TX);
				cc1100_cfg_manchester_en(CC1100_MANCHESTER_DISABLE);
				cc1100_write_reg(CC1100_REG_MDMCFG3,0x83);	
				cc1100_cfg_mod_format(CC1100_MODULATION_ASK);
				cc1100_write_reg(CC1100_REG_IOCFG2, CC1100_GDOx_CLK_XOSC_1);

				reg_check();

				status = CA_WAVEOUT;
				break;
			case CA_WAVEOUT:
				cc1100_cmd_idle();
				cc1100_cmd_flush_tx();
				cc1100_cmd_calibrate();
				mdelay(10);
				cc1100_cmd_tx();

				#if 0
				if(cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)==0x01)
				{
					cc1100_cmd_flush_tx();
					cc1100_cmd_tx();
				}
				#endif
				status = CA_KEY_CHANGE_CHK;
				break;
			case DATA_OUT_SETUP:
				cc1101_init_tx();

				//reg_check();


				#if 1
				if(cnt_sent_packet>100)
				{
					status = DATA_WAVEOUT_QUIT;
					break;
				}
				#endif

				status = FIFO_SETUP;
				break;
			case FIFO_SETUP:
				alert_data_get(&tx_data);

				cc1100_cmd_flush_tx();
				cc1100_cmd_idle();

				cc1100_cmd_calibrate();
				cc1100_cfg_gdo0(CC1100_GDOx_SYNC_WORD);
				mdelay(5);
				//sdelay(1);
				//gdo0_status = GDO_WAIT;
				//cc1100_cfg_gdo0(CC1100_GDOx_CHIP_RDY);

				//cc1100_gdo0_int_set_falling_edge();
				//GDO0_INT_SET_FALLING();

				//cc1100_gdo0_int_clear();
				//cc1100_gdo0_int_enable();
				//cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS);

				//cc1100_gdo0_register_callback(vEndOfTx_cb);
				//cc1101_gdo0_sig_wait();

				//cc1100_gdo2_int_disable();
				//cc1100_gdo0_int_disable();
				//tx_fifo_set(&tx_data);


				tx_buffer[0] = cnt_sent_ok_packet;
				for(i=1;i<10;i++)
				{
					tx_buffer[i] = i;
				}
				tx_buffer[i++] = 0x47;
				tx_buffer[i++] = 0x47;
				tx_buffer[i++] = 0x47;
				tx_buffer[i++] = 0x47;

				tx_length = i;

				cc1100_fifo_put((&tx_length), 1);
				cc1100_fifo_put(tx_buffer, (tx_length));


				for(i=0;i<8;i++)
				{
					verify_data[i] = tx_buffer[i];
				}

				#if 1
				cc1100_read_reg_uartout((CC1100_REG_TXBYTES | CC1100_ACCESS_STATUS));
				#endif
				//sdelay(1);
				status = DATA_WAVEOUT;
				break;
			case DATA_WAVEOUT:
				cc1100_cmd_tx();
				//mdelay(100);
				mdelay(1);
				cnt_sent_packet++;

				while(cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)==0x13);

				#if 0
				cc1100_read_reg_uartout((CC1100_REG_TXBYTES | CC1100_ACCESS_STATUS));
				#endif

				sdelay(1);


				status = DATA_WAVEOUT_WAIT_SYN_ACK_ACK_SETUP;
				break;
			case DATA_WAVEOUT_WAIT_SYN_ACK_ACK_SETUP:
				cc1100_cmd_flush_tx();
				cc1100_cmd_idle();
				cc1101_init_rx();

				cc1100_cfg_gdo0(CC1100_GDOx_RX_OK);
				//cc1100_cmd_idle();
				mdelay(10);
				cc1100_cmd_flush_rx();
				mdelay(10);
				cc1100_cmd_calibrate();
				mdelay(10);
				cc1100_cmd_rx();
				mdelay(10);
				//cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS);
				status = DATA_WAVEOUT_WAIT_SYN_ACK;
				break;
			case DATA_WAVEOUT_WAIT_SYN_ACK:
				cnt_wait_syn_ack = 0;
				//mdelay(200);
				while(status == DATA_WAVEOUT_WAIT_SYN_ACK)
				{

					#if 1				


					//if((cc1100_read_reg(CC1100_REG_LQI | CC1100_ACCESS_STATUS)&0x80))
					if(PINC&0x04)
					{	
						cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
						cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
						status = DATA_WAVEOUT_SYN_ACK_VERIFY;
						break;
					}
					else
					{	
						if(cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)!=0x0d)
						{
							B_CTL_LOW;	//LED OFF
							cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
							status = DATA_OUT_SETUP;
							break;
						}
					}
					//mdelay(100);
					mdelay(100);
					#endif
					cnt_wait_syn_ack++;
					if(cnt_wait_syn_ack==2)
					{
						B_CTL_LOW;	//LED OFF
						status = DATA_OUT_SETUP;
						break;
					}
				}
				break;
			case DATA_WAVEOUT_SYN_ACK_VERIFY:
				rx_length = cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
				cc1100_fifo_get(&rx_length,1);
				cc1100_fifo_get((&rx_data),rx_length);


				for(i=0;i<8;i++)
				{
					if(verify_data[i] == rx_data[i])
					{
						verify_cnt++;
					}
				}

				if(verify_cnt==8)
				{
					status = DATA_WAVEOUT_OK_CNT;
				}
				else{
					status = DATA_OUT_SETUP;
					B_CTL_LOW;	//LED OFF
				}
				verify_cnt=0;
				break;
			case DATA_WAVEOUT_OK_CNT:
				#if 0
				rx_length = cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
				cc1100_fifo_get(&rx_length,1);
				cc1100_fifo_get((&rx_data),rx_length);
				#endif
				//cc1100_cmd_flush_rx();
				cnt_sent_ok_packet++;

				putc(0x4f);
				putc(0x5c);
				puthex(cnt_sent_ok_packet);
				putc(0x0d);
				putc(0x0a);

				B_CTL_HIGH;	//LED ON

				status = DATA_OUT_SETUP;
				break;
			case DATA_WAVEOUT_QUIT:

				putc(0x53);
				putc(0x5c);
				puthex(cnt_sent_packet);
				putc(0x0d);
				putc(0x0a);

				putc(0x4f);
				putc(0x5c);
				puthex(cnt_sent_ok_packet);
				putc(0x0d);
				putc(0x0a);
				sdelay(1);


				while(1)
				{

					B_CTL_HIGH;
					mdelay(100);
					B_CTL_LOW;
					mdelay(100);

				}

				break;
			case DATA_KEY_CHANGE_CHK:
				new_input_data = ~get_input_data();
				if(new_input_data != input_data)
					status = KEY_CHK;
				else
					status = FIFO_SETUP;
				break;						
			case CA_KEY_CHANGE_CHK:
				new_input_data = ~get_input_data();
				if(new_input_data != input_data)
					status = KEY_CHK;
				cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS);
				break;
			case RX_RSSI_SETUP:
				cc1101_init03();
				cc1100_cfg_txoff_mode(CC1100_TXOFF_MODE_RX);
				pt_data[0] = 0xC0;			//10dB
				pt_data[1] = 0x00;			//
				//cc1101_data_waveoutput_setup(input_data,pt_data);
				cc1101_carrier_wave_setup(input_data);
				cc1101_8PATABLE_write_reg(pt_data);

				#if 0
				cc1100_write_reg(CC1100_REG_FREQ2,0x0f);	//frecuency 399Mhz
				cc1100_write_reg(CC1100_REG_FREQ1,0x62);
				cc1100_write_reg(CC1100_REG_FREQ0,0x76);
				#endif

				//PCMSK1 = (1<<PCINT10);
				cc1100_cfg_gdo0(CC1100_GDOx_RX_OK);

				status = RX_RSSI_START;
				break;
			case RX_RSSI_START:
				cc1100_cmd_idle();
				cc1100_cmd_flush_rx();
				cc1100_cmd_calibrate();
				sdelay(1);
				cc1100_cmd_rx();
				sdelay(1);
				status = RX_RSSI_WAIT;
				break;
			case RX_RSSI_WAIT:
				while(status == RX_RSSI_WAIT)
				{

					#if 1
					cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS);
					cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
					mdelay(100);


					if(cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)==0x01)
						cc1100_cmd_rx();

					if(cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)==0x11)
						cc1100_cmd_idle();
					#endif

					#if 0

					if(cc1100_read_reg_uartout((CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS))!=0x00)
						break;
					sdelay(1);
					#endif

				}
				status = RSSI_SEND_UART_RX_DATA;
				break;
			case RSSI_SEND_UART_RX_DATA:
				rx_length = cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
				cc1100_fifo_get((&rx_data),rx_length);

				for(i=0;i<rx_length;i++)
				{
					puthex(i);
					putc(0x5c);
					puthex(rx_data[i]);
					putc(0x0d);
					putc(0x0a);
				}
				status = RX_RSSI_WAIT;
				break;
			case RX_SETUP:
				cc1101_init_rx();

				cc1100_cfg_gdo0(CC1100_GDOx_RX_OK);
				//sdelay(1);
				//reg_check();
				//sdelay(3);
				status = RX_START;
				break;
			case RX_START:
				cc1100_cmd_idle();
				mdelay(10);
				cc1100_cmd_flush_rx();
				mdelay(10);
				cc1100_cmd_calibrate();
				mdelay(10);
				cc1100_cmd_rx();
				mdelay(10);
				
				cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS);
				status = RX_WAIT;
				break;
			case RX_WAIT:
				while(status == RX_WAIT)
				{

					#if 1				


					if(PINC&0x04)
					{	
						cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
						cc1100_read_reg(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
						status = RX_DATA_TX_SYN_ACK_SETUP;
						break;
					}
					else
					{	
						if(cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)!=0x0d)
						{
							cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
							status = RX_START;
							break;
						}
					}

					mdelay(100);
					#endif


					#if 0
					putc(0x44);
					putc(0x52);
					putc(0x44);
					putc(0x5c);
					puthex(crc_ok_cnt);
					putc(0x0d);
					putc(0x0a);
					#endif
				}
				break;
			case RX_DATA_TX_SYN_ACK_SETUP:
				if(cnt_replay_packet==0)
				{
					rx_length = cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
					cc1100_fifo_get(&rx_length,1);
					cc1100_fifo_get((&rx_data),rx_length);
				}

				cc1101_init_tx();
				cc1100_cmd_flush_tx();
				cc1100_cmd_idle();

				cc1100_cmd_calibrate();
				cc1100_cfg_gdo0(CC1100_GDOx_SYNC_WORD);
				mdelay(5);

				//tx_fifo_set(&tx_data);
				rx_data[10] = 0x88;
				rx_data[11] = 0x88;
				rx_data[12] = 0x88;
				rx_data[13] = 0x88;

				cc1100_fifo_put((&rx_length), 1);
				//cc1100_fifo_put((tx_length), 1);
				cc1100_fifo_put(rx_data, (rx_length));
				status = RX_DATA_TX_SYN_ACK;
				break;
			case RX_DATA_TX_SYN_ACK:
				//mdelay(300); 
				mdelay(100); 
				cc1100_cmd_tx();


				mdelay(1);
				//cnt_sent_packet++;

				while(cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)==0x13);


				//if(cnt_replay_packet != 10)
				if(cnt_replay_packet != 1)
				{
					cnt_replay_packet++;
					status = RX_DATA_TX_SYN_ACK_SETUP;
					break;
				}

				cnt_sent_packet++;
				cnt_replay_packet = 0;
				//sdelay(1);

				putc(0x52);		//R
				putc(0x58);		//X
				puthex(cnt_sent_packet);
				putc(0x0d);
				putc(0x0a);
				sdelay(1);


				status = RX_SETUP;
				break;
			case SEND_UART_RX_DATA:
				#if 0
				mdelay(50);
				if((cc1100_read_reg_uartout(CC1100_REG_LQI | CC1100_ACCESS_STATUS)&0x80)!=0x80)
				{
					status = RX_START;
					break;	
				}
				#endif

				rx_length = cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
				cc1100_fifo_get(&rx_length,1);
				cc1100_fifo_get((&rx_data),rx_length);



				#if 0
				for(i=0;i<rx_length;i++)
				{
					puthex(i);
					putc(0x5c);
					puthex(rx_data[i]);
					putc(0x0d);
					putc(0x0a);
				}
				#endif



				//status = RX_DATA_TX_SYN_ACK_SETUP;
				break;
			case RX_VERIFY_START:
				cc1100_cmd_idle();
				mdelay(10);
				cc1100_cmd_flush_rx();
				mdelay(10);
				cc1100_cmd_calibrate();
				mdelay(10);
				cc1100_cmd_rx();
				mdelay(10);
				status = RX_VERIFY_WAIT;
				break;
			case RX_VERIFY_WAIT:
				while(status == RX_VERIFY_WAIT)
				{
					//cc1100_read_reg_uartout(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS);

					#if 1				
					//if(cc1100_read_reg(CC1100_REG_LQI | CC1100_ACCESS_STATUS)&0x80)
					if(PINC&0x04)
					{	
						cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
						//cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
						status = RX_VERIFY;
						break;
					}
					else
					{	
						if(cc1100_read_reg(CC1100_REG_MARCSTATE | CC1100_ACCESS_STATUS)!=0x0d)
						{
							cc1100_read_reg_uartout(CC1100_REG_RSSI | CC1100_ACCESS_STATUS);
							status = RX_VERIFY_START;
							break;
						}
					}

					mdelay(100);
					#endif

					#if 0
					putc(0x43);
					putc(0x52);
					putc(0x43);
					putc(0x5c);
					puthex(crc_ok_cnt);
					putc(0x0d);
					putc(0x0a);
					#endif
				}
				break;
			case RX_VERIFY:
				#if 0
				mdelay(50);
				if((cc1100_read_reg_uartout(CC1100_REG_LQI | CC1100_ACCESS_STATUS)&0x80)!=0x80)
				{
					status = RX_VERIFY_START;
					break;	
				}
				#endif


				#if 1

				rx_length = cc1100_read_reg_uartout(CC1100_REG_RXBYTES | CC1100_ACCESS_STATUS);
				cc1100_fifo_get(&rx_length,1);
				cc1100_fifo_get((&rx_data),rx_length);

				verify_cnt = 0;

				for(i=0;i<8;i++)
				{
					if(verify_data[i] == rx_data[i])
					{
						verify_cnt++;
					}
					else
					{
						break;
					}
				}

				if(verify_cnt == 8)
					crc_ok_cnt++;
				
				#endif

				putc(0x43);
				putc(0x52);
				putc(0x43);
				putc(0x5c);
				puthex(crc_ok_cnt);
				putc(0x0d);
				putc(0x0a);

				status = RX_VERIFY_START;
				break;
		}

	}
	#endif




	#if 1
	B_CTL_HIGH;
	sdelay(1);
	B_CTL_LOW;
	#endif






	#if 0

	for(i=0;i<1;i++)
	{
	B_CTL_HIGH;
	sdelay(1);
	B_CTL_LOW;
	sdelay(1);
	}


	sdelay(3);


	for(i=0;i<10;i++)
	{
	B_CTL_HIGH;
	mdelay(100);
	B_CTL_LOW;
	sdelay(1);
	}

    cc1100_init();
	cc1101_init_tx();


	input_data = ~get_input_data();





	if((input_data&0x80)==0x80)
	{
		cc1100_cmd_flush_tx();
		cc1100_cmd_pwd();
	}

	if((input_data&0x40)==0x40)
	{
		//cc1100_cmd_pwd();
		DDRB &= ~(1<<PB0);	//B_CTL
	}
	

	#endif


	cc1100_cmd_idle();
	cc1100_cmd_pwd();

	spi_signalpin_opendrain_active();

	
}











int main()
{
	#if 1

	hw_setup();
	inituart();
	#endif


	CS_CC1101_HIGH;

	B_CTL_LOW;
	mdelay(100);


	#if 1
    cc1100_init();
	cc1101_init_tx();
	#endif

	#if 0
	cc1100_read_reg_uartout(CC1100_PATABLE_ADDR);
	cc1101_8PATABLE_read_reg();

	#endif


	#if 1
	test1 = cc1100_read_reg_uartout(CC1100_REG_FREQ2);
	test2 = cc1100_read_reg_uartout(CC1100_REG_FREQ1);
	test3 = cc1100_read_reg_uartout(CC1100_REG_FREQ0);
	#endif

	#if 1
	status = STARTUP;
	test_cnt02 = 0;
	//set_sleep_mode(SLEEP_MODE_PWR_DOWN);
	set_sleep_mode(SLEEP_MODE_PWR_SAVE);


	putc(0x45);
	putc(0x50);
	puthex(0x00);
	eeprom_busy_wait(); 
	puthex(eeprom_read_byte(0x00));
	putc(0x0d);
	putc(0x0a);


	putc(0x45);
	putc(0x50);
	puthex(0x01);
	eeprom_busy_wait(); 
	puthex(eeprom_read_byte(0x01));
	putc(0x0d);
	putc(0x0a);



	#endif


	sei();


	cc1100_cmd_idle();
	cc1100_cmd_pwd();


	spi_signalpin_opendrain_active();

	/* Enter the infinite loop */
    while (1)
    {

		#if 1
		sleep_mode();
		#endif


	}
}


