/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// CompProperty.cpp : t@C
//

#include "stdafx.h"
#include "LCoV.h"
#include "CompProperty.h"
#include ".\compproperty.h"


// CCompProperty _CAO

IMPLEMENT_DYNAMIC(CCompProperty, CDialog)
CCompProperty::CCompProperty(CWnd* pParent /*=NULL*/)
	: CDialog(CCompProperty::IDD, pParent)
	
{
	m_name = "NAME";
	m_num = "U";
	m_note = "";
	m_mfr = "";
	m_mfrpn = "";
	m_pkg = "";
	m_block = 1;
	m_x = 2;
	m_y = 2;
	m_usePtn = FALSE;
	m_noBitPtn = FALSE;
}

CCompProperty::~CCompProperty()
{
}

void CCompProperty::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_NOTE, m_note);
	DDX_Text(pDX, IDC_EDIT_MFR, m_mfr);
	DDX_Text(pDX, IDC_EDIT_MFRPN, m_mfrpn);
	DDX_Text(pDX, IDC_EDIT_PKG, m_pkg);
	DDV_MaxChars(pDX, m_note, 255);
}


BEGIN_MESSAGE_MAP(CCompProperty, CDialog)
//	ON_EN_CHANGE(IDC_EDIT_NOTE, OnEnChangeEditNote)
ON_BN_CLICKED(IDC_CHECK_USEPTN, OnBnClickedCheckUseptn)
END_MESSAGE_MAP()


// CCompProperty bZ[W nh

BOOL CCompProperty::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO :  ɏǉĂ
	if(!m_usePtn) m_noBitPtn = FALSE;
	SetDlgItemText(IDC_EDIT_COMP_NAME,m_name);
	SetDlgItemText(IDC_EDIT_COMP_REF,m_num);
	SetDlgItemInt(IDC_EDIT_COMP_SIZEX,m_x);
	SetDlgItemInt(IDC_EDIT_COMP_SIZEY,m_y);
	SetDlgItemInt(IDC_EDIT_COMP_BLOCK,m_block);
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDC_CHECK_USEPTN);
	pButton->SetCheck(m_usePtn);
	pButton = (CButton*)GetDlgItem(IDC_CHECK_NOBIT);
	pButton->SetCheck(m_noBitPtn);
	pButton->EnableWindow(m_usePtn);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CCompProperty::OnOK()
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB
	GetDlgItemText(IDC_EDIT_COMP_NAME,m_name);
	GetDlgItemText(IDC_EDIT_COMP_REF,m_num);
	m_x = GetDlgItemInt(IDC_EDIT_COMP_SIZEX);
	m_y = GetDlgItemInt(IDC_EDIT_COMP_SIZEY);
	m_block = GetDlgItemInt(IDC_EDIT_COMP_BLOCK);
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDC_CHECK_USEPTN);
	m_usePtn = pButton->GetCheck();
	pButton = (CButton*)GetDlgItem(IDC_CHECK_NOBIT);
	m_noBitPtn = pButton->GetCheck();

	if(!isValidPartName(m_name)){
		AfxMessageBox(IDS_PARTNAME_INVALID);
		return;
	}

	if(m_x<1 || m_x>255 || m_y<1 || m_y>255) {
		AfxMessageBox(IDS_PARTSIZE_RANGE);
		return;
	}
	if(m_block<1 || m_block>255){
		AfxMessageBox(IDS_PART_BLOCKRANGE);
		return;
	}
	CDialog::OnOK();
}


BOOL CCompProperty::isValidPartName(const char*  psz)
{
	int n=lstrlen(psz);
	if(n==0 || n>32) return FALSE;
	while(*psz){
		if(  *psz<0x21
		   ||*psz>0x7E
   		   ||*psz=='{'
		   ||*psz=='}') return FALSE;
		psz++;
	}
	return TRUE;
}

//void CCompProperty::OnEnChangeEditNote()
//{
//	// TODO :  ꂪ RICHEDIT Rg[̏ꍇA܂ACDialog::OnInitDialog() ֐I[o[ChāA
//	// OR Ԃ ENM_CORRECTTEXT tO}XNɓāA
//	// CRichEditCtrl().SetEventMask() ĂяoȂA
//	// Rg[́A̒ʒm𑗐M܂B
//
//	// TODO :  ɃRg[ʒmnh R[hǉĂB
//}

void CCompProperty::OnBnClickedCheckUseptn()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CButton* pButton;
	pButton = (CButton*)GetDlgItem(IDC_CHECK_USEPTN);
	m_usePtn = pButton->GetCheck();
	pButton = (CButton*)GetDlgItem(IDC_CHECK_NOBIT);
	pButton->EnableWindow(m_usePtn);
}
