// Copyright (C) 2002 H.Okada(suigyodo) All rights reserved.
/****************************************************************************
** XBSch}ʗvfڍ_NX̎
****************************************************************************/
#include "stdafx.h"
#include <stdio.h>
//#include <qnamespace.h>
#include <string>
using namespace std;
#include "ce3io.h"
#include "xbschobj.h"
#include "xbschjunc.h"


//RXgN^
SXBSchJunc::SXBSchJunc()
{
}


bool SXBSchJunc::readCe3(SReadCE3& rce3,const SPoint* pptOrigin,SXBSchDoc*)
{
	string str;
	bool bInitX1 = false;
	bool bInitY1 = false;
	while(1){
		if(rce3.ReadRecord(str)==EOF) return false;
		if(str[0] == '-'){
			if( (str != "-JUNCTION") || !bInitX1 || !bInitY1){
				return false;
			}else{
				break;	//break while(1){ }
			}
		}else if(str[0] == '+'){
			str[0]='-';
			if(rce3.SkipTo(str)==EOF) return false;
		}else{
			int n;
			int l=str.length();
			for(n=0;n<l;n++){
				if(str[n]==':') break;
			}
			if(0<n && n<(l-1)){	// : ŕꂽR[hł
				string var = str.substr(0,n);				//擪:̎O܂
				int nParam = atoi(str.substr(n+1).c_str()); //:I[܂ł𐔒lɕϊ
				if(var=="X"){
					if(pptOrigin) nParam += pptOrigin->x();		
					m_p1.setX(nParam);
					bInitX1 = true;
				}else 
				if(var=="Y"){
					if(pptOrigin) nParam += pptOrigin->y();		
					m_p1.setY(nParam);
					bInitY1 = true;
				}
			}
		}
	}

	return true;
}

/*
//Xg[̓ǂݍ `-JUNCTION
bool SXBSchJunc::readStream(SCsvIStream* pStrm,const SPoint* pptOrigin)
{
	if(!pStrm) return false;
	QString str;
	QString var;
	QString val;
	int nParam=0;
	bool bInitX1 = false;
	bool bInitY1 = false;
	while(1){
		int nResult = pStrm->getRecord(str);
		if(nResult == SCsvIStream::GETRECORD_EOF || nResult == SCsvIStream::GETRECORD_ERROR){
			return false;
		}
		//str = deleteLeftSpace(str);
		if(str[0] == '-'){
			if( (str != "-JUNCTION") || !bInitX1 || !bInitY1){
				return false;
			}else{
				break;	//break while(1){ }
			}
		}else if(str[0] == '+'){
			if(pStrm->skipTo(str.replace(1,1,"-")) != SCsvIStream::GETRECORD_NORMAL)return false;
		}else{
			if(SCsvIStream::splitToVariableValue(str,var,val)){
				nParam = val.toInt();
				if(var=="X"){
					if(pptOrigin) nParam += pptOrigin->x();		
					m_p1.setX(nParam);
					bInitX1 = true;
				}else 
				if(var=="Y"){
					if(pptOrigin) nParam += pptOrigin->y();		
					m_p1.setY(nParam);
					bInitY1 = true;
				}
			}
		}
	}

	return true;
}
*/

bool SXBSchJunc::writeCe3(SWriteCE3& wce3,const SPoint* pptOrigin)
{
//	char sz[32];
	int x = m_p1.x();
	int y = m_p1.y();
	if(pptOrigin){
		x -= pptOrigin->x();
		y -= pptOrigin->y();
	}

	wce3.WriteRecord("+JUNCTION");
	wce3.WriteRecordInt("L",m_Layer);
	wce3.WriteRecordInt("X",x);
	wce3.WriteRecordInt("Y",y);

	wce3.WriteRecord("-JUNCTION");
	wce3.WriteEOL();
	return true;
}



//s
SXBSchObj* SXBSchJunc::duplicate()
{
	SXBSchObj* newObj =new SXBSchJunc(*this);
	return newObj;
}

//_w肵đIdvxԂ
int SXBSchJunc::qSelectWeight(const SPoint& p)
{
	int nResult = PointAndRectMag(p,area());
	if(nResult) return (nResult | ON_OBJ);
	else		return 0;
}

//͈͂w肵đIs
unsigned SXBSchJunc::testSelection(const SRect& rc)
{
	if( rc.intersect(area()) ){
		return SELECT_ALL;
	}else{
		return 0;
	}
}

//͈͂IăhbOIs
unsigned SXBSchJunc::testSelectionForDrag(const SRect& rc)
{
	if( rc.intersect(area()) ){
		return SELECT_ALL;
	}else{
		return 0;
	}
}

//`悪KvǂԂ
bool SXBSchJunc::qRedraw(const SRect& rc)
{
	return rc.intersect(area());
}

//L͈͂Ԃ
SRect SXBSchJunc::area()
{
	SRect rc(m_p1.x()-2,m_p1.y()-2,5,5);
	return rc;
}

SRect SXBSchJunc::rotateRect()
{
	return SRect(m_p1,m_p1);
}