#include "stdafx.h"

#include "stdafx.h"
#include "global.h"
#include <stdio.h>
#include <assert.h>
#include <string>
#include <ctype.h>
using namespace std;
#include "SMarkupTextLine.h"

//SMarkupTextLine::SMarkupTextLine(void)
//{
//	m_strText = "";
//	m_fontName = "";
//	m_textSyle = (unsigned int)SMarkupTextLine::NO_STYLE;
//	m_charFlags = NULL;
//
//}

//SMarkupTextLine::~SMarkupTextLine(void)
//{
//	delete[]m_charFlags;
//}

typedef stack<string> StringStack;

// &LŎn܂GR[h͂B
// ͌ʂ*decodeCharɓB
// T|[gGR[h̏ꍇ́A*decodeCharɂ&L
// ߂l̃|C^́A͂Ƃ́A;L̎̕A
//                     T|[gGR[ĥƂ́A&L̎̕
static const char* analyzeAmpEncode(const char* src, char *decodeChar)
{
	*decodeChar = '&';
	const char* pc = src+1;
	const char* start = pc;
	int n=0;
	while(*pc!='\0' && *pc!=';'){
		n++;
		pc++;
	}
	if(*pc=='\0'){
		return src+1;
	}
	n++;
	if(strncmp(start,"lt;",n)==0){
		*decodeChar = '<';
	}else
	if(strncmp(start,"gt;",n)==0){
		*decodeChar = '>';
	}else
	if(strncmp(start,"amp;",n)==0){
		*decodeChar = '&';
	}else
	if(strncmp(start,"quot;",n)==0){
		*decodeChar = '\"';
	}else{
		return src+1;
	}
	return pc+1;
}




static void setCharFlags(const char* src, int length, unsigned int* charFlags)
{
	int n;

	for(n=0;n<length+1;n++){
		charFlags[n]=0;
	}
	n=0;
	char prevchar=src[0];
	bool prevIsSjis1st = false;
	while(src[n]){
		unsigned char b = (unsigned char)src[n];
		if(b==' '){
			charFlags[n] = (unsigned int)SMarkupTextLine::BREAKABLE;
		}else
		if(prevchar == '-'){
			charFlags[n] = (unsigned int)SMarkupTextLine::BREAKABLE;
		}else if(g_bJapaneseLangEnv){
			if(prevIsSjis1st){
				prevIsSjis1st = false;
			}else if((b>=0x81 && b<=0x9F)||(b>=0xE0 && b<=0xFC)){
				char szMBchar[2];
				szMBchar[0]=src[n];
				szMBchar[1]=src[n+1];
				const char* szSJIS_NON_BREAKABLE = "ʃABCDFGXnrtvxzljpfhIH"; 
				int m =0;
				bool sjis_non_breakable = false;
				for(int ccnt = 0; ccnt<26; ccnt++){
					if(strncmp(szMBchar,szSJIS_NON_BREAKABLE+m,2)==0){
						sjis_non_breakable = true;
						break;
					}
					m+=2;
				}
				if(!sjis_non_breakable){
					charFlags[n] = (unsigned int)SMarkupTextLine::BREAKABLE;
				}
				prevIsSjis1st = true;
			}
		}
		n++;
	}
}

			

// < Ŏn܂^Ỏ͂s
// ߂l̓T|[g^ÔƂ́A   >L̎̕B
//         T|[g^ÔƂ́A <L|CgB ̓삪analyzeAmpEncode()ƈقȂ
static const char* analyzeTag(const char* src, unsigned int *pType,bool* pCloseTag,  string* pstrOption)
{
	*pType = (unsigned int)SMarkupTextLine::NO_STYLE;
	*pstrOption = "";
	*pCloseTag = false;

	const char* pc = src;
	pc++;
	//pc͊Jʂ̎̕|Cg


	//JʂɑXy[Xǂݔ΂
	while(iswspace(*pc) && *pc!='\0'){
		pc++;
	}

	if(*pc=='\0')return src;


	if(*pc == '/'){
		*pCloseTag = true;
		pc++;
	}

	const char* start = pc;

	int n=0;
	while(*pc && *pc != '>'){
		n++;
		pc++;
	}
		
	//ʂOɏI[ɒB߂B
	if(*pc=='\0') return src;

	const char* next = pc+1;	//next͕ʂ̎̕|CgB
	
	pc--;
	//pc͕ʂ̒O̕|Cg

	//ʂ̑ÕXy[X폜
	while(iswspace(*pc) && n>0){
		n--;
		pc--;
	}

	if(n==1){
		if(*start == 'O'){
			*pType = (unsigned int)SMarkupTextLine::OVERBAR;
		}else
		if(*start == 'U'){
			*pType = (unsigned int)SMarkupTextLine::UNDERLINE;
		}else
		if(*start == 'B'){
			*pType = (unsigned int)SMarkupTextLine::BOLD;
		}else
		if(*start == 'I'){
			*pType = (unsigned int)SMarkupTextLine::ITALIC;
		}else{
			*pType = (unsigned int)SMarkupTextLine::NO_STYLE;
		}
		//return next;
	}else if(n==3){
		if(strncmp(start,"SUB",3)==0){
			*pType = (unsigned int)SMarkupTextLine::SUB;
		}else
		if(strncmp(start,"SUP",3)==0){
			*pType = (unsigned int)SMarkupTextLine::SUP;
		}else{
			*pType = (unsigned int)SMarkupTextLine::NO_STYLE;
		}
		//return next;
	}else if(strncmp(start,"FONT",4)==0){
		if(*pCloseTag){
			if(n==4){
	            *pType = (unsigned int)SMarkupTextLine::FONT_NAME;
				//return next;
			}
		}else{
			start+=4;
			//start"FONT"ɑ|Cg
			if(iswspace(*start)){
				n-=4;
				while(iswspace(*start) && n>0){
					start++;
					n--;
				}
				if(n>0){
					*pstrOption=string(start,n);
				}
	            *pType = (unsigned int)SMarkupTextLine::FONT_NAME;
				//return next;
			}
		}
	}
	if(*pType == (unsigned int)SMarkupTextLine::NO_STYLE){
		return src;
	}else{
		return next;
	}
}




///^OteLXg\[X}[NAbvPʂɕB
void g_CreateMarkupTextLines(const char* src,MarkupTextLineList* pMarkupTextLineList)
{
	MarkupTextLineIterator ite;
	unsigned int textStyle = 0;;
	StringStack fontNameStack;
	string currentFont = "";
	SMarkupTextLine* pmt = new SMarkupTextLine();


	//}[NAbveLXgCXg̑S
	ite = pMarkupTextLineList->begin();
	while(ite != pMarkupTextLineList->end()){
		delete(*ite);
		ite++;
	}
	pMarkupTextLineList->clear();
	
	//int charCount = 0;
	//string tempString = "";
	while(*src != '\0'){
		if(*src=='<'){
			unsigned int changedStyle = textStyle;
			bool fontChanged = false;
			bool closeTag;
			unsigned int tagType;
			string fontName;
			src = analyzeTag(src,&tagType,&closeTag,&fontName);

			if(tagType!=SMarkupTextLine::NO_STYLE){
				if(closeTag){
					if(tagType==(unsigned int)SMarkupTextLine::FONT_NAME){
						if(!fontNameStack.empty()){
							currentFont =fontNameStack.top(); 
							fontNameStack.pop();
							fontChanged = true;
						}
					}else{
						changedStyle &= ~tagType;
					}
				}else{
					if(tagType==(unsigned int)SMarkupTextLine::FONT_NAME){
						if(!fontName.empty()){
							fontNameStack.push(currentFont);
							currentFont = fontName;
							fontChanged = true;
						}
					}else{
						if(tagType == (unsigned int)SMarkupTextLine::SUB){
							changedStyle &= ~(unsigned int)SMarkupTextLine::SUP;
							changedStyle |= (unsigned int)SMarkupTextLine::SUB;
						}else if(tagType == (unsigned int)SMarkupTextLine::SUP){
							changedStyle &= ~(unsigned int)SMarkupTextLine::SUB;
							changedStyle |= (unsigned int)SMarkupTextLine::SUP;
						}else{
							changedStyle |= tagType;
						}
					}
				}
				if(fontChanged || (changedStyle != textStyle)){
					textStyle = changedStyle; 
					if(pmt->m_strText.length()>0){
						pMarkupTextLineList->push_back(pmt);
						pmt = new SMarkupTextLine();
					}					
					pmt->m_fontName = currentFont;
					pmt->m_textSyle = textStyle;
				}
				continue;	//^OƂĔFłꍇ͕Ƃēo^ȂBȊO͉֔ĕƂēo^
			}
		}
		if(*src=='\n'){
			pmt->m_textSyle |= (unsigned int)SMarkupTextLine::CR;
			pMarkupTextLineList->push_back(pmt);
			pmt = new SMarkupTextLine();
			pmt->m_fontName = currentFont;
			pmt->m_textSyle = textStyle;
			src++;
		}else if(*src!='\r'){
			char c;
			if(*src == '&'){
				src = analyzeAmpEncode(src,&c);
			}else{
				c = (iswspace(*src) ? ' ' : *src);
				src++;
			}
			pmt->m_strText += c;
		}else{
			src++;
		}
	}
	if(pmt->m_strText.length()>0){
		pMarkupTextLineList->push_back(pmt);
	}
	ite = pMarkupTextLineList->begin();
	while(ite != pMarkupTextLineList->end()){
		int length = (*ite)->m_strText.length();
		(*ite)->m_charFlags =(unsigned int*) new int[length+1];
		setCharFlags((*ite)->m_strText.c_str(),length, (*ite)->m_charFlags);
//#ifdef _DEBUG
//#ifdef _MFCBSCH
//		TRACE("%s STYLE:%04X FONT:%s\n",(*ite)->m_strText.c_str(),(*ite)->m_textSyle,(*ite)->m_fontName.c_str());
//		for(int dn = 0;dn<length;dn++){
//			TRACE("%d",((*ite)->m_charFlags)[dn]);
//		}
//		TRACE("\n");
//#endif
//#endif
		ite++;
	}

}
