/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2006 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// CompEditView.cpp : CCompEditView NX̎
//

#include "stdafx.h"
#include "LCoV.h"
#include "CompEditView.h"
#include "draw.h"
#include "pattern.h"
#include ".\compeditview.h"
#include "PinProperty.h"
#include "PtnProperty.h"
#include "PtnTextDlg.h"
#include "PinProps.h"
#include "coord2.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CCompEditView

CCompEditView::CCompEditView()
{
	m_tool = TOOL_SELECT;
	m_placeState = 0;
	m_pBmpBuff = NULL;
	m_offScrnBuffSize = CSize(0,0);
	m_offScrnBuffOrg = CPoint(INT_MIN,INT_MIN);
	m_zoomNum = 0;
	m_magV = 1;			//\{̕q
	m_magW = 1;			//\{̕
	m_block = 0;
	m_pCompIndex = NULL;
	m_pageSize = CSize(10,10);	//KȒl
	m_windowOrg = CPoint(0,0);	//KȒl
	m_pCursorPin = NULL;
	m_dragOpStatus = DRAGOP_NOT;
	m_startSelect = false;
	m_editNodeMode = false;
	m_movingGrip = -1;
	m_nWHEEL_DELTA_z = 0;
	m_nWHEEL_DELTA_s = 0;
	m_tempAreaRectValid = false;
	m_enableContextMenu = false;
	m_captureFlag = 0;
	m_pPinPropsDlg = new CPinProps(this);
	m_displayPinProps = false;
	m_bDrawAddNodeIcon = false;	// 2009/07/20ǉ

	m_bIsCursorOnActivePolygon = false;

	{
		::g_bIsWin9x = false;
		OSVERSIONINFO versionInfo;
		versionInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
		if(GetVersionEx(&versionInfo)){
			::g_bIsWin9x = (versionInfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS);
		}
//		g_bIsWin9x=true;	//test
	}

}

CCompEditView::~CCompEditView()
{
	delete m_pBmpBuff;
	delete 	m_pCursorPin;
	delete m_pPinPropsDlg;
}

void  CCompEditView::setEditNodeMode(bool editnode)
{
	if(editnode != m_editNodeMode){
		m_editNodeMode = editnode;
		if(m_doc.m_listTemp.size()>0){
			Invalidate(FALSE);
		}
	}
}

void CCompEditView::setTool(int tool)
{
	if(m_tool == tool) return;

	delete 	m_pCursorPin;
	m_pCursorPin = NULL;

	//if(m_doc.releaseTemp()){
	if(releaseTemp()){
		//drawToBuff(true);
	}
	m_placeState = 0;
	m_tool = tool;
	switch(m_tool){
		case TOOL_PIN:
			m_pCursorPin = new SPin;
			m_pCursorPin->setBlock(1);
			m_pCursorPin->setPinName("");
			m_pCursorPin->setPinNum(0,"");
			break;
	}
	m_movingGrip = -1;

	Invalidate(FALSE);
}




bool CCompEditView::canDelete()
{
	if(m_doc.m_listTemp.size()>0) return true;
	else return false;
}

bool CCompEditView::doDelete()
{
	bool pinSelected = m_doc.isPinSelected();
	if(!m_doc.delTemp()){
		return false;
	}
	Invalidate(FALSE);
	if(pinSelected){
		m_pPinPropsDlg->update();
	}
	return true;
}

bool CCompEditView::canCopy()
{
	if(m_doc.m_listTemp.size()>0) return true;
	else return false;
}

bool CCompEditView::canMirrorRotate()
{
	if(m_doc.m_listTemp.size()==0) return false;
	SCompEditElmListIterator ite;
	ite = m_doc.m_listTemp.begin();
	if(ite->m_dataType==SCompEditDoc::DATATYPE_PIN) return false;
	return true;
}


bool CCompEditView::doMirror()
{
	if(!m_doc.mirror()) return false;
	Invalidate(FALSE);
	return true;
}

bool CCompEditView::doRotate()
{
	if(!m_doc.rotate()) return false;
	Invalidate(FALSE);
	return true;
}


bool CCompEditView::doCopy()
{
	if(!m_doc.copy()) return false;
	Invalidate(FALSE);
	return true;
}

bool CCompEditView::canUndo()
{
	return m_doc.canUndo();
}

bool CCompEditView::doUndo()
{
	m_doc.undo();
	drawToBuff(true);
	Invalidate(FALSE);
	m_pPinPropsDlg->update();
	return true;
}


bool CCompEditView::canPaste()
{
	static const char* pcszIDPIN= "+LCOV_PIN_V.1.0";
	static const char* pcszIDPTN= "+LCOV_PTN_V.1.0";

	int nIdLengthPIN = strlen(pcszIDPIN);
	int nIdLengthPTN = strlen(pcszIDPTN);

	bool retVal = false;
	if(::IsClipboardFormatAvailable(CF_TEXT)){
		::OpenClipboard(AfxGetMainWnd()->m_hWnd);		//Open clip board.
		HGLOBAL hGMem=::GetClipboardData(CF_TEXT);		//Get memory handle.
		if(hGMem!=NULL){
			int nLength=GlobalSize(hGMem);				//Size of clip board data.
			if(nLength>nIdLengthPIN*2){
				char* pgBuff=(char*)::GlobalLock(hGMem);	//Lock global memory.
				if(strncmp(pcszIDPIN,pgBuff,nIdLengthPIN)==0){
					retVal = true;
				}
				if(strncmp(pcszIDPTN,pgBuff,nIdLengthPTN)==0){
					retVal = true;
				}
				::GlobalUnlock(hGMem);				//Unock global memory.
			}
		}
		::CloseClipboard();
	}
	return retVal;
}






bool CCompEditView::doPaste()
{
	if(!canPaste())return false;
	setTool(TOOL_SELECT);
	//if(m_doc.releaseTemp()){
	if(releaseTemp()){
		//drawToBuff(true);
	}

	::OpenClipboard(AfxGetMainWnd()->m_hWnd);		//Open clip board.
	HGLOBAL hGMem=::GetClipboardData(CF_TEXT);		//Get memory handle.
	if(hGMem==NULL){
		::CloseClipboard();						//Close clip board.
		return false;
	}
	char* pgBuff=(char*)::GlobalLock(hGMem);	//Lock global memory.
	string cbbuff=string(pgBuff);				//Initialize string with global memory.
	::GlobalUnlock(hGMem);						//Unock global memory.
	::CloseClipboard();							//Close clip board.


	SReadCE3 rce3;
	rce3.Attach(cbbuff.c_str());

	string str;

	rce3.ReadRecord(str);
	if(str == "+LCOV_PIN_V.1.0"){
		return doPastePin(rce3);
	}else if(str == "+LCOV_PTN_V.1.0"){
		return doPastePtn(rce3);
	}
	return false;
}


bool CCompEditView::doPastePin(SReadCE3& rce3)
{
	delete m_pCursorPin;
	m_pCursorPin = NULL;
	bool retv = false;
	string str;
	while(rce3.ReadRecord(str)!=EOF){
		if(str[0] == '-'){
			break;
		}else if(str[0] == '+'){
			if(str=="+PIN"){
				m_pCursorPin = new SPin;
				if(m_pCursorPin->readCe3(rce3,m_pCompIndex->block())){
					retv = true;
				}else{
					delete m_pCursorPin;
					m_pCursorPin = NULL;
				}
				break;
			}else{
				str[0]='-';
				if(rce3.SkipTo(str) == EOF){
					break;
				}
			}
		}
	}
	m_pPinPropsDlg->update();
	m_tempAreaRectValid=false;
	Invalidate(FALSE);
	return retv;
}

bool CCompEditView::doPastePtn(SReadCE3& rce3)
{
	CPoint ptOffset = m_windowOrg;
	LPtoCompEditP(ptOffset);
	if(ptOffset.x<0) ptOffset.x = 0;
	if(ptOffset.y<0) ptOffset.y = 0;


	bool retv = false;
	string str;
	m_doc.incrementOpCount();
	while(rce3.ReadRecord(str)!=EOF){
		if(str[0] == '-'){
			break;
		}else if(str[0] == '+'){
			SPtnObj* pPtnObj=NULL;
			if(str=="+L"){
				pPtnObj = new SPtnObjLine;
			}else if(str=="+C"){
				pPtnObj = new SPtnObjCircle;
			}else if(str=="+PG"){
				pPtnObj = new SPtnObjPolygon;
			}else if(str=="+AR"){
				pPtnObj = new SPtnObjArc;
			}else if(str=="+TX"){
				pPtnObj = new SPtnObjText;
			}else{
				str[0]='-';
				if(rce3.SkipTo(str) == EOF){
					retv= false;
					break;
				}
			}
			if(pPtnObj!=NULL){
				if(pPtnObj->readCe3(rce3)){
					pPtnObj->move(ptOffset.x,ptOffset.y);
					m_doc.addPtnToTemp(pPtnObj);
				}
				delete pPtnObj;
			}
		}
	}
//	m_doc.setupTempArea();
	m_tempAreaRectValid=false;
	Invalidate(FALSE);
	return false;
}


bool CCompEditView::canProperty()
{
	if(m_doc.m_listTemp.size()==1) return true;
	else return false;
}

bool CCompEditView::nextPinNumber()
{
	if(!canNextPinNumber()) return false;

	SCompEditElmListIterator ite;
	ite = m_doc.m_listTemp.begin();
	SPin* pPin =(SPin*)ite->m_pData;

	string str = SCompEditDoc::nextString(m_doc.m_lastPinNumber);

	pPin->setPinNum(0,str.c_str());
	m_doc.m_lastPinNumber = str;

	m_tempAreaRectValid = false;
	m_doc.m_tempDirtyFlag = true;

	m_pPinPropsDlg->update();

	Invalidate(FALSE);

	return true;
}

bool CCompEditView::nextPinName()
{
	if(!canNextPinName()) return false;

	SCompEditElmListIterator ite;
	ite = m_doc.m_listTemp.begin();
	SPin* pPin =(SPin*)ite->m_pData;

	string str = SCompEditDoc::nextString(m_doc.m_lastPinName);

	pPin->setPinName(str.c_str());
	m_doc.m_lastPinName = str;

	m_tempAreaRectValid = false;
	m_doc.m_tempDirtyFlag = true;

	m_pPinPropsDlg->update();

	Invalidate(FALSE);


	return true;
}



bool CCompEditView::canNextPinNumber()
{
	if(m_doc.m_listTemp.size()==1){
		SCompEditElmListIterator ite;
		ite = m_doc.m_listTemp.begin();
		if(ite->m_dataType==SCompEditDoc::DATATYPE_PIN){
			SPin* pPin =(SPin*)ite->m_pData;
			if(pPin->block()==1){
				return true;
			}
		}
	}
	return false;
}


bool CCompEditView::canNextPinName()
{
	if(m_doc.m_listTemp.size()==1){
		SCompEditElmListIterator ite;
		ite = m_doc.m_listTemp.begin();
		if(ite->m_dataType==SCompEditDoc::DATATYPE_PIN){
			return true;
		}
	}
	return false;
}

void CCompEditView::pinModified()
{
	m_tempAreaRectValid = false;
	m_doc.m_tempDirtyFlag = true;
	Invalidate(FALSE);
	m_pPinPropsDlg->update();
}


bool CCompEditView::editProperty()
{
	if(!canProperty()) return false;
	bool result = false;
	SCompEditElmListIterator ite;
	ite = m_doc.m_listTemp.begin();
	if(ite->m_dataType==SCompEditDoc::DATATYPE_PIN){
		SPin* pPin =(SPin*)ite->m_pData;
		result = editPinProperty(pPin);
	}else{
		SPtnObj* pPtn =(SPtnObj*)ite->m_pData;
		result = editPtnProperty(pPtn);
	}

	if(result){
		m_tempAreaRectValid = false;
		m_doc.m_tempDirtyFlag = true;
		Invalidate(FALSE);
	}
	return result;
}


bool CCompEditView::editPinProperty(SPin* pPin)
{
	if(m_displayPinProps)return false;
	CPinProperty dlg;
//	dlg.m_name = pPin->pinName();
	dlg.setName(pPin->pinName());
	dlg.setBlock(pPin->block());
	int i;
	for(i=0;i<pPin->block();i++){
		if(pPin->pinNum(i)){
			dlg.m_arrayNum[i]=pPin->pinNum(i);
		}else{
			dlg.m_arrayNum[i]="";
		}
	}
	dlg.m_hideNum = (pPin->type() & PIN_TYPE_NUMHIDE);
	dlg.m_pinType = pPin->type() & 0xf;
	if(dlg.DoModal()==IDOK){
		pPin->setPinName(dlg.m_name);
		m_doc.m_lastPinName = dlg.m_name;
		for(i=0;i<pPin->block();i++){
			pPin->setPinNum(i,dlg.m_arrayNum[i]);
		}
		m_doc.m_lastPinNumber = dlg.m_arrayNum[0];
		pPin->setType(dlg.m_pinType | (dlg.m_hideNum ? 	PIN_TYPE_NUMHIDE : 0));	
		return true;
	}
	return false;
}

bool CCompEditView::editPtnProperty(SPtnObj* pPtn)
{
	if(pPtn->id() == VECTPTN_TXT){
		CPtnTextDlg dlg;
		dlg.m_align = ((SPtnObjText*)pPtn)->m_align;
		dlg.m_strText = ((SPtnObjText*)pPtn)->m_strText.c_str();

		strncpy(dlg.m_logfont.lfFaceName,((SPtnObjText*)pPtn)->m_fontName.c_str(),LF_FACESIZE);
		dlg.m_logfont.lfFaceName[LF_FACESIZE-1]='\0';
		dlg.m_logfont.lfHeight=((SPtnObjText*)pPtn)->m_fontSize;
		dlg.m_logfont.lfWeight=(((SPtnObjText*)pPtn)->m_fontBold ?  FW_BOLD : FW_REGULAR);
		dlg.m_logfont.lfItalic=((SPtnObjText*)pPtn)->m_fontItalic;
		dlg.m_logfont.lfCharSet=DEFAULT_CHARSET;

		if(dlg.DoModal()==IDOK){
			((SPtnObjText*)pPtn)->m_align = dlg.m_align;
			((SPtnObjText*)pPtn)->setText(dlg.m_strText);
			((SPtnObjText*)pPtn)->setFontSize(abs(dlg.m_logfont.lfHeight));
			((SPtnObjText*)pPtn)->setFontBold(dlg.m_logfont.lfWeight>=FW_BOLD);
			((SPtnObjText*)pPtn)->setFontItalic(dlg.m_logfont.lfItalic!=0);
			((SPtnObjText*)pPtn)->setFontName(dlg.m_logfont.lfFaceName);
			return true;
		}
	}else{
		CPtnProperty dlg;
		dlg.m_dash = pPtn->m_style;
		dlg.m_width = pPtn->m_width;
		dlg.m_fill = (pPtn->m_nFill!=-1);
		dlg.m_enableFill =( pPtn->id() == VECTPTN_PG || pPtn->id() == VECTPTN_C);
		if(dlg.DoModal()==IDOK){
			pPtn->m_style = ( dlg.m_dash ? 1 : 0);
			pPtn->m_nFill = ( dlg.m_fill ? 1 : -1);
			pPtn->m_width = dlg.m_width;
			return true;
		}
	}
	return false;
}



void CCompEditView::setZoomValue(int n)
{
	if(n<MIN_ZOOMNUM) n=MIN_ZOOMNUM;
	if(n>MAX_ZOOMNUM) n=MAX_ZOOMNUM;
	static int aMagV[MAX_ZOOMNUM+1] = {1,2,5,10};
	m_magV = aMagV[n];
	m_magW = 1;
	m_zoomNum = n;
	setPageSize();
	
	CPoint pt;
	GetCursorPos(&pt);
	this->ScreenToClient(&pt);
	CRect rc;
	this->GetClientRect(&rc);
	if((pt.x>=0) && (pt.y>=0) && pt.x<=rc.right && pt.y<=rc.bottom){
		scrollTo(pt,m_pointCurrentPos);
	}else{
		Invalidate();
	}

	if(m_captureFlag == RBUTTON_CAPTURE){
		m_pointRButtonDownDevice = pt;
		CClientDC dc(this);	//NCAgGÃfoCXReLXg𓾂
		PrepareDC(&dc);		//foCXReLXgɃXN[l̔f
		dc.DPtoLP(&pt);	//}EX̍W_Wɕϊ
		CPoint ptCompEdit = pt;
		LPtoCompEditP(ptCompEdit);//}EX̍WҏWWɕϊ
		m_pointRButtonDown = ptCompEdit;
	}



}
	



bool CCompEditView::releaseTemp()
{
	m_bIsCursorOnActivePolygon = false;

	bool pinSelected = m_doc.isPinSelected();
	if(pinSelected){
		m_pPinPropsDlg->PreReleaseTemp();
	}

	if(m_doc.releaseTemp()){
		drawToBuff(true);
		Invalidate(FALSE);

		if(pinSelected){
			m_pPinPropsDlg->update(); //s̑IԁAAʒuςƂʒmB
		}

		return true;
	}else{
		return 	false;
	}
}

void CCompEditView::setCompIndex(SCompIndex* pCompIndex)
{
	m_pCompIndex = pCompIndex;
	if(m_pCompIndex){
		m_doc.loadCompInfo(m_pCompIndex->m_pCompInfo);
	}else{
		m_doc.init();
	}
	setPageSize();
	m_block =0;
	delete m_pCursorPin;

	m_pCursorPin = NULL;
	m_bIsCursorOnActivePolygon = false;

	setTool(TOOL_SELECT);
//	if(m_pCursorPin != NULL){
//		m_pCursorPin->setLtrb(0);
//		m_pCursorPin->setOffset(0);
//	}
	m_pPinPropsDlg->update(); //s̑IԁAAʒuςƂʒmB
	m_pPinPropsDlg->initBlock();

	Invalidate(FALSE);
}

void CCompEditView::saveCompInfo()
{
	if(m_pCompIndex){
		m_doc.saveCompInfo(m_pCompIndex->m_pCompInfo);
	}
}

BEGIN_MESSAGE_MAP(CCompEditView, CWnd)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_SIZE()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_COMMAND(ID_VIEW_ZOOMIN, OnViewZoomin)
	ON_COMMAND(ID_VIEW_ZOOMOUT, OnViewZoomout)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOMIN, OnUpdateViewZoomin)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOMOUT, OnUpdateViewZoomout)
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	ON_WM_KEYDOWN()
	ON_WM_MOUSEWHEEL()
	ON_WM_CONTEXTMENU()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_VIEW_PINPROPS_WND, OnViewPinprops)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PINPROPS_WND, OnUpdatePinprops)
	ON_WM_CREATE()
	ON_COMMAND(ID_ADD_NODE, &CCompEditView::OnAddNode)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE, &CCompEditView::OnUpdateAddNode)
END_MESSAGE_MAP()



// CChildView bZ[W nh

BOOL CCompEditView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.style |=  WS_VSCROLL |WS_HSCROLL;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), reinterpret_cast<HBRUSH>(COLOR_WINDOW+1), NULL);

	return TRUE;
}


//Wϊ _WƕiҏWW̑ݕϊ
void CCompEditView::LPtoCompEditP(CPoint& point)
{
	point.x = point.x*m_magW/m_magV;
	point.y = point.y*m_magW/m_magV;
}


void CCompEditView::LPtoCompEditP(CRect& rc)
{
	rc.left   = rc.left*m_magW/m_magV;
	rc.top	  = rc.top*m_magW/m_magV;
	rc.right  = rc.right*m_magW/m_magV;
	rc.bottom = rc.bottom*m_magW/m_magV;
}

void CCompEditView::CompEditPtoLP(CPoint& point)
{
	point.x = point.x*m_magV/m_magW;
	point.y = point.y*m_magV/m_magW;
}

void CCompEditView::CompEditPtoLP(CRect& rc)
{
	rc.left   = rc.left*m_magV/m_magW;
	rc.top	  = rc.top*m_magV/m_magW;
	rc.right  = rc.right*m_magV/m_magW;
	rc.bottom = rc.bottom*m_magV/m_magW;
}


//s̔zuBsȂm_pCursorPinTempDataɔzuB
//ĂԑOTempf[^m肳Ă邱
bool CCompEditView::placePin()
{
	if(m_pCompIndex == NULL) return false;
	if(m_pCursorPin == NULL) return false;
	if(m_doc.pinConflict(m_pCursorPin)) return false;
//	if(m_doc.releaseTemp()){
//		this->drawToBuff(true);
//	}
	//s̍NCAgGAłȂƔzuȂ
	SPoint sptPin =m_doc.pinPosition(m_pCursorPin->ltrb(),m_pCursorPin->offset());
	CPoint ptPin(sptPin.x(),sptPin.y());
	CRect rcClient = CRect(m_windowOrg,m_clientSize);
	LPtoCompEditP(rcClient);
	if(!rcClient.PtInRect(ptPin)) return false;
	//JEgCNgāAꎞf[^ɔzu
	m_doc.incrementOpCount();
	m_pCursorPin->setBlock(m_pCompIndex->block());
	m_doc.addPinToTemp(m_pCursorPin);
	m_doc.setupTempArea();
	m_doc.m_tempDirtyFlag = true;
	if(m_tool == TOOL_SELECT){
		delete m_pCursorPin;
		m_pCursorPin = NULL;
	}
	m_pPinPropsDlg->update();	//sǉꂽAsҏW_CAOXVB
	return true;
}

		
void CCompEditView::drawCompFrame(CDC* pDC)
{
	if(!m_pCompIndex) return;

	bool usePtn = false;
	if(m_pCompIndex->m_pCompInfo->m_pPtn){
		SPtn *pPtn = m_pCompIndex->m_pCompInfo->m_pPtn;
		usePtn = true;
		if(pPtn->m_pBuff){
			g_Pattern.PutPtn(pDC,0,0,pPtn->m_pBuff,pPtn->m_size.w(),pPtn->m_size.h(),
				RGB(128,255,255),DRAW_ON,0,FALSE,m_magV,m_magW);
		}
	}


	SSize sz = m_pCompIndex->size();
	CPoint ptCompRightBottom = CPoint(sz.w()*10,sz.h()*10);
	CompEditPtoLP(ptCompRightBottom);
	CPen newPen;
	CPen* pOldPen;

	int width;
	COLORREF col;

	if(usePtn){
		width = 0;
		col = RGB(192,192,192);
	}else{
		width = 1*m_magV/m_magW;
		col = COL_PART;
	}

	newPen.CreatePen(PS_SOLID,width,col);
	pOldPen = pDC->SelectObject(&newPen);
	pDC->MoveTo(0,0);
	pDC->LineTo(ptCompRightBottom.x,0);
	pDC->LineTo(ptCompRightBottom.x,ptCompRightBottom.y);
	pDC->LineTo(0,ptCompRightBottom.y);
	pDC->LineTo(0,0);
	pDC->SelectObject(pOldPen);

}

void CCompEditView::drawPin(CDC* pDC,SPin* pPin,int block,DWORD dwMode)
{
	if(!pPin)return;
	SPoint pinPos;
	if(pPin->block()<=block) block = pPin->block()-1;
	SSize sz = m_pCompIndex->size();
	int offset = pPin->offset()*10;
	int ltrb = pPin->ltrb();

	switch(ltrb&3){
		case 0:
			pinPos.setX(0);
			pinPos.setY(offset);
			break;
		case 1:
			pinPos.setX(offset);
			pinPos.setY(0);
			break;
		case 2:
			pinPos.setX(sz.w()*10);
			pinPos.setY(offset);
			break;
		case 3:
			pinPos.setX(offset);
			pinPos.setY(sz.h()*10);
			break;
	}


	g_drawComponentPin(
		pDC,						//`
		pinPos,
		pPin->type(),
		ltrb,
		pPin->pinName(),			//s
		pPin->pinNum(block),		//sԍ
		dwMode,						//`惂[h
		m_magV,						//\{(View)
		m_magW,						//\{(Window)
		NULL);						//Nbv
}


void CCompEditView::drawPins(CDC* pDC,SCompEditElmList& list,DWORD dwMode)
{
	//int block = activeBlock();
	SCompEditElmListIterator ite;
	ite = list.begin();
	while(ite != list.end()){
		if(ite->m_deleteOpCount<0){
			if(ite->m_dataType==SCompEditDoc::DATATYPE_PIN){
				SPin* pPin =(SPin*)ite->m_pData;
				drawPin(pDC,pPin,m_block,dwMode);
				//drawPin(pDC,pPin,block,dwMode);
			}
		}
		ite++;
	}
}

void CCompEditView::drawXCursor(CDC* pDC)
{
	if(!m_drawXcursor) return;
	CPoint ptXcursor = m_pointCurrentPos;
	CompEditPtoLP(ptXcursor);

	int nOldDrawMode;
	CPen penNew;
	CPen* ppenOld;
	penNew.CreatePen(PS_SOLID,0,RGB(192,192,192));
	ppenOld=pDC->SelectObject(&penNew);			//쐬y̑I
	nOldDrawMode=pDC->SetROP2(R2_XORPEN);	//`惂[h̐ݒ

	pDC->MoveTo(ptXcursor.x-10,ptXcursor.y);
	pDC->LineTo(ptXcursor.x+10,ptXcursor.y);
	pDC->MoveTo(ptXcursor.x,ptXcursor.y-10);
	pDC->LineTo(ptXcursor.x,ptXcursor.y+10);


	pDC->SetROP2(nOldDrawMode);
	pDC->SelectObject(ppenOld);
}


void CCompEditView::drawPlaceLine(CDC* pDC)
{
	CPen newPen;
	CPen* pPenOld;
	int x0,y0,x1,y1;

	int width = 0;
	newPen.CreatePen(PS_SOLID,width,RGB(255,0,0));
	pPenOld = pDC->SelectObject(&newPen);

	x0=m_arrayTempPoint[0].x();
	y0=m_arrayTempPoint[0].y();

	x0 = (x0*m_magV)/m_magW;
	y0 = (y0*m_magV)/m_magW;
	pDC->MoveTo(x0,y0);

	for(int n=1;n<=m_placeState;n++){
		x1=m_arrayTempPoint[n].x();
		y1=m_arrayTempPoint[n].y();

		x1 = (x1*m_magV)/m_magW;
		y1 = (y1*m_magV)/m_magW;
		pDC->LineTo(x1,y1);
	}
	if(m_placeState>1){
		pDC->LineTo(x0,y0);
	}
	//TRACE("drawPlaceLine %d,%d,%d,%d\n",x0,y0,x1,y1);


	pDC->SelectObject(pPenOld);
}

void CCompEditView::drawPlaceCircle(CDC* pDC)
{
	CPen newPen;
	CPen* pPenOld;
	int x0,y0,x1,y1;

	int width = 0;
	newPen.CreatePen(PS_SOLID,width,RGB(255,0,0));
	pPenOld = pDC->SelectObject(&newPen);

	CBrush* pBrushOld=(CBrush*)pDC->SelectStockObject(NULL_BRUSH);

	x0=m_arrayTempPoint[0].x();
	y0=m_arrayTempPoint[0].y();

	x0 = (x0*m_magV)/m_magW;
	y0 = (y0*m_magV)/m_magW;

	x1=m_arrayTempPoint[1].x();
	y1=m_arrayTempPoint[1].y();

	x1 = (x1*m_magV)/m_magW;
	y1 = (y1*m_magV)/m_magW;

	CRect rc(x0,y0,x1,y1);
	rc.NormalizeRect();
	rc.right++;
	rc.bottom++;

	pDC->Ellipse(&rc);
	pDC->SelectObject(pBrushOld);
	pDC->SelectObject(pPenOld);

}


void CCompEditView::drawPlaceArc(CDC* pDC)
{
	CPen newPen;
	CPen* pPenOld;

	int xc,yc,r,x0,y0,x1,y1,x2,y2,x3,y3;

	int width = 0;


	xc=m_arrayTempPoint[0].x();
	yc=m_arrayTempPoint[0].y();
	r =abs(m_arrayTempPoint[0].x()-m_arrayTempPoint[1].x());

	x0 = xc-r;
	y0 = yc-r;
	x1 = xc+r;
	y1 = yc+r;

	x0 = (x0*m_magV)/m_magW;
	y0 = (y0*m_magV)/m_magW;
	x1 = (x1*m_magV)/m_magW;
	y1 = (y1*m_magV)/m_magW;

	CRect rc(x0,y0,x1,y1);
	rc.NormalizeRect();
	rc.right++;
	rc.bottom++;

	newPen.CreatePen(PS_SOLID,width,RGB(220,220,220));
	pPenOld = pDC->SelectObject(&newPen);
	CBrush* pBrushOld=(CBrush*)pDC->SelectStockObject(NULL_BRUSH);
	pDC->Ellipse(&rc);
	pDC->SelectObject(pBrushOld);
	pDC->SelectObject(pPenOld);
	newPen.DeleteObject();

	if(m_placeState>=2){
		x2 = m_arrayTempPoint[2].x();
		y2 = m_arrayTempPoint[2].y();
		if(m_placeState==2){
			x3 = xc-(x2-xc);
			y3 = yc-(y2-yc);
		}else{
			x3 = m_arrayTempPoint[3].x();
			y3 = m_arrayTempPoint[3].y();
		}
		x2 = (x2*m_magV)/m_magW;
		y2 = (y2*m_magV)/m_magW;
		x3 = (x3*m_magV)/m_magW;
		y3 = (y3*m_magV)/m_magW;

		CPoint ptBegin = CPoint(x2,y2);
		CPoint ptEnd  = CPoint(x3,y3);


		newPen.CreatePen(PS_SOLID,width,RGB(255,0,0));
		pPenOld = pDC->SelectObject(&newPen);
		pDC->Arc(&rc,ptBegin,ptEnd);
		pDC->SelectObject(pPenOld);
		newPen.DeleteObject();
	}
}

void CCompEditView::drawPtn(CDC* pDC,SPtnObj* pPtn,int cx,int cy,COLORREF col,int magV,int magW)
{
	switch(pPtn->id()){
		case VECTPTN_L:
			g_DrawPtnLine(
				pDC,				// CDC* pDC,				//`
				(SPtnObjLine*)pPtn,	// pObj,		//`IuWFNg
				col,				// COLORREF col,			//`F
				0,					//int	 dir,
				cx,					//int	 cx,
				cy,					//int  cy,
				0,					//int	 x0,
				0,					//int  y0,
				magV,				//int  nVExt,				//\{(View)
				magW);			//int  nWExt)				//\{(Window)
				break;
		case VECTPTN_C:
			g_DrawPtnCircle(
				pDC,				//`
				(SPtnObjCircle*)pPtn,	// pObj,	//`IuWFNg
				col,					//COLORREF col,			//`F
				0,						//int	 dir,
				cx,						//int	 cx,
				cy,						//int  cy,
				0,						//int	 x0,
				0,						//int  y0,
				magV,					//int  nVExt,				//\{(View)
				magW);				//int  nWExt)				//\{(Window)
			break;
		case VECTPTN_PG:
			g_DrawPtnPolygon(
				pDC,				//`
				(SPtnObjPolygon*)pPtn,	// pObj,	//`IuWFNg
				col,					//COLORREF col,			//`F
				0,						//int	 dir,
				cx,						//int	 cx,
				cy,						//int  cy,
				0,						//int	 x0,
				0,						//int  y0,
				magV,					//int  nVExt,				//\{(View)
				magW);				//int  nWExt)				//\{(Window)
			break;
		case VECTPTN_AR:
			g_DrawPtnArc(
				pDC,				//`
				(SPtnObjArc*)pPtn,		// pObj,		//`IuWFNg
				col,					//COLORREF col,			//`F
				0,						//int	 dir,
				cx,						//int	 cx,
				cy,						//int  cy,
				0,						//int	 x0,
				0,						//int  y0,
				magV,					//int  nVExt,				//\{(View)
				magW);				//int  nWExt)				//\{(Window)
				break;
		case VECTPTN_TXT:
			g_DrawPtnText(
				pDC,				//`
				(SPtnObjText*)pPtn,		// pObj,		//`IuWFNg
				col,					//COLORREF col,			//`F
				0,						//int	 dir,
				cx,						//int	 cx,
				cy,						//int  cy,
				0,						//int	 x0,
				0,						//int  y0,
				magV,					//int  nVExt,				//\{(View)
				magW);				//int  nWExt)				//\{(Window)
				break;
	}
}


void CCompEditView::drawPtns(CDC* pDC,SCompEditElmList& list,DWORD dwMode)
{
	if(list.size()<=0)return;
	if(!m_pCompIndex)return;

	COLORREF col;

	if(dwMode & DRAW_ON)		col = COL_EDITPTN;
	else						col = COL_XOR;


	SSize sz = m_pCompIndex->size();
	int cx=sz.w()*10;
	int cy=sz.h()*10;

	SCompEditElmListIterator ite;
	ite = list.begin();
	while(ite != list.end()){
		if(ite->m_deleteOpCount<0){
			if(ite->m_dataType==SCompEditDoc::DATATYPE_PTN){
				SPtnObj* pPtn =(SPtnObj*)ite->m_pData;
				drawPtn(pDC,pPtn,cx,cy,col,m_magV,m_magW);
			}
		}
		ite++;
	}
}

void CCompEditView::drawGrip(CDC* pDC)
{
	SCompEditElmListIterator ite;
	if(m_doc.m_listTemp.size()!=1 || !m_editNodeMode) return;
	ite = m_doc.m_listTemp.begin();
	if(ite->m_dataType!=SCompEditDoc::DATATYPE_PTN) return;
	SPtnObj* pObj =(SPtnObj*)ite->m_pData;
	int nodes = pObj->gripCount();
	int i;

	CBrush* pBrushOld=(CBrush*)pDC->SelectStockObject(BLACK_BRUSH);
	CPen* pPenOld =(CPen*)pDC->SelectStockObject(BLACK_PEN);

	for(i=0;i<nodes;i++){
		SPoint spt=pObj->gripPos(i);
		CPoint pt(spt.x(),spt.y());
		CompEditPtoLP(pt);
		CRect rc(pt.x-3,pt.y-3,pt.x+3,pt.y+3);
		pDC->Rectangle(&rc);
		if(i==0){
			CBrush* pBrushOld=(CBrush*)pDC->SelectStockObject(WHITE_BRUSH);
		}
	}

	pDC->SelectObject(pBrushOld);
	pDC->SelectObject(pPenOld);
}

void CCompEditView::drawGrid(CDC* pDC)
{
	CPoint ptLeftTop = m_windowOrg;
	CPoint ptRightBottom = ptLeftTop + m_clientSize;
	LPtoCompEditP(ptLeftTop);
	LPtoCompEditP(ptRightBottom);
	int x,y;
	bool grid10only = (m_magV/m_magW < 5);
	bool yGrid10;
	for(y=ptLeftTop.y;y<ptRightBottom.y;y++){
		yGrid10 =  (y%10 == 0);
		if(!yGrid10 && grid10only) continue;
		for(x=ptLeftTop.x;x<ptRightBottom.x;x++){
			if((yGrid10 && (x%10==0))||(!grid10only &&(yGrid10 || (x%10==0)))){
				CPoint pt=CPoint(x,y);
				CompEditPtoLP(pt);
				pDC->SetPixel(pt,RGB(0,0,255));
			}else if(!grid10only){
				CPoint pt=CPoint(x,y);
				CompEditPtoLP(pt);
				pDC->SetPixel(pt,RGB(192,192,192));
			}
		}
	}

}
	

void CCompEditView::PrepareDC(CDC* pDC)
{
	pDC->SetWindowOrg(m_windowOrg);
}


bool CCompEditView::editNodeActive()
{
	SCompEditElmListIterator ite;
	if(m_doc.m_listTemp.size()==1 && m_editNodeMode){
		ite = m_doc.m_listTemp.begin();
		if(ite->m_dataType==SCompEditDoc::DATATYPE_PTN){
			return true;
		}
	}
	return false;
}

void CCompEditView::OnPaint() 
{
	CPaintDC dc(this); // `̃foCX ReLXg
	
	// TODO : ɃbZ[W nh R[hǉ܂B
	
	// bZ[W̕`̂߂ CWnd::OnPaint() ĂяoȂłB

	bool bForceUpdateBuff = false;

	if(m_block != activeBlock()){
		m_block = activeBlock();
		bForceUpdateBuff = true;
	}

	drawToBuff(bForceUpdateBuff);
	PrepareDC(&dc);


	if(!m_pBmpBuff){
		drawCompFrame(&dc);
		drawGrid(&dc);
		drawPins(&dc,m_doc.m_listMain,DRAW_ON);
		drawPtns(&dc,m_doc.m_listMain,DRAW_ON);
	}else{
		CDC dcMem;						//foCXReLXgIuWFNg̍쐬
		dcMem.CreateCompatibleDC(&dc);	//NCAgGAƌ݊̂郁foCXReLXg
		CBitmap* pOldBmp=dcMem.SelectObject(m_pBmpBuff);
		dc.BitBlt(m_windowOrg.x,m_windowOrg.y,m_clientSize.cx,m_clientSize.cy,&dcMem,0,0,SRCCOPY);
		dcMem.SelectObject(pOldBmp);
	}

	drawPins(&dc,m_doc.m_listTemp,DRAW_TEMP);
	drawPtns(&dc,m_doc.m_listTemp,DRAW_TEMP);

	if(m_doc.m_listTemp.size()>0){
		//CRect rcTemp = CRect(
		//		m_doc.m_tempArea.l(),
		//		m_doc.m_tempArea.t(),
		//		m_doc.m_tempArea.r(),
		//		m_doc.m_tempArea.b()
		//	);
		//CompEditPtoLP(rcTemp);

		if(editNodeActive()){
			drawGrip(&dc);
		}else{
			if(!m_tempAreaRectValid){
				m_doc.setupTempArea();
				m_tempAreaRectValid = true;
			}
			CRect rcTemp = CRect(
					m_doc.m_tempArea.l(),
					m_doc.m_tempArea.t(),
					m_doc.m_tempArea.r(),
					m_doc.m_tempArea.b()
				);
			CompEditPtoLP(rcTemp);

			dc.DrawFocusRect(&rcTemp);	//_g̕`
		}
	}

	if(m_tool == TOOL_SELECT && m_startSelect){
		CRect rcTemp = CRect(m_pointLButtonDown,m_pointCurrentPos);
		rcTemp.NormalizeRect();
		CompEditPtoLP(rcTemp);
		//TRACE("%d,%d,%d,%d\n",rcTemp.left,rcTemp.top,rcTemp.right,rcTemp.bottom);
		dc.DrawFocusRect(&rcTemp);	//_g̕`
	}


	if(m_pCompIndex!=NULL){
//		if(m_pCursorPin != NULL && m_doc.m_listTemp.size()==0){
//			drawPin(&dc,m_pCursorPin,0,DRAW_TEMP);
//		}
		if(m_pCursorPin != NULL && m_dragOpStatus == DRAGOP_NOT){// && m_doc.m_listTemp.size()==0){
			drawPin(&dc,m_pCursorPin,0,DRAW_TEMP);
		}

		if(m_tool == TOOL_LINE || m_tool == TOOL_POLYGON ){
			if(m_placeState>0){
				drawPlaceLine(&dc);
			}
		}else if(m_tool == TOOL_CIRCLE){
			if(m_placeState>0){
				drawPlaceCircle(&dc);
			}
		}else if(m_tool == TOOL_ARC){
			if(m_placeState>0){
				drawPlaceArc(&dc);
			}
		}
	}

	if(m_bIsCursorOnActivePolygon){
		int x = (m_ptDividePolygonAt.x * m_magV)/m_magW - 5;
		int y = (m_ptDividePolygonAt.y * m_magV)/m_magW - 5;
		dc.DrawIcon(x,y,m_hDivideMarkIcon);
	}


	drawXCursor(&dc);

}


void CCompEditView::setPageSize()
{
	int cx,cy;
	if(!m_pCompIndex){
		cx = 10;
		cy = 10;
	}else{
		cx = m_pCompIndex->size().w()*10;
		cy = m_pCompIndex->size().h()*10;
	}
	cx = (cx+PAGE_MARGIN*2)*m_magV/m_magW;
	cy = (cy+PAGE_MARGIN*2)*m_magV/m_magW;
	m_pageSize = CSize(cx,cy);

	SendMessage(WM_SIZE,0,MAKELONG(m_clientSize.cx,m_clientSize.cy));
	drawToBuff(true);
}


void CCompEditView::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);
	// TODO : ɃbZ[W nh R[hǉ܂B

	m_clientSize = CSize(cx,cy);

	SCROLLINFO si;

	si.fMask=SIF_RANGE|SIF_POS|SIF_PAGE;

	//XN[o[POSITIOÑftHgl̐ݒ
	si.nPos = m_windowOrg.x+(PAGE_MARGIN*m_magV)/m_magW;
	
	if(m_pageSize.cx<=cx){//NCAgGAy[W傫ꍇ
	//------------|---------------------------|--------------
	//----------------*-------------------*------------------
		si.nPos = 0;
		m_windowOrg.x = -((cx - m_pageSize.cx)/2+(PAGE_MARGIN*m_magV)/m_magW);
	}else if(si.nPos>(m_pageSize.cx-cx)){
		si.nPos = m_pageSize.cx-cx;
		m_windowOrg.x = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	}
	si.nMin=0;
	si.nMax=m_pageSize.cx;
	si.nPage=cx;
	SetScrollInfo(SB_HORZ,&si,TRUE);


	//XN[o[POSITIOÑftHgl̐ݒ
	si.nPos = m_windowOrg.y+(PAGE_MARGIN*m_magV)/m_magW;
	
	if(m_pageSize.cy<=cy){//NCAgGAy[W傫ꍇ
		si.nPos = 0;
		m_windowOrg.y = -((cy - m_pageSize.cy)/2+(PAGE_MARGIN*m_magV)/m_magW);
	}else if(si.nPos>(m_pageSize.cy-cy)){
		si.nPos = m_pageSize.cy-cy;
		m_windowOrg.y = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	}
	si.nMin=0;
	si.nMax=m_pageSize.cy;
	si.nPage=cy;
	SetScrollInfo(SB_VERT,&si,TRUE);

	delete m_pBmpBuff;

	CDC* pDC = GetDC();
	m_pBmpBuff = new CBitmap;		//rbg}bvIuWFNg new 
	if(!m_pBmpBuff) return;
	if(!m_pBmpBuff->CreateCompatibleBitmap(pDC,cx,cy)){
		delete m_pBmpBuff;
		m_pBmpBuff = NULL;
		ReleaseDC(pDC);
		return;
	}
	ReleaseDC(pDC);

	//drawToBuff();
}

bool CCompEditView::save()
{
	if(!m_pCompIndex) return false;
	//bool updateFlag = m_doc.releaseTemp();
	bool updateFlag = releaseTemp();		//20081112
	if(m_doc.m_dirtyFlag){
		saveCompInfo();
	}
	//if(updateFlag){
	//	drawToBuff(true);
	//	Invalidate(false);
	//}
	return true;
}




void CCompEditView::drawToBuff(bool force)
{
	CDC* pDC = GetDC();

	if(!m_pBmpBuff || m_offScrnBuffSize!=m_clientSize){
		delete m_pBmpBuff;
		m_pBmpBuff = new CBitmap;		//rbg}bvIuWFNg new 
		if(!m_pBmpBuff || !m_pBmpBuff->CreateCompatibleBitmap(pDC,m_clientSize.cx,m_clientSize.cy)){
			delete m_pBmpBuff;
			m_pBmpBuff = NULL;
			ReleaseDC(pDC);
			return;
		}
		m_offScrnBuffSize=m_clientSize;
		force = true;
	}

	if(force || m_offScrnBuffOrg != m_windowOrg){

		CBitmap* pOldBmp;
		CDC dcMem;						//foCXReLXgIuWFNg̍쐬
		dcMem.CreateCompatibleDC(pDC);	//NCAgGAƌ݊̂郁foCXReLXg
		pOldBmp=dcMem.SelectObject(m_pBmpBuff);
		CRect rc=CRect(0,0,m_clientSize.cx,m_clientSize.cy);
		dcMem.FillRect(&rc,(CBrush*)dcMem.SelectStockObject(WHITE_BRUSH));	

		PrepareDC(&dcMem);

		drawCompFrame(&dcMem);
		drawGrid(&dcMem);
		drawPins(&dcMem,m_doc.m_listMain,DRAW_ON);
		drawPtns(&dcMem,m_doc.m_listMain,DRAW_ON);

		dcMem.SelectObject(pOldBmp);

		m_offScrnBuffOrg = m_windowOrg;
	}
	ReleaseDC(pDC);
}

void CCompEditView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	//CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
	int nOffset = 0;
	switch(nSBCode){
	case SB_LINEUP:
		nOffset=-20;
		break;
	case SB_LINEDOWN:
		nOffset=+20;
		break;
	case SB_PAGEUP:
		nOffset=-100;
		break;
	case SB_PAGEDOWN:
		nOffset=+100;
		break;
	case SB_THUMBTRACK:
	case SB_THUMBPOSITION:
		break;
	default:
		return;
	}
	SCROLLINFO si;

	si.fMask=SIF_RANGE|SIF_POS|SIF_PAGE;

	//XN[o[POSITIOÑftHgl̐ݒ
	if(nOffset!=0){ //SB_THUMBPOSITION, SB_THUMBTRACKȊÔƂ̏
		m_windowOrg.x += nOffset;
		si.nPos = m_windowOrg.x+(PAGE_MARGIN*m_magV)/m_magW;
		if(si.nPos>(m_pageSize.cx-m_clientSize.cx)){
			si.nPos = m_pageSize.cx-m_clientSize.cx;
		}else if(si.nPos<0){
			si.nPos = 0;
		}
	}else{
		si.nPos = nPos;
	}
	if(m_pageSize.cx<=m_clientSize.cx){//NCAgGAy[W傫ꍇ
		si.nPos = 0;
		m_windowOrg.x = -((m_clientSize.cx - m_pageSize.cx)/2+(PAGE_MARGIN*m_magV)/m_magW);
	}else{
		m_windowOrg.x = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	}
	si.nMin=0;
	si.nMax=m_pageSize.cx;
	si.nPage=m_clientSize.cx;
	SetScrollInfo(SB_HORZ,&si,TRUE);
	//TRACE("OnHScroll m_windowOrg = (%d,%d)\n",m_windowOrg.x,m_windowOrg.y);
	//drawToBuff();
	Invalidate(FALSE);
}

void CCompEditView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	//CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
	int nOffset = 0;
	switch(nSBCode){
	case SB_LINEUP:
		nOffset=-20;
		break;
	case SB_LINEDOWN:
		nOffset=+20;
		break;
	case SB_PAGEUP:
		nOffset=-100;
		break;
	case SB_PAGEDOWN:
		nOffset=+100;
		break;
	case SB_THUMBTRACK:
	case SB_THUMBPOSITION:
		break;
	default:
		return;
	}
	SCROLLINFO si;

	si.fMask=SIF_RANGE|SIF_POS|SIF_PAGE;

	//XN[o[POSITIOÑftHgl̐ݒ
	if(nOffset!=0){ //SB_THUMBPOSITION, SB_THUMBTRACKȊÔƂ̏
		m_windowOrg.y += nOffset;
		si.nPos = m_windowOrg.y+(PAGE_MARGIN*m_magV)/m_magW;
		if(si.nPos>(m_pageSize.cy-m_clientSize.cy)){
			si.nPos = m_pageSize.cy-m_clientSize.cy;
		}else if(si.nPos<0){
			si.nPos = 0;
		}
	}else{
		si.nPos = nPos;
	}
	if(m_pageSize.cy<=m_clientSize.cy){//NCAgGAy[W傫ꍇ
		si.nPos = 0;
		m_windowOrg.y = -((m_clientSize.cy - m_pageSize.cy)/2+(PAGE_MARGIN*m_magV)/m_magW);
	}else{
		m_windowOrg.y = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	}
	si.nMin=0;
	si.nMax=m_pageSize.cy;
	si.nPage=m_clientSize.cy;
	SetScrollInfo(SB_VERT,&si,TRUE);
	//TRACE("OnHScroll m_windowOrg = (%d,%d)\n",m_windowOrg.x,m_windowOrg.y);
	//drawToBuff();
	Invalidate(FALSE);
}

//w肵foCXWAw肵ҏWWɂȂ悤ɃXN[B
void CCompEditView::scrollTo(CPoint ptDevice,CPoint ptEdit)
{
	int xEdit = (ptEdit.x*m_magV/m_magW);
	int yEdit = (ptEdit.y*m_magV/m_magW);
	m_windowOrg.x = xEdit - ptDevice.x;
	m_windowOrg.y = yEdit - ptDevice.y;

	SCROLLINFO si;

	si.nPos = m_windowOrg.x+(PAGE_MARGIN*m_magV)/m_magW;
	if(si.nPos>(m_pageSize.cx-m_clientSize.cx)){
		si.nPos = m_pageSize.cx-m_clientSize.cx;
	}else if(si.nPos<0){
		si.nPos = 0;
	}

	if(m_pageSize.cx<=m_clientSize.cx){//NCAgGAy[W傫ꍇ
		si.nPos = 0;
		m_windowOrg.x = -((m_clientSize.cx - m_pageSize.cx)/2+(PAGE_MARGIN*m_magV)/m_magW);
	}else{
		m_windowOrg.x = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	}
	//else{
	//	m_windowOrg.x = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	//}
	si.nMin=0;
	si.nMax=m_pageSize.cx;
	si.nPage=m_clientSize.cx;
	SetScrollInfo(SB_HORZ,&si,TRUE);




	si.nPos = m_windowOrg.y+(PAGE_MARGIN*m_magV)/m_magW;
	if(si.nPos>(m_pageSize.cy-m_clientSize.cy)){
		si.nPos = m_pageSize.cy-m_clientSize.cy;
	}else if(si.nPos<0){
		si.nPos = 0;
	}
	if(m_pageSize.cy<=m_clientSize.cy){//NCAgGAy[W傫ꍇ
		si.nPos = 0;
		m_windowOrg.y = -((m_clientSize.cy - m_pageSize.cy)/2+(PAGE_MARGIN*m_magV)/m_magW);
	}else{
		m_windowOrg.y = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	}
	//else{
	//	m_windowOrg.y = si.nPos - (PAGE_MARGIN*m_magV)/m_magW;
	//}
	si.nMin=0;
	si.nMax=m_pageSize.cy;
	si.nPage=m_clientSize.cy;
	SetScrollInfo(SB_VERT,&si,TRUE);


	Invalidate(FALSE);


}





void CCompEditView::OnViewZoomin()
{
	// TODO : ɃR}h nh R[hǉ܂B
	//TRACE("ZoomIN\n");
	setZoomValue(m_zoomNum+1);
}

void CCompEditView::OnViewZoomout()
{
	// TODO : ɃR}h nh R[hǉ܂B
	//TRACE("ZoomOUT\n");
	setZoomValue(m_zoomNum-1);
}

void CCompEditView::OnUpdateViewZoomin(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_zoomNum<MAX_ZOOMNUM);
}

void CCompEditView::OnUpdateViewZoomout(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_zoomNum>MIN_ZOOMNUM);
}



void CCompEditView::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CWnd::OnLButtonDown(nFlags, point);
	SetFocus();
	m_captureFlag |= LBUTTON_CAPTURE;
	SetCapture();		//}EX̃Lv`[
	bool bUpdateView = false;
	m_drawXcursor = false;
	CClientDC dc(this);	//NCAgGÃfoCXReLXg𓾂
	PrepareDC(&dc);		//foCXReLXgɃXN[l̔f
	dc.DPtoLP(&point);	//}EX̍W_Wɕϊ
	CPoint ptCompEdit = point;
	LPtoCompEditP(ptCompEdit);//}EX̍WҏWWɕϊ
	m_pointLButtonDown = ptCompEdit;
	SPoint sptCompEdit=SPoint(ptCompEdit.x,ptCompEdit.y);

	m_movingGrip = -1;

	TRACE("ButtonDown at (%d,%d)\n",ptCompEdit.x,ptCompEdit.y);

	if(m_pCompIndex==NULL)return;

	//IĂIuWFNg݂ĂƂɂ́A
	//{^|CgIIuWFNgOĂꍇ
	//IԂB
	if(      (m_doc.m_listTemp.size()!=0)
	   &&  ! (editNodeActive() && isOnGrip(point)>=0)
	   &&  ! (!editNodeActive() && m_doc.isOnTmpData(sptCompEdit)) ){
		//if(m_doc.releaseTemp()){
		if(releaseTemp()){
			bUpdateView = true;
			//drawToBuff(true);
			//Invalidate(FALSE);
			//p^[c[ł͉ɌpĔzuX^[gȂB
			if(	m_tool == TOOL_LINE || 
				m_tool == TOOL_POLYGON || 
				m_tool == TOOL_CIRCLE || 
				m_tool == TOOL_ARC ||
				m_tool == TOOL_TEXT){
				return;
			}
		}
	}

	if(m_doc.m_listTemp.size() == 0){
		if(m_pCursorPin != NULL){
		//sJ[\݂Ƃ́Ams
			int pinLtrb;
			int pinOffset;
			m_doc.pinPlacePoint(sptCompEdit,pinLtrb,pinOffset);
			m_pCursorPin->setLtrb(pinLtrb);
			m_pCursorPin->setOffset(pinOffset);
			if(m_tool == TOOL_PIN){
				m_pCursorPin->setPinName("NAME");
				m_pCursorPin->setPinNum(0,"NUM");
			}
			if(placePin()){
				Invalidate(FALSE);
			}
			if(m_tool == TOOL_PIN){
				m_pCursorPin->setPinName("");
				m_pCursorPin->setPinNum(0,"");
				m_pCursorPin->setBlock(1);
			}
			return;
		}else{
			if(m_tool == TOOL_SELECT){
				m_startSelect = true;
				return;
			}else{
				if(m_pCompIndex->pattern()!=NULL){ //ip^[Ƃ
					SPtnObj* pPtnObj = NULL;
					if(m_tool == TOOL_TEXT){
						CPtnTextDlg dlg;
						if(dlg.DoModal()==IDOK){
							if(!dlg.m_strText.IsEmpty()){
								pPtnObj = new SPtnObjText;
								((SPtnObjText*)pPtnObj)->m_p0 = sptCompEdit;
								((SPtnObjText*)pPtnObj)->m_align = dlg.m_align;
								((SPtnObjText*)pPtnObj)->setText(dlg.m_strText);
								((SPtnObjText*)pPtnObj)->setFontSize(abs(dlg.m_logfont.lfHeight));
								((SPtnObjText*)pPtnObj)->setFontBold(dlg.m_logfont.lfWeight>=FW_BOLD);
								((SPtnObjText*)pPtnObj)->setFontItalic(dlg.m_logfont.lfItalic!=0);
								((SPtnObjText*)pPtnObj)->setFontName(dlg.m_logfont.lfFaceName);
								Invalidate(FALSE);
							}
							m_placeState = 0;
						}
					}else{
						if(m_placeState==0){
							if(m_tool == TOOL_LINE || 
								m_tool == TOOL_POLYGON || 
								m_tool == TOOL_CIRCLE || 
								m_tool == TOOL_ARC){
								m_arrayTempPoint[0] = sptCompEdit;
								m_arrayTempPoint[1] = sptCompEdit;
								m_placeState = 1;
//								Invalidate(FALSE);
							}
						}else{
							//SPtnObj* pPtnObj = NULL;
							if(m_tool == TOOL_LINE){
								m_arrayTempPoint[1] = sptCompEdit;
								pPtnObj = new SPtnObjLine;
								((SPtnObjLine*)pPtnObj)->m_p0=m_arrayTempPoint[0];
								((SPtnObjLine*)pPtnObj)->m_p1=m_arrayTempPoint[1];
								m_placeState = 0;
//								Invalidate(FALSE);
							}else if(m_tool == TOOL_POLYGON){
								if(m_placeState < VECTPLOYGON_MAXNODE-2){
									m_arrayTempPoint[m_placeState++] = sptCompEdit;
									m_arrayTempPoint[m_placeState] = sptCompEdit;
									Invalidate(FALSE);
								}
							}else if(m_tool == TOOL_CIRCLE){
								m_arrayTempPoint[1] = sptCompEdit;
								pPtnObj = new SPtnObjCircle;
								((SPtnObjCircle*)pPtnObj)->m_p0=m_arrayTempPoint[0];
								((SPtnObjCircle*)pPtnObj)->m_p1=m_arrayTempPoint[1];
								m_placeState = 0;
//								Invalidate(FALSE);
							}else if(m_tool == TOOL_ARC){
								if(m_placeState < 3){
									m_arrayTempPoint[m_placeState++] = sptCompEdit;
									m_arrayTempPoint[m_placeState] = sptCompEdit;
									Invalidate(FALSE);
								}else{
									m_arrayTempPoint[3] = sptCompEdit;
									pPtnObj = new SPtnObjArc;
									((SPtnObjArc*)pPtnObj)->m_ptC=m_arrayTempPoint[0];
									((SPtnObjArc*)pPtnObj)->m_nR=abs(m_arrayTempPoint[0].x()-m_arrayTempPoint[1].x());
									((SPtnObjArc*)pPtnObj)->setBeginPoint(m_arrayTempPoint[2].x(),m_arrayTempPoint[2].y());
									((SPtnObjArc*)pPtnObj)->setEndPoint(m_arrayTempPoint[3].x(),m_arrayTempPoint[3].y());
									m_placeState = 0;
//									Invalidate(FALSE);
								}
							}
							//if(pPtnObj){
							//	m_doc.incrementOpCount();
							//	m_doc.addPtnToTemp(pPtnObj);
							//	m_doc.setupTempArea();
							//	delete pPtnObj;
							//	pPtnObj=NULL;
							//}
						}
					}
					if(pPtnObj){
						m_doc.incrementOpCount();
						m_doc.addPtnToTemp(pPtnObj);
						delete pPtnObj;
						pPtnObj=NULL;
						m_tempAreaRectValid = false;
						//m_doc.setupTempArea();
						Invalidate(FALSE);
					}
				}
			}
		}
	}else if(editNodeActive()){
		m_movingGrip = isOnGrip(point);
	}else if(!editNodeActive() && m_doc.isOnTmpData(sptCompEdit)){
	//m[hҏW[hɂāA{^|CgAꎞf[^̈ʒułƂB
		m_prevOffset = CSize(0,0);		//hbOɂłɈړm肵
		if(m_doc.m_listTemp.size()==1){	//PƑI
			SCompEditElmListIterator ite;
			ite = m_doc.m_listTemp.begin();
			if(ite->m_dataType==SCompEditDoc::DATATYPE_PIN){
				SPin* pPin =(SPin*)ite->m_pData;
				//s̃hbO͂߂Öʒu
				m_pinPosLtrbStart	= pPin->ltrb();
				m_pinPosOffsetStart	= pPin->offset();
				m_dragOpStatus = DRAGOP_PIN;
			}else{
				m_dragOpStatus = DRAGOP_PTN;
			}
		}else{//I
			m_dragOpStatus = DRAGOP_PTN;
		}
	}
}

int CCompEditView::doSelect(SPoint sptEdit,CPoint lpt)
{
	if(m_doc.m_listMain.size()<=0)return 0;
	if(!m_pCompIndex)return 0;
	int selCount = m_doc.doSelect(sptEdit);
	if(selCount>0) return selCount;


	//ȉ̓p^[̑I
	//p^[̓foCXReLXgɎۂɕ`悵Ă݂āA
	//w͈͂`悪؂邩ǂ`FbNĂB
	CDC* pDC = GetDC();
	CBitmap bmp;
	bmp.CreateCompatibleBitmap(pDC,32,32);
	CBitmap* pOldBmp;
	CDC dcMem;						//foCXReLXgIuWFNg̍쐬
	dcMem.CreateCompatibleDC(pDC);	//NCAgGAƌ݊̂郁foCXReLXg
	pOldBmp=dcMem.SelectObject(&bmp);
	dcMem.FillSolidRect(0,0,32,32,RGB(0,0,0));

	dcMem.SetWindowOrg(lpt.x-16,lpt.y-16);
//	dcMem.SetPixel(lpt,RGB(0,0,0));

	COLORREF col = COL_EDITPTN;

	SSize sz = m_pCompIndex->size();
	int cx=sz.w()*10;
	int cy=sz.h()*10;

	SCompEditElm elm;
	SCompEditElmListRevIterator rite;
	rite = m_doc.m_listMain.rbegin();
	while(rite != m_doc.m_listMain.rend()){
		if(rite->m_deleteOpCount<0 && rite->m_dataType==SCompEditDoc::DATATYPE_PTN){
			SPtnObj* pPtn =(SPtnObj*)rite->m_pData;
			drawPtn(&dcMem,pPtn,cx,cy,col,m_magV,m_magW);
			COLORREF colpt=RGB(0,0,0);
			int nx,ny;
			int tx,ty;
			ty = lpt.y-1;
			for(ny=0;ny<3;ny++){
				tx = lpt.x-1;
				for(nx=0;nx<3;nx++){
					colpt |= dcMem.GetPixel(tx,ty);
					tx++;
				}
				ty++;
			}
			if(colpt!=RGB(0,0,0)){
				int opCount = m_doc.opCount();
				rite->m_deleteOpCount = opCount;	//m_nOpCount;
				SPtnObj* pNewPtn = pPtn->duplicate();
				elm.m_dataType = SCompEditDoc::DATATYPE_PTN;
				elm.m_placeOpCount = opCount;	//m_nOpCount;
				elm.m_deleteOpCount = -1;
				elm.m_pOrigin = &(*rite);
				elm.m_pData = pNewPtn;
				m_doc.m_tempDirtyFlag = false;
				m_doc.m_listTemp.push_back(elm);
				selCount = 1;
				break;
			}
		}
		rite++;
	}
	dcMem.SelectObject(pOldBmp);
	ReleaseDC(pDC);
	return selCount;
}

//sҏWObh_CAOĂ΂
bool CCompEditView::selectPin(int ltrb,int offset)
{
	bool bUpdate = false;
	bool retv = false;
	if(m_tool != TOOL_SELECT){
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_SELECT);
		bUpdate = true;
	}

	if(m_doc.m_listTemp.size()!=0){
		releaseTemp();
		bUpdate = true;
	}

	m_startSelect = false;
	m_movingGrip = -1;
	m_dragOpStatus = DRAGOP_NOT;

	if(m_doc.m_listMain.size()>0 && m_pCompIndex!=NULL){
		m_doc.incrementOpCount();
		if(m_doc.doSelect(ltrb,offset)==1){
			m_doc.setupTempArea();
			drawToBuff(true);
			m_pPinPropsDlg->update();
			TRACE("selectPin(int ltrb,int offset) opCount %d\n",m_doc.opCount());

			retv = true;
			bUpdate = true;
		}
	}
	if(bUpdate){
		Invalidate();
	}
	return retv;
}

void CCompEditView::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE("CCompEditView::OnLButtonUp  %d\n",m_captureFlag);
	CWnd::OnLButtonUp(nFlags, point);
	m_captureFlag &= ~LBUTTON_CAPTURE;
	if(m_captureFlag==0){
		TRACE("CCompEditView::OnLButtonUp  Release Caputure\n");
		::ReleaseCapture();	//}EX̉
	}
	bool bUpdateView = false;
	m_drawXcursor = false;
	CClientDC dc(this);	//NCAgGÃfoCXReLXg𓾂
	PrepareDC(&dc);		//foCXReLXgɃXN[l̔f
	dc.DPtoLP(&point);	//}EX̍W_Wɕϊ
	CPoint ptCompEdit = point;
	LPtoCompEditP(ptCompEdit);//}EX̍WҏWWɕϊ
	m_pointLButtonUp = ptCompEdit;
	SPoint sptCompEdit=SPoint(ptCompEdit.x,ptCompEdit.y);

	int movX = m_pointLButtonUp.x - m_pointLButtonDown.x;
	int movY = m_pointLButtonUp.y - m_pointLButtonDown.y;


	//if(m_dragOpStatus == DRAGOP_PIN){
	if(m_doc.m_listTemp.size()==1){	//PƑI
		SCompEditElmListIterator ite;
		ite = m_doc.m_listTemp.begin();
		if(m_dragOpStatus == DRAGOP_PIN){
			SPin* pPin =(SPin*)ite->m_pData;
			if(m_doc.pinConflict(pPin)){
				pPin->setLtrb(m_pinPosLtrbStart);
				pPin->setOffset(m_pinPosOffsetStart);
				m_doc.setupTempArea();
				bUpdateView = true;
			}else{
				m_pPinPropsDlg->update();	//sړꂽAsҏW_CAOXVB
			}
		}				
	}else if(m_tool == TOOL_SELECT && m_startSelect){
		if(!m_dragOpStatus){
			m_doc.incrementOpCount();
			int selCount = 0;
			if(abs(movX)<3 && abs(movY)<3){
				//selCount = m_doc.doSelect(sptCompEdit);
				selCount = doSelect(sptCompEdit,point);
			}else{
				SPoint ptStart(m_pointLButtonDown.x,m_pointLButtonDown.y);
				SRect rcSelArea(ptStart,sptCompEdit);
				rcSelArea.normalize();//Version 0.21
				selCount = m_doc.doSelect(rcSelArea);
			}
			if(selCount){
				m_doc.setupTempArea();
				drawToBuff(true);	
				if(m_doc.isPinSelected()){	//sIĂAsҏW_CAOXVB
					m_pPinPropsDlg->update();
				}

			}else{
				m_doc.decrementOpCount();
			}
		}
		bUpdateView = true;
	}

	m_startSelect = false;
	m_movingGrip = -1;

	m_dragOpStatus = DRAGOP_NOT;
	if(bUpdateView){
		Invalidate(FALSE);
	}
}

void CCompEditView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CWnd::OnLButtonDblClk(nFlags, point);
	bool bUpdateView = false;
	CClientDC dc(this);	//NCAgGÃfoCXReLXg𓾂
	PrepareDC(&dc);		//foCXReLXgɃXN[l̔f
	dc.DPtoLP(&point);	//}EX̍W_Wɕϊ
	CPoint ptCompEdit = point;
	LPtoCompEditP(ptCompEdit);//}EX̍WҏWWɕϊ
	SPoint sptCompEdit=SPoint(ptCompEdit.x,ptCompEdit.y);

	if(canProperty()){
		if(editProperty()){
			bUpdateView = true;
		}
	}

	if(m_tool == TOOL_POLYGON && m_placeState >= 2){
		int count = m_placeState;
		if(count>VECTPLOYGON_MAXNODE) count = VECTPLOYGON_MAXNODE;
		SPtnObj* pPtnObj = new SPtnObjPolygon;
		((SPtnObjPolygon*)pPtnObj)->m_nCount = count;
		((SPtnObjPolygon*)pPtnObj)->m_pPt = new SPoint[count];
		int n;
		for(n=0;n<count;n++){
			((SPtnObjPolygon*)pPtnObj)->m_pPt[n] = m_arrayTempPoint[n];
		}
		if(pPtnObj){
			m_doc.incrementOpCount();
			m_doc.addPtnToTemp(pPtnObj);
			m_doc.setupTempArea();
			delete pPtnObj;
		}
		m_placeState =0;
		bUpdateView = true;
	}

	if(bUpdateView){
		Invalidate(FALSE);
	}
}

void CCompEditView::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CWnd::OnMouseMove(nFlags, point);


	bool bUpdateView = false;
//	m_pointCurrentPosDevice = point;
	m_drawXcursor = false;
	CClientDC dc(this);	//NCAgGÃfoCXReLXg𓾂
	PrepareDC(&dc);		//foCXReLXgɃXN[l̔f
	CPoint ptLogical = point;
	dc.DPtoLP(&ptLogical);	//}EX̍W_Wɕϊ
	CPoint ptCompEdit = ptLogical;
	LPtoCompEditP(ptCompEdit);//}EX̍WҏWWɕϊ
	SPoint sptCompEdit=SPoint(ptCompEdit.x,ptCompEdit.y);
	m_pointCurrentPos = ptCompEdit;


	if(m_enableContextMenu){
		int xd = abs(m_pointRButtonDownDevice.x - point.x);
		int yd = abs(m_pointRButtonDownDevice.y - point.y);
		if(xd>5 || yd>5){
			m_enableContextMenu = false;	//{^xyꂩ5sNZȏړReLXgj[֎~B
			//m_enableRButtonDrag = true;
		}
	}else if(nFlags & MK_RBUTTON){
		if(m_captureFlag == RBUTTON_CAPTURE){
			scrollTo(point,m_pointRButtonDown);
			return;
		}
	}





	bool enableDivideLine = editNodeActive();
	int pinLtrb;
	int pinOffset;
	//}EXJ[\̌`̌
	if(editNodeActive()){
		//int nOnGripValue = isOnGrip(point);
		int nOnGripValue = isOnGrip(ptLogical);	//2009/07/20 m[hɋߕtJ[\move}[Nt悤ɏC
		TRACE("nOnGripValue %d\n",nOnGripValue);
		if(nOnGripValue >=0 || m_movingGrip>=0){
			::SetCursor(AfxGetApp()->LoadCursor(IDC_CURSOR_MOVE));
			enableDivideLine = false;
		}else{
			::SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
		}
	}else if(m_doc.isOnTmpData(sptCompEdit)){	//ꎞf[^̏ォړ
		::SetCursor(AfxGetApp()->LoadCursor(IDC_CURSOR_MOVE));
	}else{
		::SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
	}

	if(m_movingGrip >=0){
		enableDivideLine = false;
		SCompEditElmListIterator ite;
		ite = m_doc.m_listTemp.begin();
		if(ite->m_dataType!=SCompEditDoc::DATATYPE_PTN){
			m_movingGrip = -1;
		}else{
			SPtnObj* pObj =(SPtnObj*)ite->m_pData;
			pObj->setGripPos(m_movingGrip,sptCompEdit.x(),sptCompEdit.y());
			bUpdateView = true;
			m_doc.m_tempDirtyFlag = true;
		}
	}
	



	if(m_dragOpStatus == DRAGOP_PIN){	//s̈ړ
		enableDivideLine = false;
		//	if(m_doc.m_listTemp.size()==1){	//PƑI
		SCompEditElmListIterator ite;
		ite = m_doc.m_listTemp.begin();
		if(m_doc.m_listTemp.size()==1){	//PƑI
//		if(m_dragOpStatus == DRAGOP_PIN){
			SPin* pPin =(SPin*)ite->m_pData;
			m_doc.pinPlacePoint(sptCompEdit,pinLtrb,pinOffset);
			if(pinLtrb != pPin->ltrb()){
				bUpdateView = true;
				m_doc.m_tempDirtyFlag = true;
				pPin->setLtrb(pinLtrb);
			}
			if(pinOffset != pPin->offset()){
				bUpdateView = true;
				m_doc.m_tempDirtyFlag = true;
				pPin->setOffset(pinOffset);
			}
		}
	}else if(m_dragOpStatus == DRAGOP_PTN){	//p^[̈ړ
		enableDivideLine = false;
		CSize totalMoveSize = m_pointCurrentPos - m_pointLButtonDown;
		CSize moveSize = totalMoveSize - m_prevOffset;
		m_prevOffset = totalMoveSize;
		m_doc.move(moveSize.cx,moveSize.cy);
		bUpdateView = true;

	}else if(m_pCursorPin != NULL){		//if(m_tool == TOOL_PIN){  //s̔zu
		enableDivideLine = false;

		//		if(m_doc.m_listTemp.size()==0){
			m_doc.pinPlacePoint(sptCompEdit,pinLtrb,pinOffset);
			if(pinLtrb != m_pCursorPin->ltrb()){
				bUpdateView = true;
				m_pCursorPin->setLtrb(pinLtrb);
			}
			if(pinOffset != m_pCursorPin->offset()){
				bUpdateView = true;
				m_pCursorPin->setOffset(pinOffset);
			}
//		}
	}

	//J[\I|S𕪊łʒuɂ邩ǂ̃`FbN
	//̏ԂωƂ́Aĕ`sB
	bool old_bIsCursorOnActivePolygon = m_bIsCursorOnActivePolygon;
	if(enableDivideLine){
		TestIsCursorOnPolygon(ptCompEdit,1);
		//TRACE("OnMouseMove() ptCompEdit (x,y):(%d,%d)\n",ptCompEdit.x,ptCompEdit.y);
		//TRACE("OnMouseMove() m_bIsCursorOnActivePolygon:%d  (x,y):(%d,%d)\n",(m_bIsCursorOnActivePolygon ? 1 : 0),m_ptDividePolygonAt.x,m_ptDividePolygonAt.y);
	}else{
		m_bIsCursorOnActivePolygon = false;
	}
	if(m_bIsCursorOnActivePolygon || old_bIsCursorOnActivePolygon != m_bIsCursorOnActivePolygon){
		bUpdateView = true;
	}




	if(m_tool == TOOL_SELECT && m_startSelect){
		bUpdateView = true;
	}

	if(m_tool == TOOL_LINE || m_tool == TOOL_POLYGON || m_tool == TOOL_CIRCLE || m_tool == TOOL_ARC){
		if(m_placeState>0){
			m_arrayTempPoint[m_placeState] = sptCompEdit;
			bUpdateView = true;
		}else{
			if(m_doc.m_listTemp.size()==0){
				m_drawXcursor = true;
				bUpdateView = true;
			}
		}
	}


	if(bUpdateView){
		TRACE("Upadate View\n");
		m_doc.setupTempArea();
		Invalidate(FALSE);
	}
}

bool CCompEditView::onKeyEscape()
{
	bool bUpdateView = false;

	//if(m_doc.releaseTemp()){
	if(releaseTemp()){
		bUpdateView = true;
		//drawToBuff(true);
	}
	if(m_tool == TOOL_SELECT){
		if(m_pCursorPin != NULL){
			delete m_pCursorPin;
			m_pCursorPin = NULL;
			bUpdateView = true;
		}
	}
	if(m_placeState>0){
		m_arrayTempPoint[m_placeState-1]=m_arrayTempPoint[m_placeState];
		m_placeState --;
		bUpdateView = true;
	}

	m_movingGrip = -1;

	if(bUpdateView){
		Invalidate(FALSE);
	}
	return bUpdateView;
}


void CCompEditView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	switch(nChar){
	case VK_ESCAPE:
		if(!onKeyEscape()){
			AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_SELECT);
		}
		break;
	case 'S':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_SELECT);
		break;
	case 'P':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_PIN);
		break;
	case 'L':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_LINE);
		break;
	case 'C':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_CIRCLE);
		break;
	case 'G':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_POLYGON);
		break;
	case 'A':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_ARC);
		break;
	case 'T':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_TOOL_TEXT);
		break;
	case 'N':
		AfxGetMainWnd()->SendMessage(WM_COMMAND,ID_EDIT_NODE_MODE);
		//OnEditNodeMode();
		break;
	}

	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

int CCompEditView::isOnGrip(const CPoint& logicalPoint)
{
	int x = logicalPoint.x;
	int y = logicalPoint.y;

	if(m_doc.m_listTemp.size()!=1) return -1;
	SCompEditElmListIterator ite;
	ite = m_doc.m_listTemp.begin();
	if(ite->m_dataType!=SCompEditDoc::DATATYPE_PTN) return -1;
	SPtnObj* pObj =(SPtnObj*)ite->m_pData;
	int nodes = pObj->gripCount();
	int i;
	for(i=0;i<nodes;i++){
		SPoint sptGrip=pObj->gripPos(i);
		CPoint ptGrip(sptGrip.x(),sptGrip.y());
		CompEditPtoLP(ptGrip);
		if(abs(x-ptGrip.x)<=3 && abs(y-ptGrip.y)<=3) return i;
	}
	return -1;
}

//J[\Iꂽ|S̐ォǂ
bool CCompEditView::TestIsCursorOnPolygon(const CPoint& editPoint, int limit)//, SPtnObjPolygon** ppPolygon, int& lineNum, CPoint& ptOnPolygon)
{
	//ʂi[郁o[ϐ̃NA
	m_bIsCursorOnActivePolygon = false;				//\ȈʒuɃJ[\邩
	m_pPolygonToDivide = NULL;						//\ł邱Ƃo|S̃|C^
	m_nLineNumOfPolygonToDivide = -1;				//\ȃ|S̉Ԗڂ̃CL^
	//CPoint m_ptDividePolygonAt;					//ꏊL^

	int x = editPoint.x;
	int y = editPoint.y;

	SPoint sptDividePolygonAt;

	SPtnObjPolygon* pPolygon = NULL;
	SPoint sptEdit = CPoint2SPoint(editPoint);

	if(m_doc.m_listTemp.size()<1) return false;
	SCompEditElmListIterator ite;
	ite = m_doc.m_listTemp.begin();
	while(ite != m_doc.m_listTemp.end()){
		if(ite->m_dataType!=SCompEditDoc::DATATYPE_PTN){
			ite++;
			continue;
		}
		SPtnObj* pObj =(SPtnObj*)ite->m_pData;
		if(pObj->id()!=VECTPTN_PG){
			ite++;
			continue;
		}

		pPolygon = (SPtnObjPolygon*) pObj;
		
		int n;
		SPoint ptBegin;
		SPoint ptEnd;

		for(n=0; n< pPolygon->m_nCount; n++){
			ptBegin = pPolygon->m_pPt[n];
			int m=n+1;
			if(m==pPolygon->m_nCount) m= 0;
			ptEnd = pPolygon->m_pPt[m];

			//TRACE("TestIsCursorOnPolygon() %d,%d-%d,%d\n",ptBegin.x(),ptBegin.y(),ptEnd.x(),ptEnd.y());

			if(PointIsCloseToLineSide(sptEdit,ptBegin,ptEnd,limit,sptDividePolygonAt)){
				//J[\I|Sɋ߂Ƃɂ΁Alo[ϐɏ߂
				m_bIsCursorOnActivePolygon = true;
				m_pPolygonToDivide = pPolygon;
				m_nLineNumOfPolygonToDivide = n;
				m_ptDividePolygonAt = SPoint2CPoint(sptDividePolygonAt); 
				return true;
			}
		}
		ite++;
	}
	return false;
}

////|S̐ォǂ̃`FbN
//bool CCompEditView::TestIsCursorOnPolygon(const CPoint& logicalPoint, int limit, SPtnObjPolygon** ppPolygon, int& lineNum, CPoint& ptOnPolygon)
//{
//	int x = logicalPoint.x;
//	int y = logicalPoint.y;
//	*ppPolygon = NULL;
//	lineNum = -1;
//	SPoint sptPnPolygon;
//
//	SPoint ptLogical = CPoint2SPoint(logicalPoint);
//
//	if(m_doc.m_listTemp.size()<1) return false;
//	SCompEditElmListIterator ite;
//	ite = m_doc.m_listTemp.begin();
//	while(ite != m_doc.m_listTemp.end()){
//		if(ite->m_dataType!=SCompEditDoc::DATATYPE_PTN){
//			ite++;
//			continue;
//		}
//		SPtnObj* pObj =(SPtnObj*)ite->m_pData;
//		if(pObj->id()!=VECTPTN_PG){
//			ite++;
//			continue;
//		}
//
//		*ppPolygon = (SPtnObjPolygon*) pObj;
//		
//		int n;
//		SPoint ptBegin;
//		SPoint ptEnd;
//		//SPoint ptCross;
//
//
//		for(n=0; n<(*ppPolygon)->m_nCount; n++){
//			ptBegin = (*ppPolygon)->m_pPt[n];
//			int m=n+1;
//			if(m==(*ppPolygon)->m_nCount) m= 0;
//			ptEnd = (*ppPolygon)->m_pPt[m];
//
//			if(PointIsCloseToLineSide(ptLogical,ptBegin,ptEnd,limit,sptPnPolygon)){
//				ptOnPolygon = SPoint2CPoint(sptPnPolygon);
//				lineNum = n; 
//				return true;
//			}
//
//		}
//
//		ite++;
//	}
//
//	return false;
//}




bool CCompEditView::canCreateBitPtn()
{
	if(m_pCompIndex==NULL) return false;
	if(m_pCompIndex->m_pCompInfo->m_pPtn){
		SPtn *pPtn = m_pCompIndex->m_pCompInfo->m_pPtn;
		if(pPtn->m_pBuff) return true;
	}
	return false;
}

bool CCompEditView::doCreateBitPtn()
{
	//return false;

	if(!canCreateBitPtn()) return false;
	if(m_doc.m_listMain.size()<=0)return false;

	//m_doc.releaseTemp();
	releaseTemp();

	SPtn *pPtn = m_pCompIndex->m_pCompInfo->m_pPtn;
	int width = pPtn->m_size.w();
	int height = pPtn->m_size.h();

	int nBmpXbyte;	//foCXˑ̃rbg}bv̐oCg
	int nBmpSize;	//foCXˑ̃rbg}bṽTCY
	int nDibXbyte;	//foCXƗ̃rbg}bv̐oCg
	int nDibSize;	//foCXˑ̃rbg}bṽTCY

	nBmpXbyte=((width+15)/16)*2;
	nBmpSize=nBmpXbyte*height;
	if(pPtn->m_nBuffsize!=nBmpSize) return false;
	nDibXbyte=((width+31)/32)*4;
	nDibSize=nDibXbyte*height;



	CDC* pDC = GetDC();
	CBitmap bmp;
	bmp.CreateBitmap(width,height,1,1,NULL);

	CBitmap* pOldBmp;
	CDC dcMem;						//foCXReLXgIuWFNg̍쐬
	dcMem.CreateCompatibleDC(pDC);	//NCAgGAƌ݊̂郁foCXReLXg
	pOldBmp=dcMem.SelectObject(&bmp);

	dcMem.SetWindowOrg(0,0);
	//ŏ
	COLORREF colBk=dcMem.GetBkColor();
	dcMem.FillSolidRect(0,0,width,height,RGB(255,255,255));
	dcMem.SetBkColor(colBk);
	dcMem.SetWindowOrg(0,0);

	COLORREF col = RGB(0,0,0);

	SSize sz = m_pCompIndex->size();
	int cx=sz.w()*10;
	int cy=sz.h()*10;

	SCompEditElm elm;
	SCompEditElmListIterator ite;
	ite = m_doc.m_listMain.begin();
	while(ite != m_doc.m_listMain.end()){
		if(ite->m_deleteOpCount<0 && ite->m_dataType==SCompEditDoc::DATATYPE_PTN){
			SPtnObj* pPtn =(SPtnObj*)ite->m_pData;
			drawPtn(&dcMem,pPtn,cx,cy,col,1,1);
		}
		ite++;
	}


	BYTE* bitbuff=new BYTE[nDibSize];

	/////////////////////////////////////
	//BITMAPINFO
	int headersize = sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*2;
	BYTE* pbihBuff = new BYTE[headersize];
	BITMAPINFO* pbih =(BITMAPINFO*) pbihBuff;
	pbih->bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	pbih->bmiHeader.biWidth =width;
	pbih->bmiHeader.biHeight=height;
	pbih->bmiHeader.biPlanes=1;
	pbih->bmiHeader.biBitCount=1;
	pbih->bmiHeader.biCompression=0;
	pbih->bmiHeader.biSizeImage=nDibSize;
	pbih->bmiHeader.biXPelsPerMeter=5906;	//150dpi
	pbih->bmiHeader.biYPelsPerMeter=5906;	//150dpi
	pbih->bmiHeader.biClrUsed=0;
	pbih->bmiHeader.biClrImportant=0;

	//rbg̎擾
	int nGetLine = ::GetDIBits(dcMem.m_hDC,(HBITMAP)bmp,0,height,bitbuff,pbih,DIB_RGB_COLORS);

	dcMem.SelectObject(pOldBmp);
	ReleaseDC(pDC);

	unsigned char* pDst = pPtn->m_pBuff;
	int copyx,copyy;
	//BYTE* pSrc;
	for(copyy = height-1; copyy>=0; copyy--){
		BYTE* pSrc = bitbuff+copyy*nDibXbyte;
		for(copyx = 0; copyx < nBmpXbyte; copyx++){
			*pDst++ = (*pSrc++)^0xFF;
		}
	}

	delete[]pbihBuff;
	delete[]bitbuff;
	drawToBuff(true);
	Invalidate(FALSE);
	m_doc.m_dirtyFlag = true;
	return true;
}

BOOL CCompEditView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	//return CWnd::OnMouseWheel(nFlags, zDelta, pt);
	if((MK_CONTROL & nFlags) || m_captureFlag==RBUTTON_CAPTURE){
		if(m_enableContextMenu){
			m_enableContextMenu = false;
			//m_enableRButtonDrag = true;
		}

		m_nWHEEL_DELTA_z+=zDelta;
		if(m_nWHEEL_DELTA_z >= WHEEL_DELTA){
			while(m_nWHEEL_DELTA_z >= WHEEL_DELTA){
				m_nWHEEL_DELTA_z-=WHEEL_DELTA;
				SendMessage(WM_COMMAND,ID_VIEW_ZOOMIN);
			}
			return TRUE;
		}else if(m_nWHEEL_DELTA_z <= -WHEEL_DELTA){
			while(m_nWHEEL_DELTA_z <= -WHEEL_DELTA){
				m_nWHEEL_DELTA_z+=WHEEL_DELTA;
				SendMessage(WM_COMMAND,ID_VIEW_ZOOMOUT);
			}
			return TRUE;
		}else{
			return FALSE;
		}
	}else{
		m_nWHEEL_DELTA_s+=zDelta;
		if(m_nWHEEL_DELTA_s >= WHEEL_DELTA){
			while(m_nWHEEL_DELTA_s >= WHEEL_DELTA){
				m_nWHEEL_DELTA_s-=WHEEL_DELTA;
				SendMessage(WM_VSCROLL,SB_LINEUP);
			}
			return TRUE;
		}else if(m_nWHEEL_DELTA_s <= -WHEEL_DELTA){
			while(m_nWHEEL_DELTA_s <= -WHEEL_DELTA){
				m_nWHEEL_DELTA_s+=WHEEL_DELTA;
				SendMessage(WM_VSCROLL,SB_LINEDOWN);
			}
			return TRUE;
		}else{
			return FALSE;
		}
	}
}

void CCompEditView::OnContextMenu(CWnd* /*pWnd*/, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ܂B
	if(!m_enableContextMenu)return;
	CMenu menu;

	menu.LoadMenu(IDR_COMPEDITCONTEXT);
	CMenu* contextMenu = menu.GetSubMenu(0);

	//if(!m_bIsCursorOnActivePolygon){
	//	contextMenu->RemoveMenu(ID_ADD_NODE,MF_BYCOMMAND);
	//}

	contextMenu->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON,
		                               point.x,point.y,AfxGetMainWnd());
}

void CCompEditView::OnRButtonDown(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CWnd::OnRButtonDown(nFlags, point);
	SetFocus();
	m_captureFlag |= RBUTTON_CAPTURE;
	SetCapture();		//}EX̃Lv`[
	m_enableContextMenu = true;
	m_pointRButtonDownDevice = point;

	CClientDC dc(this);	//NCAgGÃfoCXReLXg𓾂
	PrepareDC(&dc);		//foCXReLXgɃXN[l̔f
	dc.DPtoLP(&point);	//}EX̍W_Wɕϊ
	CPoint ptCompEdit = point;
	LPtoCompEditP(ptCompEdit);//}EX̍WҏWWɕϊ
	m_pointRButtonDown = ptCompEdit;

}

void CCompEditView::OnRButtonUp(UINT nFlags, CPoint point)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE("CCompEditView::OnRButtonUp  %d\n",m_captureFlag);
	m_captureFlag &= ~RBUTTON_CAPTURE;
	if(m_captureFlag==0){
		TRACE("CCompEditView::OnRButtonUp  Release Caputure\n");
		::ReleaseCapture();	//}EX̉
	}
	//m_enableRButtonDrag = false;
	CWnd::OnRButtonUp(nFlags, point);
}

int CCompEditView::activeBlock()
{
	if(!m_displayPinProps || m_pPinPropsDlg==NULL) return 0;
	return m_pPinPropsDlg->activeBlock();
}


void CCompEditView::OnViewPinprops()
{
	// TODO : ɃR}h nh R[hǉ܂B
	if(!m_displayPinProps){
		if(m_pPinPropsDlg->GetSafeHwnd()==0){
			m_pPinPropsDlg->Create();
		}
		m_pPinPropsDlg->ShowWindow(SW_SHOW);
		m_displayPinProps = true;
	}else{
		//m_pPinPropsDlg->DestroyWindow();
		m_pPinPropsDlg->ShowWindow(SW_HIDE);
		m_pPinPropsDlg->initBlock();
		m_displayPinProps = false;
		Invalidate();
	}

}

void CCompEditView::OnUpdatePinprops(CCmdUI *pCmdUI)
{
	// TODO : ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->SetCheck(m_displayPinProps);
}

int CCompEditView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO :  ɓȍ쐬R[hǉĂB
	if(m_pPinPropsDlg->GetSafeHwnd()==0){
		m_pPinPropsDlg->Create();
	}

	m_hDivideMarkIcon = AfxGetApp()->LoadIcon(IDI_ICON_DIVIDEMARK);

	return 0;
}

void CCompEditView::OnAddNode()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if(!m_bIsCursorOnActivePolygon) return;	//\ȈʒuɃJ[\邩
	if(m_pPolygonToDivide == NULL) return;	//\ł邱Ƃo|S̃|C^

	TRACE("%d\n",m_pPolygonToDivide->m_nCount);

	m_pPolygonToDivide->addGrip(m_nLineNumOfPolygonToDivide,m_ptDividePolygonAt.x,m_ptDividePolygonAt.y);

	m_bIsCursorOnActivePolygon = false;
	m_doc.m_tempDirtyFlag = true;

	Invalidate();
}

void CCompEditView::OnUpdateAddNode(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_bIsCursorOnActivePolygon);
}
