/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#pragma once
#include "sptnobj.h"

class SPtnObjArc :
	public SPtnObj
{
public:
	//ʂ̃C^[tF[X
	SPtnObjArc(void);
	~SPtnObjArc(void);
	int id(){return VECTPTN_AR;}
//	SPtnObjArc(const SPtnObjArc&);					//Rs[RXgN^
//	SPtnObjArc& operator=(const SPtnObjArc&);		//Zq
	SPtnObj* duplicate();							//
	bool qValid();									//Lȃf[^ǂԂB

	//Obv̐Ԃ
	int gripCount(){return 7;}
	//Obv̈ʒuԂ
	SPoint gripPos(int grip);
	//Obv̈ʒu𓮂
	void setGripPos(int grip,int x,int y);

	void move(int offsetx,int offsety);				//ʒu𓮂
	void mirrorH(int x); 							//XWw肵čE]s
	void mirrorH();									//E]s
	void rotate(const SPoint& p);					//XYSWw肵āA]s
	void rotate();									//]s
	bool testIntersect(const SRect& );				//͈͂w肵đI`FbNs
	bool testIntersect(const SPoint& );				//_w肵đI`FbNs
	SRect area();									//L͈͂Ԃ
	bool readCe3(SReadCE3& rce3);
	bool writeCe3(SWriteCE3& wce3,SPoint* pOrigin=NULL);
	
	void setBeginPoint(int x,int y);			//JnpWŐݒBɒS߂Ă
	void setEndPoint(int x,int y);				//IpWŐݒBɒS߂Ă
	SPoint AngleToPoint(int angle);				//px(deg*16)~̓_߂


public:
	SPoint m_ptC;		//SW
	int    m_nR;		//a
	int	   m_nBegin;	//Jnp
	int	   m_nEnd;		//Ip
protected:
	void normalizeAngle();
public:
	//static bool  Conv3PointArcToAR(SPoint pE0,SPoint pE1,SPoint p,SPoint& center,int& r,int& begin, int& end);
	static double  PointRad(double cx,double cy,double r,double x0,double y0);
};
