/*!
  MemList は空にならない。最低1個は要素が入っていて
  1個目は特別扱いする。getFirst すると first->next を返す
 */

#include "MemList.h"

/*!
  最初の1個は特別扱いなので、それの後に追加していく
 */
void
MemList::addFirst(MemorySegment* e)
{
    e->prev = first;
    e->next = first->next;
    first->next->prev = e;
    first->next = e;
}

void
MemList::addLast(MemorySegment* e)
{
    e->next = first;
    e->prev = last;
    last->next = e;
    last = e;
}

MemorySegment*
MemList::getFirst()
{
    return first->next;
}

MemorySegment*
MemList::getLast()
{
    return last;
}

int
MemList::remove(MemorySegment* e)
{
    e->prev->next = e->next;
    e->next->prev = e->prev;

    if (first->next == e) {
	first->next = e->next;
    }
    if (last == e) {
	last = e->prev;
    }

    e->prev = NULL;
    e->next = NULL;

    return 1;
}

/*!
  リストの先頭を取得および削除する。リストが空の場合は NULL を返す。
 */

MemorySegment*
MemList::poll()
{
    MemorySegment* e = first->next;
    if (e == this) {
	return NULL;
    }
    remove(e);
    return e;
}

void
MemList::moveToFirst(MemorySegment* e)
{
    remove(e);
    addFirst(e);
}

/*!
  リスト内の指定された位置にある要素を返す。
  要素数を超えた位置を指定した場合 NULL を返す。
 */

MemorySegment*
MemList::get(int index)
{
    MemorySegment* e = first->next;
    for (int i = 0; i < index; i++) {
	if (e == this) return NULL;
	e = e->next;
    }
    return e;
}
