#ifndef MEMLIST
#define MEMLIST

#include <stdlib.h>
#include "MemorySegment.h"

class MemList : public MemorySegment {
public:
    MemorySegment* pool;
    MemorySegment* first;
    MemorySegment* last;

    // TaskManager 側で create する
    //MemList* createMemList(uint32 size, uint32 count);

    MemList(MemorySegment* ms) {
        first = last = this;
        next = prev = this;
        pool = ms;
    }

    ~MemList() {
        free(pool);
    }

    void addFirst(MemorySegment* e);
    void addLast(MemorySegment* e);
    MemorySegment* getFirst();
    MemorySegment* getLast();
    int remove(MemorySegment* e);
    MemorySegment* poll();
    void moveToFirst(MemorySegment* e); // or use();
    MemorySegment* get(int index);
};

#endif
