#include "HTask.h"
#include "ListData.h"
#include "TaskManagerImpl.h"
#include "strings.h"


/*!
  manager->set_task_depend(task1, task2); // task2 は task1 の終了を待つ
 
  ってやるより
 
  task2->set_depend(task1);
 
  ってやったほうがわかりやすいよねー的な話し合いで
  下のようなAPIを作りました
*/

void
HTask::spawn(void)
{
  mimpl->spawn_task(this);
}

/*!
  @brief この Task が待ち合わせする Task を指定する
  @param[in] master この Task が終了待ち合わせをする相手の Task
  
  繰り返し使用する事で複数の Task を待ち合わせする事ができる。

  wait_for している Task の入力バッファにこの Task から書き込みできる機能があると良い
 */
void
HTask::wait_for(HTaskPtr master)
{
    mimpl->set_task_depend(master, this);
}

/**
 * タスクが実行する CPU を選択する
 *
 * 現在は CPU_PPE, CPU_SPE, SPE_ANY, SPE_0, SPE_1, ..., SPE_5
 * types.h に書いてます。
 * 
 * mimpl によって使えるCPUが異なるので、mimpl に任せる必要がある
 */
void
HTask::set_cpu(CPU_TYPE type)
{
    mimpl->set_task_cpu(this, type);
}

/*!
  @brief このTaskが終了した時に実行する関数
  @param arg1, arg2 の二つの引数を持つ (Task に合わせてある)
 */
void
HTask::set_post(PostFunction func,void *arg1, void *arg2)
{
    this->post_func = func;
    this->post_arg1 = arg1;
    this->post_arg2 = arg2;
}


/*!
  @brief まとまって実行されるTask である Task Array の作成
  @param id           Task ID
  @param num_task     実行する Task の数
  @param num_param    一つのTaskがset_paramする数
  @param num_inData   一つのTaskが読み込む Data の数、set_inData の数
  @param num_outData  一つのTaskが書き出す Data の数、set_outData の数
  @return  Task Array へのポインタ
 */
Task *
HTask::create_task_array(int id, int num_task, int num_param, int num_inData, int num_outData)
{
    r_size = Task::calc_size(num_param, num_inData, num_outData)*num_task;
    rbuf = (memaddr) mimpl->allocate(r_size);
    //printf("r_size %d\n",r_size);
    bzero(rbuf,r_size);
    Task *task = (Task*)rbuf;
    task->init(id, num_param,num_inData,num_outData);
// task->print();
    return task;  // first task
}

/*!
  @brief Task Array の次のTask
  @param t            今のTaskのポインタ
                      0 の場合は最初のTask
  @return  次のTaskへのポインタ
 */
Task *
HTask::next_task_array(int id, Task *t)
{
    Task *first = (Task*)rbuf;
    if (t==0) {
// first->print();
	return first;
    }

    Task *next = t->next();
    next->init(id, first->param_count, first->inData_count, first->outData_count);
    if ((memaddr)next - (memaddr)rbuf > r_size)
	mimpl->get_scheduler()->printf("too many task array used.\n");
    return next;
}

/*!
  @brief Task Array の中のすべてのTaskが書き込まれたかどうかをチェックする
         TaskArray 自体の spawn() は別に必要
  @param last            今のTaskのポインタ (最後である必要がある)
 */
void
HTask::spawn_task_array(Task * last)
{
    int size = (memaddr)last - rbuf;
    if (size!= r_size) {
	mimpl->get_scheduler()->printf("spawn task array size differ size 0x%x r_size 0x%x\n",
	    size, r_size);
    }
}




/* end */
