#ifndef INCLUDED_HTASK_INFO
#define INCLUDED_HTASK_INFO

#include "Task.h"
#include "HTask.h"

class HTaskInfo : public HTask {

public:
    /* constructor */
    HTaskInfo();

    BASE_NEW_DELETE(HTaskInfo);

    /* functions */
    HTaskPtr create(int cmd);
    HTaskPtr create(int cmd, memaddr rbuf, int rs, memaddr wbuf, int ws);

    void free_(HTaskPtr queue);

    void addFirst(HTask* e);
    void addLast(HTask* e);
    HTask* getFirst();
    HTask* getLast();
    int remove(HTask* e);
    HTask* poll();
    void moveToFirst(HTask* e); // or use();
    HTask* get(int index);
    HTask* find(HTask *task);
    int empty();
    void freePool() ;

    // Iterator
    HTask* getNext(HTask* q) ;
    int length();

private:
    /* variables */

    static HTaskInfo taskQueuePool;
    HTask* first;
    HTask* last;

    /* functions */
    int extend_pool(int num);
    void destroy();  
};

#endif
