#ifndef INCLUDED_SIPMLE_TASK
#define INCLUDED_SIPMLE_TASK

#include "base.h"
#include "types.h"

#define MAX_PARAMS 8

class SimpleTask {
public: // variables

    BASE_NEW_DELETE(SimpleTask);
    int command;         // 4 byte
    memaddr self;         // 4 byte (or 8byte on 64bit mode)

    memaddr rbuf;
    memaddr wbuf;
    int  r_size;
    int  w_size;
    memaddr from;
    memaddr param;       //  sizeof(SimpleTask)==32


public: // functions
    SimpleTask() {};

    SimpleTask(int r, memaddr read, int w, memaddr write) {
	r_size = r; rbuf = read;
	w_size = w; wbuf = write;
    };

    void set_input(memaddr i,int size) { r_size = size; rbuf= i; }
    void set_output(memaddr o,int size) { w_size = size; wbuf= o; } 
    void set_param(memaddr data) { param = data; }
    memaddr get_param() { return param; }

} __attribute__ ((aligned (DEFAULT_ALIGNMENT)));

typedef SimpleTask *SimpleTaskPtr;

#endif

