#ifndef INCLUDED_TASK_QUEUE_INFO
#define INCLUDED_TASK_QUEUE_INFO

#include "TaskQueue.h"

class HTask;

class TaskQueueInfo : public TaskQueue {


public:
    /* constructor */
    TaskQueueInfo();

    BASE_NEW_DELETE(TaskQueueInfo);

    /* functions */
    TaskQueuePtr create(HTask *task);
    void free_(TaskQueuePtr queue);

    void addFirst(TaskQueue* e);
    void addLast(TaskQueue* e);
    TaskQueue* getFirst();
    TaskQueue* getLast();
    int remove(TaskQueue* e);
    TaskQueue* poll();
    void moveToFirst(TaskQueue* e); // or use();
    TaskQueue* get(int index);
    TaskQueue* find(HTask *task);
    int empty();
    void freePool() ;

    // Iterator
    TaskQueue* getNext(TaskQueue* q) ;
    int hasNext(TaskQueue* q);

private:
    /* variables */

    static TaskQueueInfo taskQueuePool;
    TaskQueue* first;
    TaskQueue* last;

    /* functions */
    int extend_pool(int num);
    void destroy();  
};

#endif
