#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include "TaskManager.h"

/*!
  User が書いた TMmain() (*名前は固定) を実行する
 */

/* User main function */
extern int TMmain(TaskManager* manager, int argc, char *argv[]);

static int profile = 0;

/* Default TMend function */
static void
defaultTMend(TaskManager *manager) {
}

//TaskManager *manager;

/*!
  const char *usr_help_str を User 側で指定する必要がある
  -help で出力される文字列
 */
const char *help_str = "\n\
* Cerium program option *\n\
  -help Print this message \n\
  -cpu   Number of CPU (default 1) \n";

extern const char *usr_help_str;

int
main(int argc, char *argv[])
{
    int machineNum = 1;
    int speIdle = 0;
    int poll_pattern = 0;

    for (int i = 1; argv[i]; ++i) {
        if (strcmp(argv[i], "-cpu") == 0) {
            machineNum = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-p") == 0) {
	    profile = 1;
        } else if (strcmp(argv[i], "-speidle") == 0) {
	    speIdle = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-poll") == 0) {
	    poll_pattern = 1;
	}

    }

    TaskManager *manager = new TaskManager(machineNum);
    manager->init(speIdle);

    manager->set_TMend(defaultTMend);

    for (int i = 1; argv[i]; ++i) {
        if (strcmp(argv[i], "-help") == 0) {
	  if (usr_help_str) {
	    manager->get_scheduler()->printf("%s", usr_help_str);
	  }
	  manager->get_scheduler()->printf("%s", help_str);	    
	  return EXIT_SUCCESS;
        }
    }

    if (profile)
	manager->start_profile();
    if (TMmain(manager, argc, argv) < 0) {
	goto FINISH;
    }

    manager->run();

    (manager->tm_end)(manager);
    if (profile)
	manager->show_profile();
    manager->run(); // tm_end/show_profile may create a Task..

FINISH:
    delete manager;

    return EXIT_SUCCESS;
}

/* end */
