#include <stdio.h>
#include <stdlib.h>
#include "TaskListInfo.h"

TaskListInfo::TaskListInfo(void)
    :taskListPool(NULL), freeTaskList(NULL) {}

TaskListInfo::~TaskListInfo(void) { destroy(); }

int
TaskListInfo::init(int num)
{
    if (taskListPool == NULL) {
	return extend_pool(num);
    }
    return 0;
}

int
TaskListInfo::extend_pool(int num)
{
    TaskListPtr q = NULL;

    q = (TaskListPtr)malloc(sizeof(TaskList)*(num+1));

    if (q == NULL) {
	return -1;
    }

    q->next = taskListPool;
    taskListPool = q;

    /* Connect all free pack_list in the pool */
    for (q = taskListPool + 1; --num > 0; q++) {
	q->next = q + 1;
    }
    q->next = freeTaskList;
    freeTaskList = taskListPool + 1;

    return 0;
}

TaskListPtr
TaskListInfo::create(void)
{
    TaskListPtr q;

    if (freeTaskList == NULL) {
	extend_pool(10);
    }
    q = freeTaskList;
    freeTaskList = freeTaskList->next;

    q->length = 0;
    q->next = 0;

    return q;
}

void
TaskListInfo::free(TaskListPtr q)
{
    q->next = freeTaskList;
    freeTaskList = q;
}

void
TaskListInfo::destroy(void)
{
    TaskListPtr q, tmp;

    //for (q = taskListPool; q; q = q->next) {
    q = taskListPool;
    while (q) {
	tmp = q->next;
	free(q);
	q = tmp;
    }
    freeTaskList = taskListPool = NULL;
}

TaskListPtr
TaskListInfo::append(TaskListPtr list, TaskListPtr q)
{
    TaskListPtr p = list;

    if (!p) {
	return q;
    } else {
	while (p->next) p = p->next;
	p->next = q;
	return list;
    }
}


TaskListPtr
TaskListInfo::clear_taskList(TaskListPtr list)
{
    TaskListPtr p, p1;

    list->length = 0;

    p = list->next;
    while (p) {
        p1 = p;
        p = p->next;
        this->free(p1);
    }

    list->next = NULL;
    return list;
}

int
TaskListInfo::length(TaskListPtr list)
{
    int i = 0;
    if (!list) return i;
    while((list=list->next)) i++;
    return i;
}

