#include <stdlib.h>
#include <string.h>
#include "SchedTaskList.h"
#include "SchedTask.h"
#include "SysFunc.h"
#include "SchedTaskArray.h"
#include "SchedTaskArrayLoad.h"
#include "SchedNop2Ready.h"
#include "DmaManager.h"
#include "error.h"

/**
 * SchedTaskList を返す
 *
 * @param[in] next_list 次の実行する TaskList のアドレス
 * @param[in] next_list がメインメモリのアドレスか、
 *            SPE で生成されたアドレスかのフラグ
 *            SPE で生成されている場合、DMA の必要は無い
 *            0: メインメモリ, 1: SPE
 */

SchedTaskList::SchedTaskList(memaddr addr, Scheduler *sched, int tag)
{
    // next() で生成された時に、Task List read を始める
    params_addr = addr;
    scheduler = sched;
    cur_index = 0;
    list = scheduler->get_curListBuf();
    scheduler->dma_load(list, params_addr,
                        sizeof(TaskList), DMA_READ_TASKLIST);

    this->tag = tag;

}


void
SchedTaskList::read()
{
    // next() で TaskListの中身を見られてしまうので、
    // ここで DMA 待ちを行う
    __debug("[SchedTaskList:%s]\n", __FUNCTION__);
    scheduler->dma_wait(DMA_READ_TASKLIST);
}

void
SchedTaskList::exec() {
}

void
SchedTaskList::write()
{
}

/**
 *    next は、SchedTask のものが使われる。
 *    それで正しく動くはず。
 *
 *    next() が呼ばれた時点で、TaskList のloadが終了しているように工夫する。
 *
 */

/* end */
