#include "Button.h"

/**
 * ボタン押下時に push, hold, release の状態を変更する
 * push は押した瞬間にだけ 1 を持つ
 * hold の状態では 0 を持つ
 */
void
Button::push_work(void)
{
    push = (!hold);
    hold = 1;
    release = 0;
}

/**
 * ボタンを離した時に push, hold, release の状態を変更する
 */
void
Button::release_work(void)
{
    push = 0;
    hold = 0;
    release = 1;
}

/**
 * ボタンの状態を初期化する
 */
void
Button::reset(void)
{
    push = 0;
    hold = 0;
    release = 0;
}

/**
 * @retval 1 ボタンが押された(このフレームのみ)
 * @retval 0 押されていない
 */
int
Button::isPush(void)
{
    return push;
}

/**
 * @retval 1 ボタンは押され続けている
 * @retval 0 ボタンは押されていない
 */
int
Button::isHold(void)
{
    return hold;
}

/**
 * @retval 1 ボタンは押されていない
 * @retval 0 ボタンが押されている
 */ 
int
Button::isRelease(void)
{
    return release;
}
