#include "GTaskArray.h"

GTaskArray::GTaskArray()
{
    game_task_array = NULL;
    game_task = NULL;

    task_id = 0;
    task_num = 0;
    param_num = 0;
    inData_num = 0;
    outData_num = 0;
}

GTaskArray::~GTaskArray()
{
    if (game_task_array !=NULL) {
      delete game_task_array;
    }
    if (game_task !=NULL) {
      delete game_task;
    }
}

void
GTaskArray::init(int id, int task, int param, int inData, int outData)
{
    game_task = 0;

    task_id = id;
    task_num = task;
    param_num = param;
    inData_num = inData;
    outData_num = outData;
}

void
GTaskArray::create_task_array(TaskManager *manager)
{
    game_task_array = manager->create_task_array(task_id, task_num, param_num, inData_num, outData_num);
    game_task = 0;
}

void
GTaskArray::next_task_array(int id)
{
    game_task = game_task_array->next_task_array(id, game_task);
}

void
GTaskArray::finish()
{
    game_task_array->spawn_task_array(game_task->next());
    game_task_array->set_cpu(SPE_ANY);
    game_task_array->spawn();
}
