/**
 * ゲームの TaskArray を管理するクラス
 * 取りあえず TaskArray 1つでゲームの Task を格納するようにしてみた
 * TaskArray って何？って人は Cerium/example/hello_array や word_count を参照
 **/

#ifndef INCLUDED_GTASK_ARRAY
#define INCLUDED_GTASK_ARRAY

#include "TaskManager.h"

class GTaskArray;

class GTaskArray {
public:
    GTaskArray(void);
    ~GTaskArray(void);

    HTaskPtr game_task_array;
    TaskPtr game_task;
    
    int task_id;
    int task_num;
    int param_num;
    int inData_num;
    int outData_num;

    void init(int id, int task, int param, int inData, int outData);
    void create_task_array(TaskManager *manager);
    void next_task_array(int id);
    void finish();
    HTaskPtr get_task_array(){return game_task_array;}
};

typedef GTaskArray* GTaskArrayPtr;

#endif
