#include <SDL.h>
#include "Joystick.h"

/**
 * PS3 コントローラの配置
 */
static const int SELECT   = 0;
static const int L3       = 1;
static const int R3       = 2;
static const int START    = 3;
static const int UP       = 4;
static const int RIGHT    = 5;
static const int DOWN     = 6;
static const int LEFT     = 7;
static const int L2       = 8;
static const int R2       = 9;
static const int L1       = 10;
static const int R1       = 11;
static const int TRIANGLE = 12;
static const int CIRCLE   = 13;
static const int CROSS    = 14;
static const int SQUARE   = 15;
static const int PS       = 16;

#if 0 // PS2 コントローラ
static const int CROSS = 0;
static const int CIRCLE = 1;
static const int SQUARE = 2;
static const int TRIANGLE = 3;
static const int L1 = 4;
static const int R1 = 5;
static const int L2 = 6;
static const int R2 = 7;
static const int START = 8;
static const int SELECT = 9;
static const int L3 = 10;
static const int R3 = 11;
static const int UP = 12;
static const int DOWN = 13;
static const int RIGHT = 14;
static const int LEFT = 15;
static const int ESCAPE = 16;
static const int SPACE = 17;
#endif

Joystick::Joystick(SDL_Joystick *j)
{
    joy = j;
}

Joystick::~Joystick(void)
{
    SDL_JoystickClose(joy);    
}

void
Joystick::check(void)
{
    SDL_JoystickUpdate();

    if (SDL_JoystickGetButton(joy,CROSS)==SDL_PRESSED) {
	    cross.push_work();
    } else {
	cross.release_work();
    }

    if (SDL_JoystickGetButton(joy,CIRCLE)==SDL_PRESSED) {
	circle.push_work();
    } else {
	circle.release_work();
    }

    if (SDL_JoystickGetButton(joy,SQUARE)==SDL_PRESSED) {
	square.push_work();
    } else {
	square.release_work();
    }

    if (SDL_JoystickGetButton(joy,TRIANGLE)==SDL_PRESSED) {
	triangle.push_work();
    } else {
	triangle.release_work();
    }

    if (SDL_JoystickGetButton(joy,L1)==SDL_PRESSED) {
	l1.push_work();
    } else {
	l1.release_work();
    }

    if (SDL_JoystickGetButton(joy,R1)==SDL_PRESSED) {
	r1.push_work();
    } else {
	r1.release_work();
    }

    if (SDL_JoystickGetButton(joy,L2)==SDL_PRESSED) {
	l2.push_work();
    } else {
	l2.release_work();
    }

    if (SDL_JoystickGetButton(joy,R2)==SDL_PRESSED) {
	r2.push_work();
    } else {
	r2.release_work();
    }

    if (SDL_JoystickGetButton(joy,START)==SDL_PRESSED) {
	start.push_work();
    } else {
	start.release_work();
    }

    if (SDL_JoystickGetButton(joy,SELECT)==SDL_PRESSED) {
	select.push_work();
    } else {
	select.release_work();
    }

    if (SDL_JoystickGetButton(joy,L3)==SDL_PRESSED) {
	l3.push_work();
    } else {
	l3.release_work();
    }

    if (SDL_JoystickGetButton(joy,R3)==SDL_PRESSED) {
	r3.push_work();
    } else {
	r3.release_work();
    }

    if (SDL_JoystickGetButton(joy,UP)==SDL_PRESSED) {
	up.push_work();
    } else {
	up.release_work();
    }

    if (SDL_JoystickGetButton(joy,DOWN)==SDL_PRESSED) {
	down.push_work();
    } else {
	down.release_work();
    }
    if (SDL_JoystickGetButton(joy,RIGHT)==SDL_PRESSED) {
	right.push_work();
    } else {
	right.release_work();
    }
    if (SDL_JoystickGetButton(joy,LEFT)==SDL_PRESSED) {
	left.push_work();
    } else {
	left.release_work();
    }

    axis = SDL_JoystickGetAxis(joy,0);
    if (axis >= 3200) {
	left.release_work();
	right.push_work();
    } else if (axis <= -3200) {
	right.release_work();
	left.push_work();
    } else {
	left.release_work();
	right.release_work();
    }

    axis = SDL_JoystickGetAxis(joy,1);
    if (axis>=3200) {
	up.release_work();
	down.push_work();
    } else if (axis<=-3200) {
	down.release_work();
	up.push_work();
    } else {
	up.release_work();
	down.release_work();
    }
}
