#include <stdio.h>
#include "Keyboard.h"
#include "Joystick.h"

/**
 * Joystick があればそれを使い、
 * 無ければキーボードを返す
 */
Pad*
create_controller(void)
{
    if (SDL_NumJoysticks()) {
		SDL_Joystick *joy = SDL_JoystickOpen(0);
		if (!joy) {
			printf("%s: failed to open joystick", __FUNCTION__);
			printf("Instead use Keyboard\n");
			return new Keyboard;
		} else {
			printf("Use Joystick\n");
			return new Joystick(joy);
		}
    } else {
		printf("Use Keyboard\n");
		return new Keyboard;
    }
}
