#ifndef INCUDED_SCENE_GRAPH_ARRAY
#define INCUDED_SCENE_GRAPH_ARRAY

#include "SceneGraph.h"

// 下ですぐ #undef してます
#define MAX_SIZE 32

class SceneGraphArray {
public:
    SceneGraph buf[MAX_SIZE];
    int size;
    int pad[3];

    //SceneGraphArray(void) : size(0) {}
    SceneGraphArray(void);

    /**
     * array の初期化
     */
    void init(void) {
	size = 0;
    }

    /**
     * buf から SceneGraph buffer を返す
     *
     * @retval SceneGraph if size < MAX_SIZE
     * @retval NULL if size >= MAX_SIZE
     */
    SceneGraphPtr getNext(void) {
	if (size >= MAX_SIZE) {
	    return NULL;
	} else {
	    return &buf[size++];
	}
    }
};

typedef SceneGraphArray *SceneGraphArrayPtr;

#undef MAX_SIZE

#endif
