#include "SceneGraphIterator.h"

void
SceneGraphIterator::set(SceneGraphPtr _list)
{
    list = cur = _list;
}

/**
 * 次の SceneGraph があるか返す
 *
 * @retval 1 next がある
 * @retval 0 next がない
 */
int
SceneGraphIterator::hasNext(void)
{
    return (cur->next) ? 1 : 0;
}

/**
 * 指定した名前をもつ SceneGraph が以降存在するか
 *
 * @param id 検索したい SceneGraph の ID
 * @retval 1 next がある
 * @retval 0 next がない
 */
int
SceneGraphIterator::hasNext(int id)
{
    SceneGraphPtr p;

    for (p = cur->next; p; p = p->next) {
	if (p->sgid == id) {
	    return 1;
	}
    }

    return 0;
}

/*!
  指定したグループが以降存在するか
  
  @param id 検索したい Group の ID
  @retval 1 next がある
  @retval 0 next がない
 */
int
SceneGraphIterator::hasNextGroup(int id)
{
    SceneGraphPtr p;
    for (p = cur->next; p; p = p->next) {
	if (p->gid == id) {
	    return 1;
	}
    }

    return 0;
}

/**
 * iterator を次に進める
 */
void
SceneGraphIterator::next(void)
{
    cur = cur->next;
}

/**
 * iterator を指定した ID を持つ SceneGraph まで進める
 * SceneGraph が無い場合、NULL にする
 *
 * @param id 検索したい SceneGraph の ID
 */
void
SceneGraphIterator::next(int id)
{
    SceneGraphPtr p;

    for (p = cur->next; p; p = p->next) {
	if (p->sgid == id) {
	    break;
	}
    }

    cur = p;
}

/*!
  iterator を指定した Group ID を持つ SceneGraph まで進める

  @param id 検索したい SceneGraph の Group ID
 */
void
SceneGraphIterator::nextGroup(int id)
{
    SceneGraphPtr p;

    for (p = cur->next; p; p = p->next) {
	if (p->gid == id) {
	    break;
	}
    }

    cur = p;
}

/**
 * 参照中の SceneGraph を削除する
 */
void
SceneGraphIterator::remove(void)
{
    cur->remove();
}

/**
 * 参照中の SceneGraph を返す
 *
 * @return current SceneGraph
 */
SceneGraphPtr
SceneGraphIterator::get(void)
{
    return cur;
}
