#include <SDL.h>
#include "SgChange.h"
#include "viewer_types.h"
#include "SceneGraph.h"
#include "SceneGraphRoot.h"
#include "scene_graph_pack.h"
#include "matrix_calc.h"
#include "Func.h"
#include "error.h"
#include "TaskManager.h"
#include <wchar.h>
#include "Pad.h"
#include "Application.h"
#include "lindaapi.h"

static void post2runLoop(SchedTask *s, void *viewer, void *s1);
static void post2run(SchedTask *s, void *viewer, void *s1);
static void post2runDraw(SchedTask *s, void *viewer, void *s1);
static void post2rendering(SchedTask *s, void *viewer, void *s1);

/* measure for FPS (Frame Per Second) */
extern int start_time;
extern int this_time;
extern int frames;

/* Data Pack sent to Other CPUs (ex. SPE) */
extern RederingData r[2];

void
SgChange::run_init()
{   
    int width  = viewer->width;
    int height = viewer->height;
    sgroot_A = new SceneGraphRoot(width, height, manager);
    sgroot_A->tmanager = viewer->manager;
    sgroot_B = new SceneGraphRoot(width, height, manager);
    sgroot_B->tmanager = viewer->manager;
}

HTaskPtr
SgChange::initLoop()
{
    return viewer->initLoop();
}

void
SgChange::mainLoop()
{
    HTaskPtr task_next = initLoop();
    
    task_next->set_post(&post2run, (void *)this, 0);
    task_next->spawn();
}



static void
post2run(SchedTask *s, void *sgchange_, void *arg)
{
    SgChange *sgchange = (SgChange*)sgchange_;
    HTaskPtr task_next = sgchange->manager->create_task(Dummy);
    sgchange->run_loop(task_next);
    psx_sync_n();
}

static void
post2runLoop(SchedTask *s, void *sgchange_, void *arg)
{
    SgChange *sgchange = (SgChange*)sgchange_;
    HTaskPtr task_next = sgchange->manager->create_task(Dummy);
    sgchange->viewer->light_xyz_stock = sgchange->sgroot_A->getLightVector();
    sgchange->pass_draw_tree();
    sgchange->run_loop(task_next);

    psx_sync_n();
}


void
SgChange::pass_draw_tree()
{
    sgroot_B->sg_draw_tree = sgroot_A->sg_exec_tree;
}

void
SgChange::run_loop(HTaskPtr task_next)
{
    viewer->dev->clear_screen();

    bool quit_flg;
    quit_flg = viewer->quit_check();
    if (quit_flg == true) {
        // this_time = viewer->get_ticks();
        viewer->run_finish();
        return;
    }

    viewer->dev->clean_pixels();

    for (int i = 1; i <= r[spi].spackList_length; i++) {
        r[spi].spackList[i-1].reinit(i*split_screen_h);
    }

    sgroot_A->updateControllerState();

    HTaskPtr loop_task  = manager->create_task(Dummy);
    loop_task->set_post(post2runLoop, (void *)this, 0);

    HTaskPtr draw_task  = manager->create_task(Dummy);
    draw_task->set_post(post2rendering, (void *)this, 0);

    /*
      application 側で sgroot に task を生成登録する
      引数を渡したりは後でやる。
      登録された関数を実行して task を生成登録する。
    */
    sgroot_A->regist_execute();

    //HTaskPtr move_task  = manager->create_task(RunMove);
    HTaskPtr move_task  = manager->create_task(ExecMove);
    move_task->set_param(0, (memaddr)this);
    move_task->set_param(1, viewer->width);
    move_task->set_param(2, viewer->height);

    /*
      TTaskPtr move_finish = manager->create_task(Dummy);
      loop_task->wait_for(move_finish);
      move_finish は app の move_task の post_func で実行させてやる
    */

    /*
      描画終了確認用のダミータスク
      描画の最後で spwan させる
    */
    HTaskPtr dummy_task = manager->create_task(Dummy);

    draw_finish = dummy_task;

    loop_task->wait_for(draw_finish);
    // move_task に wait_for ではなく sgroot_A->move_exec_task に wait_for するべき
    // どこかで move_exec_task->spawn() しないとな
    loop_task->wait_for(sgroot_A->move_exec_task);

    //loop_task->wait_for(move_task);
    

    draw_task->spawn();
    // この時点で app の task_id を知っていないとダメか
    move_task->spawn();
    loop_task->spawn();
}

static void 
post2rendering(SchedTask *s, void *sgchange_, void *arg)
{
    SgChange *sgchange = (SgChange *)sgchange_;
    HTaskPtr task_next = sgchange->manager->create_task(Dummy);
    sgchange->rendering(task_next);

}

void 
SgChange::rendering(HTaskPtr task_next)
{
    viewer->rendering_pp(task_next, sgroot_B);
    viewer->rendering_sp(task_next, sgroot_B);

    task_next->set_post(post2runDraw, (void*)this, 0);
    task_next->spawn();
}


static void 
post2runDraw(SchedTask *s, void *sgchange_, void *arg)
{
    SgChange *sgchange = (SgChange *)sgchange_;
    HTaskPtr task_next = sgchange->manager->create_task(Dummy);
    sgchange->run_draw(task_next);
}

void
SgChange::run_draw(HTaskPtr task_next) // 引数に post2runLoop を入れるようにする
{
    viewer->common_draw(task_next);

    this->draw_finish->wait_for(task_next);
    task_next->spawn();
    this->draw_finish->spawn();

    frames++;
}

/* end */
