#ifndef INCLUDED_SG_CHANGE
#define INCLUDED_SG_CHANGE

#include <SDL.h>

#include "viewer_types.h"
#include "TaskManager.h"
#include "KeyStat.h"
#include "MainLoop.h"
#include "Application.h"
#include "SceneGraphRoot.h"
#include "viewer.h"

class SceneGraphRoot;
class Application;

class SgChange : public MainLoop {

public:

    Viewer *viewer;
    TaskManager *manager;

    SgChange(Viewer *v) {
	viewer = v;
	manager = v->manager;
    }

    virtual ~SgChange() {}


    SceneGraphRoot *sgroot_A;
    SceneGraphRoot *sgroot_B;

    HTaskPtr draw_finish;

    void run_init();
    void run_loop(HTaskPtr task_next);
    void run_move(HTaskPtr task_next);
    void run_draw(HTaskPtr task_next);
    void rendering(HTaskPtr task_next);
    HTaskPtr initLoop();

    void pass_draw_tree();
    void mainLoop();

    void createFromXMLfile(const char *file)
    {
	sgroot_A->createFromXMLfile(manager, file);
    }

    SceneGraph * createSceneGraph(int id)
    {
	return sgroot_A->createSceneGraph(id);
    }

    SceneGraph * createSceneGraph(const char *id)
    {
	return sgroot_A->createSceneGraph(id);
    }

    int getSgid(const char *id)
    {
	return sgroot_A->getSgid(id);
    }

    SceneGraph * createSceneGraph()
    {
	return sgroot_A->createSceneGraph();
    }

    void setSceneData(SceneGraph *g)
    {
	sgroot_A->setSceneData(g);
    }

    int getLast()
    {
	return sgroot_A->getLast();
    }
};

#endif

