#ifndef INCLUDED_TEXTURE_HASH
#define INCLUDED_TEXTURE_HASH

const int TABLE_SIZE = 9192; //8192 + 1000

struct hashtable{
    int tx_id;
    char* key;
};

class TextureHash {
public:
	int id_count;
    hashtable *table;

    TextureHash(void);
    ~TextureHash(void);
    int hash_function(const char* image_name);
    int hash_regist(const char* image_name, int &tx_id);
    int sg_hash_regist(const char* image_name, int &tx_id);
    int get_sgid(const char* key);
    void remove(int id) {  table[id].tx_id = -1; }
};

#endif
