#ifndef INCLUDED_POLYGON
#define INCLUDED_POLYGON

#include <SDL.h>
#include <libxml/parser.h>
#include "polygon_pack.h"
#include "SpanPack.h"
#include "texture.h"
#include "TaskManager.h"

class Polygon {
public:

    long long size;
    const char *name;
    const char *parent_name;

    float *matrix;
    float *real_matrix;
    texture_list *texture_info;
       
    PolygonPackPtr pp;
    int pp_num;

    float xyz[4];     // position
    float angle[4];   // angle
    float c_xyz[4];   // center of rotation
    float *anim;
    float scale[3];

    Polygon(void);

    void parameter_change(char *name, float x, float y, float z, float ax, float ay, float az);
    //void load_texture(char *image_name);
    //void draw(float *stack);
    //void draw(SceneGraphPack *sgp);
    //void draw(PolygonPack *pp);
    //void draw(SpanPack *sp);
    Uint32 get_rgb(int tx, int ty);

public:
    void*
      polygon_allocate(int size)
      {
	void *buff = 0;
	if (size==0) return 0;
#if defined(__SPU__) || ! defined(HAS_POSIX_MEMALIGN)
	buff =  malloc(size);
#else
	posix_memalign(&buff, DEFAULT_ALIGNMENT, size);
#endif
	if (buff==0) 
	  printf("Polygon:Can't allocate memory\n");
	return buff;

      }

    void position_init(void);

    void tree_draw();
    void pickup_coordinate(char *cont);
    void pickup_normal(char *cont);
    void pickup_model(char *cont);
    void pickup_texture(char *cont);
};

#endif
