#include "viewer_types.h"

int
getLocalPosition(int d, int offset)
{
    return d & (offset-1);
}

/**
 * ワールド座標における x の値を
 * split_screen_w で分割した領域(1 〜 split_screen_w)での座標に変換する
 * (ex. split_screen_w が 256 の場合、
 *      x =   1 -> 1
 *      x = 256 -> 256
 *      x = 257 -> 1
 */
int
getLocalX(int x)
{
    return getLocalPosition(x, split_screen_w);
}

/**
 * getLocalX に同じ
 */
int
getLocalY(int y)
{
    return getLocalPosition(y, split_screen_h);
}
