#include <string.h>
#include "Set_Texture.h"
#include "texture.h"
#include "global_alloc.h"

SchedDefineTask(SetTexture);

//texture をglobal 領域にコピーするタスク
static int
run(SchedTask *s,void *rbuf, void *wbuf)
{
    void *src[4];

    src[0] = s->get_input(rbuf, 0);
    src[1] = s->get_input(rbuf, 1);
    src[2] = s->get_input(rbuf, 2);
    src[3] = s->get_input(rbuf, 3);

    if (s->global_get(TEXTURE_ID)) {
        return 0;
    } else {
        //タスクが共有できる領域確保
        void *data = s->global_alloc(TEXTURE_ID, MAX_LOAD_SIZE*4);

        memcpy(data, src[0], MAX_LOAD_SIZE);
        memcpy((void*)((memaddr)data + MAX_LOAD_SIZE), src[1], MAX_LOAD_SIZE);
        memcpy((void*)((memaddr)data + MAX_LOAD_SIZE*2), src[2], MAX_LOAD_SIZE);
        memcpy((void*)((memaddr)data + MAX_LOAD_SIZE*3), src[3], MAX_LOAD_SIZE);
    }

    return 0;
}
