#include "../Func.h"
#include "Scheduler.h"

SchedExternTask(DataAllocate);
SchedExternTask(DataUpdate);
SchedExternTask(DataFree);

SchedExternTask(Update_SGP);
SchedExternTask(CreatePolygon);
SchedExternTask(CreatePolygonFromSceneGraph);
SchedExternTask(CreateSpan);

SchedExternTask(DrawSpan);
SchedExternTask(DrawSpanRenew);
SchedExternTask(DrawBack);

SchedExternTask(EXEC_ONLY_TASK);
SchedExternTask(RUN_LOOP_TASK);
SchedExternTask(CREATE_PP_TASK);
SchedExternTask(CREATE_SP_TASK);
SchedExternTask(DRAW_TASK);

SchedExternTask(LoadTexture);

// SchedExternTask(Move);
SchedExternTask(Draw);

// SchedExternTask(Dummy);

SchedExternTask(ShowTime);
// SchedExternTask(ChainMove);
SchedExternTask(SendKey);

SchedExternTask(UpdateKey);
SchedExternTask(InitKey);

SchedExternTask(Switch);
SchedExternTask(RunMove);

SchedExternTask(PropertyTask);
SchedExternTask(ExecMove);


/**
 * set_cpu(CPU_PPE) で動作する task
 */
void
task_initialize()
{
    SchedRegister( DataAllocate);
    SchedRegister( DataUpdate);
    SchedRegister( DataFree);

    SchedRegister( Update_SGP);
    SchedRegister(CreatePolygonFromSceneGraph);
    SchedRegister(CreatePolygon);
    SchedRegister( CreateSpan);

    SchedRegister( DrawSpan);
    SchedRegister( DrawBack);

    SchedRegister(EXEC_ONLY_TASK);
    SchedRegister(RUN_LOOP_TASK);
    SchedRegister(CREATE_PP_TASK);
    SchedRegister(CREATE_SP_TASK);
    SchedRegister(DRAW_TASK);

    SchedRegister( LoadTexture);

//    SchedRegister( Move);
    SchedRegister( Draw);

    // SchedRegister( Dummy);

    SchedRegister( UpdateKey);
    SchedRegister( InitKey);

    //SchedRegister( ShowTime);
    SchedRegister( Switch);

    SchedRegister( ExecMove);

    // usr
//    SchedRegister( ChainMove);
//    SchedRegister( RunMove);
//    SchedRegister( PropertyTask);

}
