#include <iostream>
#include <SDL.h>
#include <SDL_opengl.h>
#include <libxml/parser.h>
#include "polygon.h"
using namespace std;

char *skip_to_number(char *cont)
{
  if (cont == NULL) return(NULL);
  for (;(*cont < '+' || *cont > '9') && (*cont != '\0');cont++) {}
  if (*cont == '\0')
    {
      fprintf(stderr,"Content data is short\n");
      return(NULL);
    }
  return(cont);
}


char *pickup_float(char *cont, float *index)
{
  int sign=1,exp=1;
  float shift=10,val_dec=0,val_int=0;

  cont = skip_to_number(cont);
  if (cont == NULL) return(NULL);

  for (;*cont != ' ' && *cont != '\n' && *cont != '\t' && *cont != ',' ;cont++)
    {
      if (*cont == '-')
        {
          sign = -1;
        }
      else if (*cont == '.')
        {
          shift = 0.1;
        }
      else if (*cont >= '0' && *cont <= '9')
        {
          if (shift == 10)
            {
              val_int *= shift;
              val_int += *cont - 48;
            }
          else
            {
              val_dec += (*cont - 48) * shift;
              shift *= 0.1;
            }
        }
      else if (*cont == 'e' || *cont == 'E')
        {
          //cont = pickup_exponent(&exp,cont+1);
          if (cont == NULL) return(NULL);
        }
      else if (*cont == '+' || *cont == '/' || *cont == ' ')
        {
          // ignore
        }
      else
        {
          fprintf(stderr,"Pick up float failed : %c(%d)\n",*cont,*cont);
          return(NULL);
        }
    }

  *index = sign * (val_int + val_dec) * exp;
  cont++;
  return(cont);
}


/*
int main(int artc, char *argv[])
{
  xmlDocPtr doc;
  xmlNodePtr cur;
  char *cont;

  doc = xmlParseFile(argv[1]);

  cur = xmlDocGetRootElement(doc);

  xmlStrcmp(cur->name,(xmlChar*)"OBJECT-3D");

  for (cur=cur->children; cur; cur=cur->next)
    {
      if (!xmlStrcmp(cur->name,(xmlChar*)"surface"))
        {
	  get_data(cur->children);
        }
    }

  xmlFreeDoc(doc);
  return 0;

}
*/
