#include "Application.h"

typedef struct {
    double x, y, next_x, next_y;
    double vx, vy, next_vx, next_vy;
    double angle[3];
    int can_move;
    SceneGraphPtr parent;
    int id;
    int parent_id;
} *ChainPropertyPtr, ChainProperty;


class Chain : public Application {
public:
    Chain(){}

    SceneGraphPtr scenegraph_factory(void *p, int size);
    SceneGraphPtr scenegraph_connector(void *p, int size, SceneGraphPtr s, SceneGraphPtr sg_available_list);
    void init(TaskManager *manager, int w, int h);
    void init_chain_vars(ChainPropertyPtr cv);
    void chain_move(TaskManager *manager, SceneGraphPtr sg, int w, int h);
    void chain_collision(SceneGraphPtr sg, int w, int h, SceneGraphPtr osg);

    MainLoopPtr init(Viewer *viewer, int screen_w, int screen_h);


};
