#include <math.h>
#include "SceneGraphRoot.h"
#include "SGList.h"
#include "hit_judge.h"
#define PI M_PI

int i = 0;

void
bullet_init(SceneGraphPtr bullet, SceneGraphPtr player)
{
    bullet->xyz[0] = player->xyz[0];
    bullet->xyz[1] = player->xyz[1];
    bullet->xyz[2] = player->xyz[2];

    bullet->angle[0] = player->angle[0];
    bullet->angle[1] = player->angle[1];
    bullet->angle[2] = player->angle[2];
}

void 
bluebullet_move(SceneGraphPtr node, int screen_w, int screen_h)
{  
    double a = (node->angle[2]+90)*PI/180;
    double b = (node->angle[0]+90)*PI/180;
      
    double y = sin(a);
    double x = cos(a);
    double z = -cos(b);
    
    node->xyz[0] += x * 5;//x軸方向
    node->xyz[1] += y * 5;//y軸方向
    node->xyz[2] += z * 5;//z軸方向  
}

void
bullet_collision(SceneGraphPtr node, int screen_w, int screen_h, SceneGraphPtr tree)
{
    SceneGraphIteratorPtr it = sgroot->getIterator(tree);
    //static int damage = 0;

    for (; it->hasNext(E_PLANE);) {
	it->next(E_PLANE);
	SceneGraphPtr enemy = it->get();

	int judge = square_judge(node, enemy);
	if(judge == HIT)
	{
	    //node->set_move_collision(null_move, bullet_collision);
	    //E_PLANE->set_move_collision(null_move, enemy_collision);
	  enemy->remove();
	    node->remove();
	    //printf("hit!!!\n");
	    //bullet_delete(node, scene_graph);
	}
    }

    if(node->xyz[1] > 100)
    {
	node->remove();
	//scene_graph->delete_object(node, node->next,node->prev);
	//i -= 1;
	//printf("bullet_delete:残り弾数＝%d\n",i);
    }
}
