#include "SceneGraphRoot.h"
#include "direction.h"

static void
x_move(SceneGraphPtr node, void *sgroot_, int w, int h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    node->xyz[0] = w/2;
    node->xyz[1] = h/2;

    if (pad->circle.isPush() || pad->circle.isHold()) {
	node->angle[1] += 10.0f;
	if (node->angle[1] > 360.0f) node->angle[1] = 0.0f;
    }

    if (pad->triangle.isPush() || pad->triangle.isHold()) {
	node->angle[0] += 10.0f;
	if (node->angle[0] > 360.0f) node->angle[0] = 0.0f;
    }    

    if (pad->start.isPush()) {
	node->angle[0] = 0.0f;
	node->angle[1] = 90.0f;
    }
    
}

static void
y_move(SceneGraphPtr node, void *sgroot_, int w, int h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    node->xyz[0] = w/2;
    node->xyz[1] = h/2;

    if (pad->cross.isPush() || pad->cross.isHold()) {
	node->angle[2] += 10.0f;
    }

    if (pad->square.isPush() || pad->square.isHold()) {
	node->angle[0] += 10.0f;
    }

    if (pad->start.isPush()) {
	node->angle[0] = 90.0f;
	node->angle[1] = 0.0f;
    }
    
}

static void
z_move(SceneGraphPtr node, void *sgroot_, int w, int h)
{
    node->xyz[0] = w/2;
    node->xyz[1] = h/2;
}

static void
dir_collision(SceneGraphPtr node, void *sgroot_, int w, int h, SceneGraphPtr tree)
{
}

MainLoopPtr 
direction::init(Viewer *sgroot, int screen_w, int screen_h)
{
    SceneGraphPtr dx;
    SceneGraphPtr dy;
    SceneGraphPtr dz;
    SceneGraphPtr back;

    sgroot->createFromXMLfile("xml_file/direction.xml");

    dx = sgroot->createSceneGraph("Dirx");
    dy = sgroot->createSceneGraph("Diry");
    dz = sgroot->createSceneGraph("Dirz");
    back = sgroot->createSceneGraph();
    
    back->addChild(dx);
    back->addChild(dy);
    back->addChild(dz);

    dx->set_move_collision(x_move, dir_collision);
    dx->angle[1] = 90.0f;
    dy->set_move_collision(y_move, dir_collision);
    dy->angle[0] = 90.0f;
    dz->set_move_collision(z_move, dir_collision);

    back->angle[0] = 30.0f;
    back->angle[1] = -30.0f;

    sgroot->setSceneData(back);
    return sgroot;
}

extern Application *
application() {
    return new direction();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

