#include <iostream>
#include <cmath>
#include "SceneGraphRoot.h"
#include "gaplant.h"
using namespace std;

void
move_right(SceneGraphPtr node)
{
  /*cout << "右を押したんだ " << node->angle[2] << "\n";*/
    node->angle[1] -= 10;
    /* if (node->angle[2] < -30) {
	node->angle[2] = -30;
	}
	node->xyz[0] += 5;*/
}

void
move_left(SceneGraphPtr node)
{
  /*cout << "左を押したんだ " << node->angle[2] << "\n";*/
    node->angle[1] += 10;
    /* if (node->angle[2] > 30) {
	node->angle[2] = 30;
	}
	node->xyz[0] -= 5;*/
}

void
move_down(SceneGraphPtr node)
{
  /*cout << "下だって押したくなる時はある "<< node->angle[0] << "\n";*/
    node->angle[0] += 10;
    /*if (node->angle[0] > -60) {
	node->angle[0] = -60;
	}
	node->xyz[1] += 5;*/
}

void
move_up(SceneGraphPtr node)
{
  /*cout << "上を押したんだ "<< node->angle[0] << "\n";*/
    node->angle[0] -= 10;
    /*if (node->angle[0] < -120) {
	node->angle[0] = -120;
	}
	node->xyz[1] -= 5;*/
}

void
gaplant_move(SceneGraphPtr node, void *sgroot_, int w, int h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();
    
    if (pad->right.isHold() || pad->left.isHold() || pad->down.isHold() || pad->up.isHold()) {
	if (pad->right.isHold()) {
	    move_right(node);
	} else if (pad->left.isHold()) {
	    move_left(node);
	} else if (pad->down.isHold()) {
	    move_down(node);
	} else if (pad->up.isHold()) {
	    move_up(node);
	}
    }
    
    if (pad->cross.isHold() || pad->circle.isHold()) {
	if (pad->cross.isHold()) {
	    node->xyz[2] += 5;
	} else if (pad->circle.isHold()) {
	    node->xyz[2] -= 5;
	}
    }
}

void
gaplant_coll(SceneGraphPtr node, void *sgroot_, int w, int h, SceneGraphPtr tree)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    SceneGraphIteratorPtr it = sgroot->getIterator(tree);
    //static int damage = 0;
    
    for (; it->hasNext(sgroot->getSgid("Ball"));) {
	it->next(sgroot->getSgid("Ball"));
	SceneGraphPtr ball = it->get();

	double dis_x = node->xyz[0] - ball->xyz[0];
	double dis_y = node->xyz[1] - ball->xyz[1];
	double dis_z = node->xyz[2] - ball->xyz[2];	    
	double distance = sqrt(dis_x*dis_x + dis_y*dis_y + dis_z*dis_z);
	
	if (distance < CHECK_HIT_RAD + BALL_RAD) {
	    cout << "今からもっと細かく判定するよ ^q^\n";	    
	    ball->remove();
	}
    }
}
