#include "SceneGraphRoot.h"
#include "ieshoot.h"

static const float jiki_speed = 6.0f;
static const float jiki_radius = 32.0f;

static const float tama_speed = 10.0f;
static const float tama_radius = 16.0f;

static const float boss_radius_x = 64.0f;
static const float boss_radius_y = 128.0f;

static const float iebosstama_speed = 15.0f;

static void
ieboss_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
		 SceneGraphPtr tree);
static void
ieboss_collision_invincibil(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h, SceneGraphPtr tree);
static void ieboss_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);

static void iebosstama_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);


static void
iejiki_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

static void
ietama_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
		 SceneGraphPtr tree)
{
}

static void
ieboss_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
		 SceneGraphPtr tree)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    SceneGraphIteratorPtr it = sgroot->getIterator(tree);
    static int damage = 0;
    int ietama = sgroot->getSgid("IETAMA");
    for (; it->hasNext(ietama);) {
	it->next(ietama);
	SceneGraphPtr tama = it->get();

	if (node->xyz[0] - boss_radius_x < tama->xyz[0] + tama_radius
	    && node->xyz[0] + boss_radius_x > tama->xyz[0] - tama_radius
	    && node->xyz[1] + boss_radius_y > tama->xyz[1] - tama_radius) {
	    tama->remove();

	    node->set_move_collision(ieboss_move, ieboss_collision_invincibil);

	    SceneGraphPtr iebosstama = sgroot->createSceneGraph("Earth");
	    iebosstama->set_move_collision(iebosstama_move, ietama_collision);
	    iebosstama->xyz[0] = node->xyz[0];
	    iebosstama->xyz[1] = node->xyz[1] + boss_radius_y;
	    //iebosstama->xyz[2] = 50.0f;
	    node->addBrother(iebosstama);

	    damage++;
	}
    }

    if (damage > 10) {
	node->remove();
    }
}

static void
ieboss_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    /**
     * TODO
     *  Boss が複数居た場合、これじゃ駄目
     */
    static float x_speed = 5.0f;
    static float z_speed = 5.0f;

    node->xyz[0] += x_speed;

    if (node->xyz[0] - boss_radius_x < 0) {
	x_speed = -x_speed;
	node->xyz[0] = boss_radius_x;
    } else if (node->xyz[0] + boss_radius_x > screen_w) {
	x_speed = -x_speed;
	node->xyz[0] = screen_w - boss_radius_x;
    }

    //node->xyz[2] += z_speed;
    if (node->xyz[2] >= 100.0f) {
	node->xyz[2] = 99.99f;
	z_speed = -z_speed;
    } else if (node->xyz[2] <= -100.0f) {
	node->xyz[2] = -99.99f;
	z_speed = -z_speed;
    }
}

static void
ieboss_collision_invincibil(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
			    SceneGraphPtr tree)
{
    static int frame = 0;

    frame++;

    node->flag_drawable ^= 1;

    if (frame > 60) {
	frame = 0;
	node->flag_drawable = 1;
	node->set_move_collision(ieboss_move, ieboss_collision);
    }
}

static void
iebosstama_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    node->xyz[1] += iebosstama_speed;

    // 描画領域から抜けたら削除
    if (node->xyz[1] > screen_h) {
	node->remove();
    }
}

static void
ietama_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    node->xyz[1] -= tama_speed;

    // 描画領域から抜けたら削除
    if (node->xyz[1] < 0) {
	node->remove();
    }
}

static void
iejiki_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if (pad->left.isPush()
	|| pad->left.isHold()) {
	node->xyz[0] -= jiki_speed;

	if (node->xyz[0] - jiki_radius< 0) {
	    node->xyz[0] = jiki_radius;
	}
    }

    if (pad->right.isPush()
	|| pad->right.isHold()) {
	node->xyz[0] += jiki_speed;

	if (node->xyz[0] + jiki_radius > screen_w) {
	    node->xyz[0] = screen_w - jiki_radius;
	}
    }

    if (pad->up.isPush()
	|| pad->up.isHold()) {
	node->xyz[1] -= jiki_speed;

	if (node->xyz[1] - jiki_radius < 0) {
	    node->xyz[1] = jiki_radius;
	}
    }

    if (pad->down.isPush()
	|| pad->down.isHold()) {
	node->xyz[1] += jiki_speed;

	if (node->xyz[1] + jiki_radius > screen_h) {
	    node->xyz[1] = screen_h - jiki_radius;
	}
    }

    if (pad->circle.isPush()) {
	SceneGraphPtr ietama = sgroot->createSceneGraph("IETAMA");
	ietama->set_move_collision(ietama_move, ietama_collision);
	ietama->xyz[0] = node->xyz[0];
	ietama->xyz[1] = node->xyz[1];
	node->addBrother(ietama);
    }
}


MainLoopPtr
ieshoot::init(Viewer *sgroot, int w, int h)
{
    SceneGraphPtr iejiki;
    SceneGraphPtr enemy;
    SceneGraphPtr back;

    sgroot->createFromXMLfile( "xml_file/ietama.xml");
    sgroot->createFromXMLfile( "xml_file/ieboss.xml");
    sgroot->createFromXMLfile( "xml_file/iejiki.xml");
    sgroot->createFromXMLfile( "xml_file/universe.xml");

    back = sgroot->createSceneGraph();

    iejiki = sgroot->createSceneGraph("IEJIKI");
    iejiki->set_move_collision(iejiki_move, iejiki_collision);
    iejiki->xyz[2] = 20;
    back->addChild(iejiki);

    enemy = sgroot->createSceneGraph("IEBOSS");
    enemy->set_move_collision(ieboss_move, ieboss_collision);
    enemy->xyz[1] = boss_radius_y;
    back->addChild(enemy);

    sgroot->setSceneData(back);
    return sgroot;
}

extern Application *
application() {
    return new ieshoot();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

