#include "SceneGraphRoot.h"
#include "player_action.h"
#include "enemy_action.h"
#include "camera_action.h"
#include "init_position.h"

MainLoopPtr
posiotion::init(Viewer *sgroot, int w, int h)
{
    SceneGraphPtr back;
    SceneGraphPtr player;
    SceneGraphPtr enemy;
    //SceneGraphPtr bullet;

    sgroot->createFromXMLfile(manager, "xml_file/player.xml");
    back   = sgroot->createSceneGraph(BACK);
    //back = sgroot->createSceneGraph();
    player = sgroot->createSceneGraph(IDLE);
    //bullet = sgroot->createSceneGraph(BULEBULLET);
    
    camera_init(back, w, h);
    back->set_move_collision(camera_init, camera_collision);
    player->set_move_collision(player_move_all, player_collision);


    back->addChild(player);

    for (int i = 0; i < 10; i++) {
	enemy  = sgroot->createSceneGraph(E_PLANE);
	enemy->set_move_collision(enemy_move, enemy_collision);
	enemy->xyz[0] = 50.0*i;
	back->addChild(enemy);
    }

    sgroot->setSceneData(back);
    return sgroot;
}
