#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "SceneGraph.h"
#include "node.h"

static void
cube_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

static void
cube_move2(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    node->angle[1] += 1.0f;
    if (node->angle[1] > 360.0f) {
	node->angle[1] = 0.0f;
    }

    node->xyz[0] += node->stack_xyz[0];
    if ((int)node->xyz[0] > screen_w || (int)node->xyz[0] < 0) {
	node->stack_xyz[0] = -node->stack_xyz[0];
    }

    node->xyz[1] += node->stack_xyz[1];
    if ((int)node->xyz[1] > screen_h || (int)node->xyz[1] < 0) {
	node->stack_xyz[1] = -node->stack_xyz[1];
    }
}

static void
cube_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{

    SceneGraphRootPtr sgroot = (SceneGraphRootPtr)sgroot_;

    node->angle[1] += 1.0f;
    if (node->angle[1] > 360.0f) {
	node->angle[1] = 0.0f;
    }

    node->xyz[0] += node->stack_xyz[0];
    if ((int)node->xyz[0] > screen_w || (int)node->xyz[0] < 0) {
	node->stack_xyz[0] = -node->stack_xyz[0];
    }

    node->xyz[1] += node->stack_xyz[1];
    if ((int)node->xyz[1] > screen_h || (int)node->xyz[1] < 0) {

	// 実は微妙に意味が無い
	// そうじゃなくて、やっちゃいけないことです。
	// srandom(random());

      SceneGraphPtr p = node->clone(sgroot->tmanager);
	p->position_init();
	node->addBrother(p);
	p->set_move_collision(cube_move2, cube_collision);
	p->stack_xyz[0] = (float)(random() % 5);
	p->stack_xyz[1] = (float)(random() % 5);
	//p->xyz[0] = screen_w/2;
	//p->xyz[1] = screen_h/2;
	p->xyz[2] = node->xyz[2]+1000.0f;

	node->stack_xyz[1] = -node->stack_xyz[1];
    }
}

MainLoopPtr
node::init(Viewer *sgroot, int screen_w, int screen_h)
{
    sgroot->createFromXMLfile( "xml_file/cube.xml");
    SceneGraphPtr Cube = sgroot->createSceneGraph("Cube");
    Cube->set_move_collision(cube_move, cube_collision);
    Cube->stack_xyz[0] = 2.0f;
    Cube->stack_xyz[1] = 2.0f;
    return sgroot;
}

extern Application *
application() {
    return new node();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */

