#include "SceneGraphRoot.h"
#include "panel.h"

static void panel_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
static void panel_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
			    SceneGraphPtr tree);

static void
panel_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
}

static void
panel_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

int bg = 0;

MainLoopPtr
panel::init(Viewer *sgroot, int screen_w, int screen_h)
{
    SceneGraphPtr panel;

    if (bg == 2) {
		sgroot->createFromXMLfile( "xml_file/panel_512.xml");
		panel = sgroot->createSceneGraph("PANEL_512");
    } else if (bg == 3) {
		sgroot->createFromXMLfile( "xml_file/panel_1024.xml");
		panel = sgroot->createSceneGraph("PANEL_1024");
    } else {
		sgroot->createFromXMLfile( "xml_file/panel_2048.xml");
		panel = sgroot->createSceneGraph("PANEL_2048");
    }

    panel->set_move_collision(panel_move, panel_collision);
    panel->xyz[2] = 30.0f;
    sgroot->setSceneData(panel);
    return sgroot;
}

extern Application *
application() {
    return new panel();
}

const char *usr_help_str = "Usage: ./test_nogl -sg [123] [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    for(int i=0;i<argc;i++) {
         if (strcmp(argv[i],"-sg")==0) {
             bg = atoi(argv[i+1]);
         }
    }
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */

