#include "SceneGraphRoot.h"
#include "bullet_action.h"
#include "SGList.h"

#define MOVE_SPEED 5.00


void
player_move_right(SceneGraphPtr node, int screen_w, int screen_h)
{
  if(node->xyz[0]<screen_w/2)
    {
      node->xyz[0] += MOVE_SPEED;
    }
  if(node->angle[1]<=20)
    {
      node->angle[1]+=1.0;
    }
  if(node->angle[2]>=-45)
    {
      node->angle[2]-=1.0;
    }
}

void 
player_move_left(SceneGraphPtr node, int screen_w, int screen_h)
{
  if(node->xyz[0]> -screen_w/2)
    {
      node->xyz[0] -= MOVE_SPEED;
    }
  if(node->angle[1]>=-20)
    {
      node->angle[1]-=1.0;
    }
  if(node->angle[2]<=45)
    {
      node->angle[2]+=1.0;
    }
}

void 
player_move_up(SceneGraphPtr node, int screen_w, int screen_h)
{
  if(node->xyz[2]<screen_h/2 + 100)
    {
      node->xyz[2] += MOVE_SPEED;
    }
  if(node->angle[0]<45)
    {
      node->angle[0] += 2.0;
    }
}

void 
player_move_down(SceneGraphPtr node, int screen_w, int screen_h)
{
  if(node->xyz[2]> -screen_h/2)
    {
      node->xyz[2] -= MOVE_SPEED;
    }
  if(node->angle[0]>-45)
    {
      node->angle[0] -= 2.0;
    }
}

void
player_move_idle(SceneGraphPtr node)
{
    if (node->angle[1]>0)
    {
	node->angle[1]-=1.0;
    }
    else if(node->angle[1]<0)
    {
	node->angle[1]+=1.0;
    }
  
  if(node->angle[2]<0)
    {
      node->angle[2]+=0.5;
    }
  else if(node->angle[2]>0)
    {
      node->angle[2]-=0.5;
    }

  if(node->angle[0]<0)
    {
      node->angle[0]+=1.0;
    }
  else if(node->angle[0]>0)
    {
      node->angle[0]-=1.0;
    }
}

void
player_move_all(SceneGraphPtr node, int screen_w, int screen_h)
{
    Pad *pad = sgroot->getController();

    if (pad->right.isHold() || pad->left.isHold() ||
	pad->up.isHold() || pad->down.isHold()) {
	if (pad->right.isHold()) {
	    player_move_right(node, screen_w, screen_h);
	} else if (pad->left.isHold()) {
	    player_move_left(node, screen_w, screen_h);
	}
	
	if (pad->down.isHold()) {
	    player_move_up(node, screen_w, screen_h);
	} else if(pad->up.isHold()) {
	    player_move_down(node, screen_w, screen_h);
	}
    } else {
	player_move_idle(node);
    }

    if (pad->r2.isHold()) {
      node->xyz[2] -= 10.0f;
    }

    if (pad->circle.isPush()) {
	SceneGraphPtr bullet = sgroot->createSceneGraph(BULEBULLET);
	bullet->set_move_collision(bluebullet_move, bullet_collision);
	bullet_init(bullet, node);
	node->addBrother(bullet);
    }
}

void
player_collision(SceneGraphPtr node, int screen_w, int screen_h,
		 SceneGraphPtr tree)
{
#if 0
    int judge = square_judge(node, BULEBULLET, scene_graph);
    
    if (judge == HIT)
    {
	node->set_move_collision(player_move_all,player_collision);
    }
#endif
}

