#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "universe.h"

static void
earth_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

static void
moon_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

static void
moon_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
  node->angle[0] += 3.0f;
}


static void
earth_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    node->angle[1] += 1.0f;
    if (node->angle[1] > 360.0f) {
	node->angle[1] = 0.0f;
    }

    node->xyz[0] += node->stack_xyz[0];
    if ((int)node->xyz[0] > screen_w || (int)node->xyz[0] < 0) {
	node->stack_xyz[0] = -node->stack_xyz[0];
    }

    node->xyz[1] += node->stack_xyz[1];
    if ((int)node->xyz[1] > screen_h || (int)node->xyz[1] < 0) {
	node->stack_xyz[1] = -node->stack_xyz[1];
    }
}

MainLoopPtr
universe::init(Viewer *sgroot, int screen_w, int screen_h)
{
    SceneGraphPtr earth;
    SceneGraphPtr moon;

    sgroot->createFromXMLfile( "xml_file/universe.xml");
    sgroot->createFromXMLfile( "xml_file/cube.xml");
    sgroot->OnLightSysSwitch();
    SceneGraphPtr light = sgroot->getLight(0); 
    sgroot->OnLightSwitch(1);
    light->xyz[2] -= 10;

    // SceneGraph ID から SceneGraph を生成する
    earth = sgroot->createSceneGraph("Earth");

    // SceneGraph の move と collision を設定
    earth->set_move_collision(earth_move, earth_collision);
    earth->xyz[0] = screen_w / 2;
    earth->xyz[1] = screen_h / 2;
    earth->stack_xyz[0] = 3.0f;
    earth->stack_xyz[1] = 3.0f;
   
    moon = sgroot->createSceneGraph("Moon");
    moon->set_move_collision(moon_move, moon_collision);
    
    // SceneGraph 同士の親子関係を設定 (今回は 親 earth、子 moon)

    earth->addChild(moon);

    // SceneGraphRoot に、使用する SceneGraph を設定する
    // このとき、ユーザーは SceneGraph の root を渡す。
    sgroot->setSceneData(earth);
    return sgroot;
}

extern Application *
application() {
    return new universe();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */

