#include <math.h>
#include "vacuum.h"
#include "SceneGraphRoot.h"
#define ENCOUNT 55
using namespace std;

static float vacuum_speed = 10.0f;


/*オブジェクト毎にファイルを分けてみた
 *
 *
 */



void
no_move_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{

}

void
no_collision_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,SceneGraphPtr tree)
{

}

int redcube;
int enemy;

void
vacuum_coll(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
            SceneGraphPtr tree)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if(node->frame%ENCOUNT == ENCOUNT-1) {
      if(random()%2) {
          add_cubecollision_object(redcube,node,screen_w,screen_h, sgroot);
      }
      else {
          add_cubecollision_object(enemy,node,screen_w,screen_h, sgroot);
      }
    }

    if (pad->cross.isHold()) {
      SceneGraphIteratorPtr it = sgroot->getIterator(tree);
      collision_red(it,node);
      it = sgroot->getIterator(tree);
      collision_purple(it,node,screen_w,screen_h, sgroot);
    }

    else if(pad->circle.isHold()) {
      SceneGraphIteratorPtr it = sgroot->getIterator(tree);
      lock_attack(node, it, sgroot);
    }

}

void
lock_attack(SceneGraphPtr node,SceneGraphIteratorPtr it, SceneGraphRoot *sgroot)
{

  SceneGraphPtr e;
  SceneGraphPtr near_enemy = NULL;
  float dx,dy,r,range = 100;
  // Pad *pad = sgroot->getController();

  for(;it->hasNext(enemy);) {

      it->next(enemy);
      e = it->get();
      dx = e->xyz[0] - node->xyz[0];
      dy = e->xyz[1] - node->xyz[1];
      r = sqrt(dx*dx+dy*dy);

      if(range > r && e->stack_xyz[2] == 0) {
        range = r;
        near_enemy = e;
      }
  }


  if(near_enemy != NULL) {
    /*stack_xyz[2]をlockonフラグとして使うかな?*/
    SceneGraphPtr lockon;
    //    SceneGraphPtr near_enemy_common_move = near_enemy->parent;
    near_enemy->stack_xyz[2] = 1;
    lockon = sgroot->createSceneGraph("LOCK");
    lockon->set_move_collision(no_move_idle,lockon_collision);
    //near_enemy_common_move->addChild(lockon);
    near_enemy->addChild(lockon);
    }

}

void
lockon_collision(SceneGraphPtr node, void *sgroot_, int w, int h, SceneGraphPtr tree) {
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
  Pad *pad = sgroot->getController();
  SceneGraphPtr lockon_enemy = node->parent;

  /* node->angle[0] = -lockon_enemy->angle[0];
  node->angle[1] = -lockon_enemy->angle[1];
  node->angle[2] = -lockon_enemy->angle[2];*/

  if(pad->circle.isRelease()) {
    lockon_enemy->remove();
  }

}


void
vacuum_move(SceneGraphPtr node, void *sgroot_, int w, int h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if (pad->right.isHold() && w > node->xyz[0]) {
      node->xyz[0] += vacuum_speed;
      node->angle[0] += 2;
    } else if (pad->left.isHold() && 0 < node->xyz[0]) {
      node->xyz[0] -= vacuum_speed;
      node->angle[0] -= 2;
    }

    if (pad->up.isHold() && 0 < node->xyz[1]) {
      node->xyz[1] -= vacuum_speed;
      node->angle[1] -= 2;
    } else if (pad->down.isHold() && h > node->xyz[1]) {
      node->xyz[1] += vacuum_speed;
      node->angle[1] += 2;
    }

    if (pad->start.isPush()) {
      node->xyz[0] = w/2;
      node->xyz[1] = h*0.8;
    }
}



/*cubeをランダムな場所に生成*/
void
add_cubecollision_object(int id,SceneGraphPtr root,int w,int h, SceneGraphRoot *sgroot)
{
    SceneGraphPtr object;
    SceneGraphPtr common_move;

    //common_move = sgroot->createSceneGraph();
    object = sgroot->createSceneGraph(id);
    object->xyz[0] = random()%w;
    object->xyz[1] = random()%h;
    object->set_move_collision(no_move_idle,cube_collision);
    //common_move->addChild(object);
    root->addBrother(object);
}


MainLoopPtr
vacuum::init(Viewer *sgroot, int w, int h)
{
    SceneGraphPtr title;

    sgroot->createFromXMLfile( "xml_file/gamecube.xml");
    sgroot->createFromXMLfile( "xml_file/title.xml");
    sgroot->createFromXMLfile( "xml_file/gameover.xml");

    title = sgroot->createSceneGraph("TITLE");
    title->xyz[0] = w/2;
    title->xyz[1] = h/2;
    title->set_move_collision(no_move_idle, title_collision);

    sgroot->setSceneData(title);

    redcube = sgroot->getSgid("REDCUBE");
    enemy = sgroot->getSgid("ENEMY");

    return sgroot;
}

extern Application *
application() {
    return new vacuum();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

