#ifndef VACUUM_H
#define VACUUM_H

#include <math.h>
#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "Application.h"
#include "MainLoop.h"

class vacuum : public Application {

    MainLoopPtr init(Viewer *viewer, int screen_w, int screen_h);
};


extern void cube_move_left(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
extern void cube_move_right(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
extern void no_move_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
extern void cube_collision_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,SceneGraphPtr tree);
extern void cube_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,SceneGraphPtr tree);
extern void cube_split(SceneGraphPtr root,SceneGraphPtr tree, SceneGraphRoot *sgroot);
extern void vacuum_move(SceneGraphPtr node, void *sgroot_, int w, int h);
extern void vacuum_coll(SceneGraphPtr node, void *sgroot_, int w, int h,SceneGraphPtr tree);
extern void title_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
extern void title_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,SceneGraphPtr tree);
extern void scene_change(int w,int h,SceneGraphPtr node);
extern void gameover_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
extern void gameover_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,SceneGraphPtr tree);
extern void collision_red(SceneGraphIteratorPtr it,SceneGraphPtr node);
extern void collision_purple(SceneGraphIteratorPtr it,SceneGraphPtr node,int w,int h, SceneGraphRoot *sgroot);
extern void gameover_scene(int w,int h, SceneGraphPtr node, SceneGraphRoot *sgroot);
extern void add_cubecollision_object(int id,SceneGraphPtr root,int w,int h, SceneGraphRoot *sgroot);
extern void lock_attack(SceneGraphPtr node, SceneGraphIteratorPtr it, SceneGraphRoot *sgroot);
extern void lockon_collision(SceneGraphPtr node, void *sgroot_, int w,int h,SceneGraphPtr tree);
extern void cube_rotate(SceneGraphPtr node,int w,int h);

#endif
