#include <math.h>
#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "MainLoop.h"
#include "viewer.h"


// prototype
static void object_move_rotation(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
static void object_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h, SceneGraphPtr tree);
static void object_move_translation(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);

int light_sysswitch = 1;
int light_num = 4;

void LightSysSwitch(Viewer *sgroot) {
  if (light_sysswitch == 1) {
    sgroot->OnLightSysSwitch();
  } else if (light_sysswitch == 0) {
    sgroot->OffLightSysSwitch();
  }
}




static void
object_move_rotation(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();
    if (pad->circle.isPush()) {
	node->set_move_collision(object_move_translation, object_collision);
    }
	if (pad->left.isHold()) {
	    node->angle[1] += 10;
	} else if (pad->right.isHold()) {
	    node->angle[1] -= 10;
	}
	if (pad->up.isHold()) {
	    node->angle[0] += 10;
	} else if (pad->down.isHold()) {
	    node->angle[0] -= 10;
	}


}

static void
object_move_translation(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if (pad->circle.isPush()) {
	node->set_move_collision(object_move_rotation, object_collision);
    }

	if (pad->left.isHold()) {
	    node->xyz[0] -= 10;
	} else if (pad->right.isHold()) {
	    node->xyz[0] += 10;
	}
	if (pad->up.isHold()) {
	    node->xyz[1] -= 10;
	} else if (pad->down.isHold()) {
	    node->xyz[1] += 10;
	}


}


static void
object_collision(SceneGraphPtr node, void *sgroot_, int screen_w, 
	       int screen_h,  SceneGraphPtr tree)
{
//     if (node->xyz[1] > screen_h - object_radius) {
// 		node->xyz[1] = screen_h - object_radius;

// 		vy *= e;
// 		if (vy > -g && vy < 0) {
// 			vy = 0.0;
// 			node->set_move_collision(object_move_idle, object_collision_idle);
// 		}
//     }
}

char *xmlfile;
#define MAX_ROOT 100
char *parts[MAX_ROOT ];
int parts_cnt;

MainLoopPtr 
viewer::init(Viewer *sgroot, int screen_w, int screen_h)
{

    LightSysSwitch(sgroot);

    SceneGraphPtr object;

    for (int i = 0; i < light_num; i++) {
        SceneGraphPtr light = sgroot->getLight(i);
	sgroot->OnLightSwitch(i);
	light->xyz[0] = screen_w / 2;
	light->xyz[1] = screen_h / 2;
	light->xyz[2] = -100;
    }


    // 固定した値で srandom すると、毎回同じ、random() 列が生成される
    // random な値が欲しいなら、man random に方法が書いてあります。
    srandom(100);

    sgroot->createFromXMLfile(xmlfile);

    object = sgroot->createSceneGraph();
    object->set_move_collision(object_move_rotation, object_collision);

    object->xyz[0] = screen_w/2;
    object->xyz[1] = screen_h/2;;
    object->xyz[2] = 30.0f;

    for(int i=0;i<parts_cnt; i++) {
        object->addChild(sgroot->createSceneGraph(parts[i]));
    }
    sgroot->setSceneData(object);

    return sgroot;
}

extern Application *
application() {
    return new viewer();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);


    for(int i=0;i<argc;i++) {
        if (strcmp(argv[i],"-sg") == 0 && i+1<=argc) {
            xmlfile = argv[i+1];
        } else if (strcmp(argv[i],"-name") == 0 && i+1<=argc) {
            parts[parts_cnt++] = argv[i+1];
        } else if (strcmp(argv[i],"-lightsys") == 0 && i+1<=argc) {
	    if (strcmp(argv[i],"on") == 0) {
	      light_sysswitch = 1;
	    } else if (strcmp(argv[i],"off") == 0) {
	      light_sysswitch = 0;
	    }
	} else if (strcmp(argv[i],"-lightnum") == 0 && i+1<=argc) {
	    light_num = atoi(argv[i+1]);
	}
    }
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */

